#!/bin/bash

path='/home/pi/CAFCA/data/.settings'
declare -a options=()
declare -a items=()

options+=("ACTION" "" ON); options+=("SCANMODE" "" OFF)
option=$(whiptail --radiolist "SELECT CAFCA OPTION" 0 0 0 "${options[@]}" 2>&1 1>$(tty)); #echo "$?"; exit; echo "$option"

if [ $? -eq 0 ]; then
  active=$(sed -n "/${option}/ { s/\(.*\)=//g; s/\x27//g; p }" $path)

  if [[ $option == ACTION ]]; then
    for i in DUMP SCAN; do [[ "$i" == "$active" ]] && items+=("$i" "" ON) || items+=("$i" "" OFF); done
  elif [[ $option == SCANMODE ]]; then
    for i in MAN AUTO; do [[ "$i" == "$active" ]] && items+=("$i" "" ON) || items+=("$i" "" OFF); done
  fi

  choice=$(whiptail --radiolist "SET CAFCA $option" 0 0 0 "${items[@]}" 2>&1 1>$(tty))
  if [ $? -eq 0 ]; then
    whiptail --title "SUCCESS" --msgbox "$option='$choice'" 0 0 0 2>&1 1>$(tty)
    sudo sed -i "/$option=/ s/=\(.*\)/=\x27${choice}\x27/" "$path"
  fi
fi

cat $path

#echo "active: $active"

#[[ "$option" == @(ACTION|SCANMODE) ]] && echo MATCH

#if [[ "$option" == @(ACTION|SCANMODE) ]]; then
#  items=()
#  active=$(sed -n "/${option}/ { s/\(.*\)=//g; s/\x27//g; p }" $path)
#
#  if [[ $option == ACTION ]]; then
#    for i in DUMP SCAN; do [[ "$i" == "$active"]] && items+=("$i" "" ON) || items+=("$i" "" OFF); done
#  elif [[ $option == SCANMODE ]]; then
#    for i in MAN AUTO; do [[ "$i" == "$active"]] && items+=("$i" "" ON) || items+=("$i" "" OFF); done
#  fi
#  choice=$(whiptail --radiolist "SET CAFCA $option" 0 0 0 "${items[@]}" 2>&1 1>$(tty)); echo "$option == $choice"
#fi
