#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$HOMEDIR/ADMIN/MENU/.assets"
index="$assets_path/index"

declare -a entries=()
declare -a last_items=()

level=0; offset=1; start=0
choice='0: '; level_index=''; nav_string=''

source "$assets_path/helpers/commands.sh"; commands_set_globals

# ------------------------------------------------------------------------------------------------------------

Init() {
  declare -g blanktime=$(cat /sys/module/kernel/parameters/consoleblank)
  declare -g console=$(sed -n '/console=/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")
  local boot_games_menu=$(sed -n '/boot_games_menu/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")

  sudo -u pi bash -c "dialog --create-rc /home/pi/.dialogrc; cp -f /home/pi/ADMIN/MENU/.assets/config/.dialogrc /home/pi/.dialogrc"

  menuSaver 60 &

  if [[ "${ARG^^}" == BOOT ]]; then
    [[ $boot_games_menu -eq 1 ]] && [[ "${commands[@]}" =~ run_games_menu ]] && run_games_menu BOOT
  fi

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode admin
  sudo setterm --cursor off

  loadSettings
  #setBlankTime "$(( t_blank / 60 ))"
  setBlankTime 0 #"$(( t_blank / 60 ))"

  [[ $mono_colors -eq 1 ]] && export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
  [[ $TERM == linux ]] && echo -en "\e]P7C0C0C0"

  printf '' > "$DIR/.log/errors.log"
  trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

  clear
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Menu() {
  level_index=$(grep -v '^$\|^\s*#' $index | grep -Pn "^(\t){$level}[[:graph:]].*$")
  items=$(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}')
  entries=()

  for n in $(seq 1 $(echo "$items" | wc -l)); do item=$(echo "$items" | awk -v n="$n" 'NR==n' | sed 's/\t//g;s/\(.*\)://g' | sed '/\]$/! s/$/ >/g;/\]$/ s/[][]\(.*\)//g'); entries+=("$n" "$item"); done

  offset=$( whiptail --title "A R C A N G E L" --menu "$(navString)" $MENU_H $MENU_W 8 "${entries[@]}" 3>&2 2>&1 1>&3 ); exit_code=$?

  [[ $exit_code -gt 0 ]] && [[ $level -lt 1 ]] && exit

  if [[ $offset -le $(echo "$items" | wc -l) ]]; then
    if [[ ${#offset} -gt 0 ]]; then
      if [[ ! $(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g') =~ .*"[".* ]]; then
        (( level++ ))
        last_items[$level]="$choice"; choice=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
      else
        line=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g');
        id=$(echo "${line##*:}" | sed 's/[][]\(.*\)//g')
        cmd=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/;s/\x27//g' | cut -d' ' -f1)
        params=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/;s/\x27//g' | cut -d' ' -f2-)
        runCmd "$cmd" "$params"
      fi
    else
      choice="${last_items[$level]}"
      unset last_items[$level]
      (( level-- ))
    fi
    start=${choice%%:*}
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

runCmd() {
  local ARGS=("${@}")
  local CMD="${ARGS[0]}"; local params="${ARGS[@]:1}"

  [ ${#CMD} -lt 1 ] && return; clear

  [ ! -z $CMD ] && [[ "${commands[@]}" =~ "$CMD" ]] && $cmd "${params}" 3>&1 1>&2 2>"$DIR/.log/errors.log"

  checkErrors
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkErrors() {
  local errors=$(cat "$DIR/.log/errors.log" | wc -l)
  [[ $errors -gt 0 ]] && whiptail --msgbox "$(echo -e "ERRORS:\n"; cat $DIR/.log/errors.log)" 0 0 2>&1 1>/dev/tty
  printf '' > "$DIR/.log/errors.log"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navString() {
 nav_string="$(echo -e '\nMENU ')"

 if [[ $level -gt 0 ]]; then
   nav_string+="> "
   for i in "${last_items[@]:2}"; do nav_string+="$( echo "${i##*:}" | sed 's/ //g') > "; done
   nav_string+="${choice##*:}"
 fi
 echo "$nav_string"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

loadSettings() {
  while read line; do
    key=$(echo "$line" | cut -d= -f1)
    val=$(echo "$line" | cut -d= -f2- | sed "s/'//g")
    declare -g "${key}"="$val"; #echo "$key : $val"
  done< <(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { s/#.*$//; /^\s*$/d; p }' "$assets_path/.settings")
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setBlankTime() { [[ $# -gt 0 ]] && [[ $1 =~ ^[0-9]+$ ]] && echo -ne "\033[9;$1]" > "$console"; }

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

menuSaver() {
  local timeout=${1:-60}
  local elapsed=$(cat /tmp/elapsed.fifo)
  local elapsed_last=$elapsed
  local saver_state=0
  local asleep=0
  local saver_pid=
  local stored_mode='admin'

  printf '\010' > /tmp/vkbdd.fifo

  while true; do IFS=$'\n' read -sr elapsed >/dev/null 2>&1
    if [[ ! $(pgrep -c retroarch) -gt 0 ]]; then
      if [[ $elapsed =~ ^[0-9]+$ ]]; then
        if [[ $saver_state -eq 0 ]] && [[ $elapsed -ge $timeout ]]; then saver_state=1;
          [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; }
          stored_mode=$(sed -n '1 {s/\(^.*\t\)//g;p}' "$HOMEDIR/ADMIN/.sys/thd/devices.log")
          sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode saver
          sudo bash "$assets_path/saver/bgSaver.sh" & saver_pid=$!
        elif [[ $saver_state -eq 1 ]]; then
          if [[ $elapsed -lt $elapsed_last ]]; then saver_state=0
            [[ $asleep -eq 1 ]] && { echo "ASLEEP 0" > /tmp/serial.fifo; asleep=0; }
            sudo pkill -f 'bgSaver'; saver_pid=
            [ -f "$assets_path/fb0.dump" ] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; }
            [[ $(pgrep -c ffplay) -gt 0 ]] && sudo pkill ffplay
            sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode $stored_mode;
            sudo setterm --blank poke --term linux </dev/tty1; printf '\010' > /tmp/vkbdd.fifo;
          else
            if [[ $asleep -eq 0 ]] && [[ $(pgrep -fc 'bgSaver') -lt 1 ]]; then
              declare -c exit_code=$(cat "$assets_path/saver/exit_code");
              [[ $exit_code -eq 0 ]] && [[ $(pgrep -c ffplay) -lt 1 ]] && { echo "ASLEEP 1" > /tmp/serial.fifo; asleep=1; printf '' > "$assets_path/saver/exit_code"; }
            fi
          fi
        fi
        elapsed_last=$elapsed
      fi
    elif [[ $(pgrep -c retroarch) -gt 0 ]]; then
      [[ $(pgrep -fc 'bgSaver') -gt 0 ]] && sudo pkill -f 'bgSaver'; saver_pid=
      [[ $(pgrep -c ffplay) -gt 0 ]] && sudo pkill ffplay
      [[ $(pgrep -c omxplayer) -gt 0 ]] && sudo pkill omxplayer
    fi
    sleep 0.1
  done< <( cat <>/tmp/elapsed.fifo )
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  local signal=$1
  [ -f "$HOMEDIR/.dialogrc" ] && sudo rm "$HOMEDIR/.dialogrc"

  JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && { sudo kill -9 "${JOBS[@]}"; } >/dev/null 2>&1
  sudo pkill -f 'bgSaver' >/dev/null 2>&1

  #sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term # ADD

  [[ $TERM == linux ]] && echo -en "\e]P700FC00" #[[ $TERM == linux ]] && export PS1="$(cat /boot/sys_settings | grep -w -m1 'VAR PS_str' | cut -d\' -f2)" #export PS1="$PS1_STORED"

  [[ $(pgrep -fc 'bgSaver') -gt 0 ]] && sudo pkill -f 'bgSaver'
  [[ $(pgrep -c ffplay) -gt 0 ]] && sudo pkill ffplay
  [[ $(pgrep -c omxplayer) -gt 0 ]] && sudo pkill omxplayer

  echo "ASLEEP 0" > /tmp/serial.fifo
  echo "VFD 4  G O O D B Y E" > /tmp/serial.fifo

  setBlankTime "$(( blanktime / 60 ))"
  export PS1="$PS1_STORED"; stty -F /dev/tty1 sane ; sudo setterm --cursor on

  clear
  exit $signal
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init

while true; do Menu; done

exit


# ------------------------------------------------------------------------------------------------------------
