#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
SCRIPT_DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
DIR="$HOMEDIR/ADMIN/.backup"
NEWDIR="$(date '+%F_%T' | sed 's/:/-/g')"

# ---------------------------------------

exec > >(sudo tee "$DIR/backup.log") 2>&1
echo -e "\n$(date '+%F %T')\n\nBuilding Archive.\n"

# ---------------------------------------

sudo find "$HOMEDIR" -maxdepth 1 ! -type l ! -type d ! -iname '*.bak*' ! -iname '*bash_history*' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1
sudo find "/boot" -maxdepth 1 ! -type l ! -type d ! -iname '*.elf' ! -iname '*.img' ! -iname '*.dtb' ! -iname '*.dat' ! -iname '*.bin' ! -iname '*.bak*' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1

sudo find "$HOMEDIR/CAFCA" ! -type d ! -iname '*.bak*' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1
sudo find "$HOMEDIR/ADMIN/MENU" ! -type d ! -iname '*.mp4' ! -iname '*.mp3' ! -iname '*.wav' ! -iname '*.jpg' ! -iname '*.png' ! -iname '*.ppm' ! -iname '*.bak*' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1

sudo find "$HOMEDIR/ADMIN/.sys" -maxdepth 1 ! -type d ! -iname '*.bak*' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1
sudo find "$HOMEDIR/ADMIN/.sys/thd" ! -type d ! -iname '*.bak*' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1

for dir in $HOMEDIR/ADMIN/CMD/*; do sudo find $dir -iname '*.bak' -prune -o ! -type d ! -iname '*.bak*' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1; done

sudo find "$HOMEDIR/RetroPie/roms/mame-libretro" ! -type d -iname '*.cfg' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1
sudo find "$HOMEDIR/RetroPie/roms/mame-libretro/mame2003" ! -type d ! -iname '*.xml' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1
sudo find "$HOMEDIR/RetroPie/roms/mame-libretro/mame2003-plus" ! -type d ! -iname '*.xml' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1

sudo find /opt/retropie/configs/all/emulationstation \( -name 'themes' -o -iname '*bak*' \) -prune -o ! -type d ! -iname '*.png' ! -iname '*.jp*g' ! -iname '*.wav' ! -iname '*.mp4' ! -iname '*.mp3' ! -iname '*.json' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1
sudo find /opt/retropie/configs/all/emulationstation/themes/BUBBLEGUM ! -type d ! -iname '*.png' ! -iname '*.jp*g' ! -iname '*.wav' ! -iname '*.mp4' ! -iname '*.mp3' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1

sudo find /opt/retropie/configs/all/retroarch/autoconfig -type f -iname '*.cfg' ! -iname '*.bak*' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1
sudo find /opt/retropie/configs/all/retroarch/config ! -type d ! -iname '*.bak*' -exec 7z a -tzip -spf "$DIR/${NEWDIR}.zip" {} + | grep -ie '^archive size*' 2>&1
sudo 7z a -tzip -spf "$DIR/${NEWDIR}.zip" /opt/retropie/configs/all/autostart.sh | grep -ie '^archive size*' 2>&1
sudo 7z a -tzip -spf "$DIR/${NEWDIR}.zip" /opt/retropie/configs/all/runcommand-onstart.sh | grep -ie '^archive size*' 2>&1
sudo 7z a -tzip -spf "$DIR/${NEWDIR}.zip" /opt/retropie/configs/all/runcommand-onend.sh | grep -ie '^archive size*' 2>&1
sudo 7z a -tzip -spf "$DIR/${NEWDIR}.zip" /home/pi/.config/mc/ini | grep -ie '^archive size*' 2>&1
echo ""

# ---------------------------------------

sudo 7z l "$DIR/${NEWDIR}.zip" | awk '{$1=$1;print}' | awk '{print $4,$6}' | grep -P '^[[:digit:]].*?[/]' | awk '{ printf("%06d %s\n", $1, $2)}' | sort -k1,1 | numfmt --to=si | awk '{print $1"b "$2}' | sed -r 's/([0-9])([a-zA-Z])/\1 \2/g; s/([a-zA-Z])([0-9])/\1 \2/g'; echo "" #| xargs -i printf "bytes: %s\n" {}
echo -e "$(echo $(sudo du -sh $DIR/${NEWDIR}.zip) | cut -d' ' -f1)b total.\n" | sed -r 's/([0-9])([a-zA-Z])/\1 \2/g; s/([a-zA-Z])([0-9])/\1 \2/g'

sudo sshpass -f "$SCRIPT_DIR/.pass" sftp dogenigt@data.dogenigt.dk < <( \
  for cmd in \
    'cd /public_html_data.dogenigt.dk/backup/pi' \
    "mkdir $NEWDIR" \
    "cd $NEWDIR" \
    "put $DIR/$NEWDIR.zip" \
    'quit' ;
  do echo $cmd; done \
) #| grep --color=never -ie '^connected*\|^uploading*'

echo ""
sudo 7z l "$DIR/${NEWDIR}.zip"

exit

# ---------------------------------------

#mkdir "$DIR/${NEWDIR}"
#touch "$DIR/${NEWDIR}/.header"
#sudo 7z a -tzip "$DIR/${NEWDIR}.zip" "$DIR/${NEWDIR}/.header"

# ---------------------------------------

#sudo sshpass -f .pass sftp dogenigt@data.dogenigt.dk < <(for cmd in 'cd /public_html_data.dogenigt.dk/backup/pi' 'dir' 'quit'; do echo $cmd; done )
