#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
ASSETS_DIR="$HOMEDIR/ADMIN/MENU/.assets"
MENU_DIR="$HOMEDIR/ADMIN/MENU/GAMES"

vidLen() {
  local dur=$(ffmpeg -i "$@" 2>&1 | grep "Duration" | cut -d: -f3- | cut -d, -f1 | cut -d. -f1)
  echo "$(( ( $(echo $dur | cut -d: -f1) * 60 ) + $(echo $dur | cut -d: -f2) ))"
}

# 60
t_fbsaver=$(grep -w -m1 '^timeout_fbsaver' "$MENU_DIR/.settings" | cut -d= -f2)

sudo sed -i "s|timeout_slidesaver[=].*$|timeout_slidesaver=$(( t_fbsaver * 2 ))|g" "$MENU_DIR/.settings"
t_slidesaver=$(grep -w -m1 '^timeout_slidesaver' "$MENU_DIR/.settings" | cut -d= -f2)

fbdur=$(cat "$ASSETS_DIR/saver/script_time.log")
sudo sed -i "s|timeout_vidsaver[=].*$|timeout_vidsaver=$(( t_fbsaver + ${fbdur/-/} ))|g" "$MENU_DIR/.settings"
t_vidsaver=$(grep -w -m1 '^timeout_vidsaver' "$MENU_DIR/.settings" | cut -d= -f2)

vid_path=$(grep -w -m1 '^vidsaver_path' "$MENU_DIR/.settings" | cut -d\' -f2)
vid_dur=$(vidLen "$vid_path")

sudo sed -i "s|timeout_sleep[=].*$|timeout_sleep=$(( t_vidsaver + vid_dur ))|g" "$MENU_DIR/.settings"
t_sleep=$(grep -w -m1 '^timeout_sleep' "$MENU_DIR/.settings" | cut -d= -f2)

echo -e "t_fbsaver: $t_fbsaver\nfbdur: ${fbdur/-/}\nt_vidsaver: $t_vidsaver\nvid_dur: $vid_dur\nt_sleep: $t_sleep\nt_slidesaver: $t_slidesaver"




