#!/bin/bash

HOMEDIR='/home/pi'

timeout 2 /opt/retropie/emulators/retroarch/bin/retroarch -v --config /home/pi/ADMIN/.sys/retroarch-boot.cfg --log-file /home/pi/retroarch.log >/dev/null 2>&1

ra_dump=$(grep '\[udev\]' "$HOMEDIR/retroarch.log" | sed 's/\[INFO\]\s\[udev\]:\s//g')
names=($(grep -Ew "by-id" "$HOMEDIR/ADMIN/.sys/.settings" | sed 's/^DEV\s\(.*\)=.*$/\1/'))

for name in "${names[@]}"; do
  path=$(grep -Ew "^DEV $name" "$HOMEDIR/ADMIN/.sys/.settings" | sed 's/\(.*\)=//g; s/\x27//g;s/\/dev\/input\/by-id\///')
  id=$(ls -la /dev/input/by-id | grep $path | grep -o '[^/]*$')
  title=$(cat "/sys/class/input/$id/device/uevent" | grep --color=never '^NAME' | sed 's/\(.*\)=//g;s/\x22//g')
  ra_index=$(echo "$ra_dump" | grep -w "$id" | sed 's/ (.*$//')
  types=$(ls "/sys/class/input/$id/device" | grep 'js\|mouse' | awk '{printf $0","}' | sed 's/\(.\)$//')
  phys=$(cat "/sys/class/input/$id/device/phys")
  port=$(echo "$ra_dump" | grep -m1 "$title" | sed 's/\(.*\)on\s//;s/\(.\)$//;s/\s#//')
  echo -e "'${name^^}' '$id' '$title' '$ra_index' '${phys#*.}' '[$types]'" #/dev/input/by-id/$path\n"
  #echo -e "'${name^^}'\t'$id'\t'$title'\t'$ra_index'\t'${phys#*.}'\t'[$types]'" #/dev/input/by-id/$path\n"
done | sudo tee "$HOMEDIR/dump" >/dev/null 2>&1

cat "$HOMEDIR/dump"
exit

