#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

SCRAPER='/opt/retropie/supplementary/skyscraper/Skyscraper'
gamelist="$DIR/gamelist.xml"

# ----------------------------------------------------------------------------------------------

sudo cp "$HOMEDIR/.emulationstation/gamelists/mame-libretro/gamelist.xml" "$DIR/gamelist.xml"
sudo cp "$HOMEDIR/.emulationstation/gamelists/mame-libretro/gamelist.xml" "$DIR/gamelist_copy.xml"; sed -i '$d' "$DIR/gamelist_copy.xml"

# ----------------------------------------------------------------------------------------------

#comment() {
# Scrape
$SCRAPER \
  -p mame-libretro \
  -s screenscraper \
  -i "$HOMEDIR/RetroPie/roms/mame-libretro" \
  -g "$DIR" \
  -a "$HOMEDIR/.skyscraper/artwork.xml" \
  --flags unattendskip \
  --includefrom "$DIR/list.txt"

# Make gamelist
$SCRAPER \
  -p mame-libretro \
  -i "$HOMEDIR/RetroPie/roms/mame-libretro" \
  -g "$DIR" \
  -a "$HOMEDIR/.skyscraper/artwork.xml" \
  --flags unattend
#}
# ----------------------------------------------------------------------------------------------

sudo cp -f "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.list" "$DIR/.list.old"

cat "$DIR/.list.old" | awk '{$1=""; print}' | sed 's/ //' | sudo tee "$DIR/.list.new" >/dev/null 2>&1

cleanString() { local input="${1}"; local word="${2}"; echo "$input" | grep -E "<$word>" | awk '{$1=$1;print}' | sed "s/<$word>//g; s/<\/$word>//g"; }

# ----------------------------------------------------------------------------------------------

game_count=$(grep -Ec '<game>' "$gamelist")

for (( n=1; n<=$game_count; n++ )); do
    data=$(awk -v p="<game>" -v n="$n" '$0~p{i++}i==n' "$gamelist");
    path=$(cleanString "$data" 'path'); path=$(echo "$path" | cut -d\/ -f2-)
    name=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)

    if [[ $(grep -c "$name" "$DIR/list.txt") -gt 0 ]] && [[ ${#data} -gt 0 ]]; then
      title=$(cleanString "$data" 'name' | sed "s/\x27//g")
      date=$(cleanString "$data" 'releasedate');date="${date:0:4}"; [[ ${#date} -lt 1 ]] && date='19xx'
      publisher=$(cleanString "$data" 'publisher');publisher=$(echo "$publisher" | cut -d, -f1); [[ ${#publisher} -lt 1 ]] && publisher='<unknown>'
      type='JOY'

      img_path="$HOMEDIR/ADMIN/MENU/.assets/media/slideshow/mame-libretro/$name"; images=''
      images=$(find "$img_path" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit 2>/dev/null)
      [ -n "$images" ] && images="${images##*.}"

      echo "'$name' '$title' '$date' '$publisher' '$type' '$rom_dir/$path' '$images' '[ ]"

      [[ $(grep -c "<path>$path</path>" "$DIR/gamelist_copy.xml") -lt 1 ]] \
        && echo "${data}" | sed 's/^/\t/' | sudo tee -a "$DIR/gamelist_copy.xml" >/dev/null 2>&1
    fi

done | sudo tee "$DIR/new_entries" &>/dev/null

# ----------------------------------------------------------------------------------------------

for entry in $(cat "$DIR/list.txt" | grep -o '[^/]*$' | sed 's/[.].*$//g'); do
  line=$(grep "$entry" "$DIR/new_entries")
  [ ${#line} -gt 0 ] && echo "$line" | sudo tee -a "$DIR/.list.new" &>/dev/null
done

sleep 1

tac "$DIR/.list.new" | sort -k4,4 -t \' --output "$DIR/.list.new"
grep -n '' "$DIR/.list.new" | sed 's/:/ /' | sudo tee "$DIR/.list.new"

sed -i '/^.*<\/gameList>.*$/ s/.*$/<\/gameList>/' "$DIR/gamelist_copy.xml"

# ----------------------------------------------------------------------------------------------

exit
