#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

[ "$(id -u)" -ne 1000 ] && exit

declare -a files=()

torrent_file="$HOMEDIR/ADMIN/FILES/TORRENTS/mame078_romset.torrent"
download_dir="$HOMEDIR/downloads"
torrent_dir="$download_dir/MAME2003_Reference_Set_MAME0.78_ROMs_CHDs_Samples/roms"
output_dir="$DIR/roms"
#download_dir="$HOMEDIR/ADMIN/CMD/DOWNLOADER"

# --------------------------------------------------------------------------------------

clear; echo "Starting transmission.."
transmission-daemon #--logfile "$DIR/transmission.log"
trap 'sudo service transmission-daemon stop && sudo pkill -f "transmission-daemon" 2>/dev/null; exit' INT SIGINT EXIT
#trap 'sudo service transmission-daemon stop && sudo pkill -f "transmission-daemon" 2>/dev/null; sudo rm "$DIR/torrent.dump" 2>/dev/null; exit' INT SIGINT EXIT

[[ $(transmission-remote -l | grep -c MAME) -gt 0 ]] && { id=$(transmission-remote -l | grep -m1 'MAME2003_Reference_Set*' | awk '{$1=$1; print $1}'); transmission-remote -t $id -r; sleep 1; }
transmission-remote -a $torrent_file; transmission-remote -l
id=$(transmission-remote -l | grep -m1 'MAME2003_Reference_Set*' | awk '{$1=$1; print $1}')

transmission-remote -t $id -Gall
transmission-remote -t $id -f | grep -we 'roms' | sed 's/:.*\/roms\// /' | sudo tee "$DIR/torrent.dump" &>/dev/null

sed 's/\([[:digit:]]\) \+\([[:alnum:]]\)/\1_\2/g' "$DIR/torrent.dump" | grep -v '^.*.chd\|^.*.png' | pr -10T -s' ' | column -t | sed 's/_/ /g'; sleep 1
echo -e "\nWrite id(s) to add.\nENTER to start; ESC to exit.\n"

while true; do read -r -N 1 a; case $a in $'\n') echo "DOWNLOADING"; break ;; $'\E') echo "QUIT"; exit ;; *) read -r b; [[ $a$b =~ ^[0-9]+$ ]] && { files+=($((10#$a$b))); } ;; esac; done

file_list=$(IFS=,; echo "${files[*]}")
log=

if [[ ${#files[@]} -gt 0 ]]; then

  [ -d $torrent_dir ] && sudo rm $torrent_dir/*
  [ -d $output_dir ] && sudo rm $output_dir/*

  #sudo -- bash -c 'sudo rm /root/Downloads/MAME2003_Reference_Set_MAME0.78_ROMs_CHDs_Samples/roms/*.*'
  #sudo rm $output_dir/*
  #[ -d $download_dir ] && sudo rm -R $download_dir 2>/dev/null
  #sudo find $torrent_dir -maxdepth 1 -type f -exec rm {} \;

  transmission-remote -t $id -g$file_list
  transmission-remote -t $id --start

  while true; do
    log="$(transmission-remote -t $id -f | awk '{if ($4 ~ "Yes") print;}')";
    for p in $(echo "$log" | awk '{gsub(/%/,"", $2);print $2}'); do [[ $p -lt 100 ]] && { downloading=1; break; }; done
    #clear
    echo -e "Download status:\n"; echo "$log" | awk '{n=split($NF,a,"/"); print $1" "a[n]" "$2}' | column -t; sleep 1;
    [[ $(echo "$log" | grep -c '100%') -eq ${#files[@]} ]] && break
  done
fi

while [[ $(sudo find $torrent_dir/ -type f -iname '*.part' | wc -l) -gt 0 ]]; do :; done

echo "DONE"

#sudo find $torrent_dir -maxdepth 1 -type f -exec cp -v {} $output_dir \;
#for rom in $(echo "$log" | awk -v dir="$download_dir" '{print dir"/"$NF}'); do sudo cp -f "$rom" "$output_dir"; done
#sudo cp -Rf $torrent_dir $DIR/

sudo find $torrent_dir -maxdepth 1 -type f -iname '*.zip' -exec cp -v {} $output_dir \;
sudo chmod 775 $output_dir

exit
