#!/bin/bash

ARG="$@"; PID=$$; PS1_STORED=$PS1

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# PATHS

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$DIR/.assets"
media_path="$assets_path/media"
list_path="$assets_path/GAMES/.list"
font="$assets_path/fonts/Calvin_S.flf"

serial_path=$(sed -n '/fifo_com/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")
roms_path=$(sed -n '/dir_roms/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

console=$(sed -n '/console=/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")
prev_state=$(sed -n '/UI=/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.states")
width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 ))
height=$(echo "$(tput lines)"); maxPage=$(( height - 3 ))

declare -A pageTitles=();

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init() {
  loadSettings

  for arr in pages list indexes offsets headers; do declare -ag "${arr}"; done
  for var in navigated idle_count pageIndex page offset active prev total_files vpos header_height page_changed marquee_on; do declare -g "${var}"=0; done

  createPages

  [[ $remap -eq 1 ]] && { declare -Ag remaps=(); for rmp in `echo ${remapping}`; do remaps["${rmp%%=*}"]="${rmp##*=}"; done; }
  [[ $hide_term -eq 1 ]] && { PS1=; stty -F /dev/tty1 -echo; sudo setterm --cursor off; }

  [ -f "$assets_path/fb0.dump" ] && { sudo rm "$assets_path/fb0.dump"; }

  trap 'exitFunc' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick

  initSpin

  sed -i "/ACTIVE_GAME/ s/[=].*$/=\'\'/" "$HOMEDIR/CAFCA/data/.settings"
  sed -i "/UI=/ s/[=].*$/=\x27GAMES\x27/" "$HOMEDIR/ADMIN/.sys/.states"
  #sed "/UI=/ s/[=].*$/= \x27$(ps -p $pid -o command= | grep -o '[^ ]*$')\x27/" /home/pi/ADMIN/.sys/.states
  sendSerial "$( (( test_mode )) && echo 'VFD 0 EDIT MODE' || echo 'VFD 5     G A M E S' )"

  declare -g blanktime=$(cat /sys/module/kernel/parameters/consoleblank)
  #setBlankTime "$((t_blank/60))"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main() {
  Init
  setPage

  while true; do
    input=$(readInput)

    if [[ ${#input} -gt 0 ]]; then
      navigate "${input}"
    else (( idle_count++ ));
      [[ $idle_count -gt "$(( t_title * 10 ))" ]] && showTitle
    fi
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navigate() {
  local key="${@}"

  [[ $remap -eq 1 ]] && [[ ! -z "${remaps[$input]}" ]] && key="${remaps[$input]}"

  if [[ $test_input -lt 1 ]]; then navigated=1;
    case "${key}" in
      'SPACE')  showMarquee "$(( ! $marquee_on ))" ;;
      *)
        [[ $marquee_on -eq 1 ]] && showMarquee 0

        case "${key}" in
          'UP')     prev=$active; (( active-- )); checkList ;;
          'DOWN')   prev=$active; (( active++ )); checkList ;;
          'LEFT')   (( pageIndex-- )); changePage ;;
          'RIGHT')  (( pageIndex++ )); changePage ;;
          'PGUP')   [[ ${#offsets[@]} -gt 1 ]] && { (( offset-- )); makeList; drawScreen; } ;;
          'PGDOWN') [[ ${#offsets[@]} -gt 1 ]] && { (( offset++ )); makeList; drawScreen; } ;;
          'ENTER')  launchGame ;;
          'START')  launchGame ;;
          'ESC')    exit ;;
        esac
        ;;
    esac
  else echo "$input -> $key";
  fi

  idle_count=0; title_shown=0
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

launchGame() {
  local entry=$(( ${offsets[$offset]} + active )); idx=${indexes[$entry]}
  local path=$(sed "${idx}q;d" "$list_path" | cut -d\' -f12)
  local type=$(sed "${idx}q;d" "$list_path" | cut -d\' -f10)

  if [ -f "$path" ]; then
    local system=$(echo "$path" | cut -d/ -f6)
    local game=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)

    if [[ $type == SPIN ]]; then
      if [[ $(grep -c "$game" "$assets_path/GAMES/.spinners") -gt 0 ]]; then
        ( while read val; do echo "$val" > /tmp/serial.fifo; sleep 1; done< <(grep "$game" "$assets_path/GAMES/.spinners" | sed 's/\t/ /g' | awk '{print "SPIN_SENS "$2; print "SPIN_SPEED "$3}') ) &
      else
        sendSerial "SPIN_SENS 72"; sendSerial "SPIN_SPEED 1"
      fi
    fi

    ( sleep 5; showTitle ) &

    sudo sed -i "/ACTIVE_GAME/ s/[=].*$/=\'${system}\/${game}\'/" "$HOMEDIR/CAFCA/data/.settings"
    sudo sed -i "/UI=/ s/[=].*$/=\x27retroarch\x27/" "$HOMEDIR/ADMIN/.sys/.states"

    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode game
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove spinner

    setBlankTime 0
    sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!

    sudo -u pi bash -c "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} ${system} dummy"; sudo setterm --cursor off

    sudo sed -i "/ACTIVE_GAME/ s/[=].*$/=\'\'/" "$HOMEDIR/CAFCA/data/.settings"
    sudo sed -i "/UI=/ s/[=].*$/=\x27GAMES\x27/" "$HOMEDIR/ADMIN/.sys/.states"

    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
    initSpin

    [[ "${system}" == mame-libretro ]] && checkCfg "${game}"
    [ -f "$assets_path/fb0.dump" ] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; }

    drawScreen; navigated=0
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkCfg() {
  [ $# -lt 1 ] && return
  local game="${1}"
  local cfg_path="$HOMEDIR/CAFCA/cfg/.backup/mame-libretro"
  local cfg_bak=$(find "$cfg_path/mame2003/cfg" -maxdepth 1 -type f -iname "${game}.cfg.bak*" -printf '%TY-%Tm-%Td %TT %p\n' 2>/dev/null | sort | tail -n 1 | grep -o '[^ ]*$')
  local cfg_new="$roms_path/mame-libretro/mame2003/cfg/${game}.cfg"

  [ -f "$cfg_bak" ] && { diff "$cfg_new" "$cfg_bak" >/dev/null 2>&1; status=$?; } || { status=1; }
  [[ $status -gt 0 ]] && { sudo cp "$cfg_new" "$cfg_path/mame2003/cfg/${game}.cfg.bak$(date +%y%m%d%H%M%S)"; } #echo -e "VFD 7   CFG CHANGED" > /tmp/serial.fifo; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

makeList() {
  clear
  [[ $show_header -eq 1 ]] && header

  offset=$(( offset % ${#offsets[@]} ))
  list=(); active=0

  for x in $(seq ${offsets[$offset]} $(( (${offsets[$offset]} + maxPage)-1 ))); do
    [[ $x -ge $total_files ]] && break;
    title=$(sed "${indexes[$x]}q;d" "$list_path" | cut -d\' -f4 | awk -F'  |\(' '{if (NF < 3){ print $1 } else { print $1,"("$3}}')
    list+=("$title")
  done

  for i in $(seq 0 $(( ${#list[@]}-1 ))); do printer "${list[$i]}" 0; done

  [[ $show_footer -eq 1 ]] && footer
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkList() {
  if [[ $active -lt 0 ]]; then
    [[ ${#offsets[@]} -gt 1 ]] && { (( offset-- )); makeList; active=$((${#list[@]}-1)); } || { active=0; }
  elif [[ $active -ge ${#list[@]} ]]; then
    [[ ${#offsets[@]} -gt 1 ]] && { (( offset++ )); makeList; active=0; } || { active=${#list[@]}; }
  fi

  drawScreen
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

drawScreen() {
  tput sc; tput cup $(( vpos + prev )) 0;   printer "${list[$prev]}" 0; tput rc
  tput sc; tput cup $(( vpos + active )) 0; printer "${list[$active]}" 1; tput rc
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

changePage() {
  pageIndex=$(( pageIndex % ${#pages[@]} )); page="${pages[$pageIndex]}"
  setPage; page_changed=1; navigated=0
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setPage() {
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}'  "$list_path")); total_files=${#indexes[@]};
  offsets=($( for x in $(seq 0 $maxPage $(( ${#indexes[@]} - 1))); do echo $x; done)); offset=0

  makeList; drawScreen
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sortPages() { pages=();
  for i in $(seq 1 $#); do [[ "${!i}" == $start_page ]] && { shift $((i-1)); break; } || pages+=("${!i}"); done; pages=( "${@}" "ALL" "${pages[@]}" )
  for p in $(seq 0 $(( ${#pages[@]}-1))); do [[ "${pages[$p]}" == "${start_page}" ]] && { pageIndex=$p; page="${pages[$pageIndex]}"; }; done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

createPages() {
  local key=; local str=; local text=;
  local w=$(( width - 2 ))
  while read line; do key="${line%%=*}"; str="${line##*=}"; pageTitles["${key}"]="${str//\"/}"; done< <(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^page_titles/ { s/^[^=]*=//; s/\x27//g; s/\s*$//; p; q } }' "$assets_path/.settings" | sed 's/[,]/\n/g' | awk '{$1=$1;print}')
  declare -ag pages=($(sed -n '/\[ \([^]]*\) \]/ { s/.*\[ \([^]]*\) \].*/\1/; s/ /\n/g;/^$/d; p }' $list_path | sort -u));

  sortPages "${pages[@]}"

  for p in $(seq 0 $(( ${#pages[@]}-1))); do
    str=$(printf "${pageTitles[${pages[$p]}]}" | sed 's/8/B/g; s/0/O/g'); text=$(printf "$(figlet -w $w -c ${str,,} -f $font)"); headers+=("$(printf "${text}")");
    [ $header_height -eq 0 ] && { header_height="$( echo "${headers[-1]}" | wc -l)"; maxPage=$(( maxPage - ( $header_height + 2 ) )); }
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

header() {
  local text=$(printf "${headers[$pageIndex]}"); [[ $colors -gt 0 ]] && text=${C}${text}${NC}
  local line=$(printf "$(for i in $(seq 0 $(( width-1 ))); do printf "${line_char:-.}"; done)"); [[ $colors -gt 0 ]] && line=${C}${line}${NC}

  tput cup 0 0; echo "${text}"; vpos=$header_height
  tput cup $vpos 0; printf "${line}"; (( vpos+=2 ))
  tput cup $vpos 0; tput sc
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

footer() {
  local msg="~ $total_files GAMES"
  local line=$(printf "$(for i in $(seq 0 $(( width-1 ))); do printf "${line_char:-.}"; done)")
  local info=$(echo "$(for x in $(seq 0 ${#offsets[@]});do [[ ${offsets[$x]} =~ ${offsets[$offset]} ]] && { echo $((x+1));break; };done) / ${#offsets[@]}")
  local spacing=$(( ${#info}+1 ))
  local bottom=$(( $(tput lines)-3 ))

  [[ $colors -gt 0 ]] && { info=${C}${info}${NC}; msg=${C}${msg}${NC}; line=${C}${line}${NC}; }

  tput sc
  tput cup $bottom 0; echo "${line}"
  tput cup $((bottom+2)) 0; printf "${msg}"
  tput cup $((bottom+2)) $(( width-spacing )); printf "${info}";
  tput rc
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

readInput() {
  Event=''
  read -rs -N 1 -t 0.1 Event1 >/dev/null

  [[ $? -gt 127 ]] && return

  case "$Event1" in
    $'\163')        Event="START" ;;
    $'\n')            Event="ENTER"   ;;
    ' ')              Event="SPACE"   ;;
    [[:blank:]])      Event="TAB"     ;;
    *)
      read -rsn5 -t 0.01 Event2 >/dev/null

      case "$Event2" in
        "[A")         Event="UP"      ;;
        "[B")         Event="DOWN"    ;;
        "[D")         Event="LEFT"    ;;
        "[C")         Event="RIGHT"   ;;
        "[5~")        Event="PGUP"    ;;
        "[6~")        Event="PGDOWN"  ;;
        "OS"|"[[D")   Event="F4"      ;;
        *)
          case "$Event1$Event2" in
            $'\E')    Event="ESC"     ;;
          esac
          ;;
      esac
  esac

  printf "${Event}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showTitle() {
  local title=''

  if [[ $navigated -eq 1 ]]; then
    title=$(awk -F'\x27' -v l="${indexes[$((${offsets[$offset]}+active))]}" 'NR==l {split($4,t," - "); print t[1],"("$6")","["$8"]"}' "$list_path")
    sendSerial "VFD 1 $title"
    page_changed=0; navigated=0
  elif [[ $page_changed -eq 1 ]]; then
    title="${pageTitles[$page]}"
    sendSerial "VFD 1 _.\xb7\xab\xb0\xa4  $title  \xa4\xb0\xbb\xb7._"
    page_changed=0
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showMarquee() {
  local name=$(awk -F'\x27' -v l="${indexes[$((${offsets[$offset]}+active))]}" 'NR==l {print $2}' "$list_path")
  local file=$(find "$media_path/marquees" -type f -iname "$name*.ppm" -print -quit)
  local HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
  local WIDTH=$(cat /sys/class/graphics/fb0/stride)

  if [[ $# -lt 1 ]] || [[ $1 -lt 1 ]]; then
    [ -f "$assets_path/fb0.dump" ] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; }
    marquee_on=0
  elif [[ $1 -gt 0 ]]; then
    if [ -f "$file" ]; then
      H="${file##*/}"; H="${H/.*/}"; H="${H##*_}"; PAD=$(( (HEIGHT - H) / 2 ))
      sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!
      ( dd if="$file" bs=1 skip=$(( WIDTH * PAD )) count=$(( WIDTH * H )) iflag=skip_bytes,count_bytes | dd seek=$(( WIDTH * PAD )) oflag=seek_bytes of=/dev/fb0 ) >/dev/null 2>&1
      marquee_on=1
    fi
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

initSpin() {
  sendSerial "SPIN_SENS 1"; sendSerial "SPIN_SPEED 1"
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --add spinner
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; pad=''; str=''; mark="${2:-0}"

  [[ $colors -gt 0 ]] && str="${C}";
  str+="${txt}"; strlen=${#str}

  if [[ $center -gt 0 ]]; then
    [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 ))
    strlen=$(( strlen / 2 )); length=$(( width / 2 )); length=$(( length - strlen ))
    printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"; str="${pad}${str}";
  [[ $colors -gt 0 ]] && str+="${NC}"

  echo -e "${str}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

loadSettings() {
  while read line; do
    key=$(echo "$line" | cut -d= -f1)
    val=$(echo "$line" | cut -d= -f2- | sed "s/'//g")
    declare -g "${key}"="$val"
  done< <(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { /^page.*$/d; /path$/d; s/#.*$//;/^\s*$/d; s/\s*$//; p }' "$assets_path/.settings")
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  local signal=$1
  local JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove spinner

  [[ $hide_term -eq 1 ]] && { stty -F /dev/tty1 sane; sudo setterm --cursor on; }
  [[ $post_clear -eq 1 ]] && { clear; tput cup 0 0; tput sc; }

  [ ! -z $blanktime ] && setBlankTime "$((blanktime/60))"
  [ -f "$assets_path/fb0.dump" ] && { sudo rm "$assets_path/fb0.dump"; }

  sed -i "/UI=/ s/[=].*$/=\x27${prev_state}\x27/" "$HOMEDIR/ADMIN/.sys/.states"

  export PS1="$PS1_STORED"; exit $signal
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sendSerial() { [ $# -ge 1 ] && echo -e "$@" > $serial_path; }

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setBlankTime() { [[ $# -gt 0 ]] && [[ $1 =~ ^[0-9]+$ ]] && echo -ne "\033[9;$1]" > "$console"; }

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

debug() { [[ $debug -eq 1 ]] && echo -e "$@"; }

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main
exit

# ________________________________________________________________________________________________________________________________________________________________________________________________________

