#!/bin/bash

scriptT=$(( $(date +%s%N) / 1000 ))
log_path='/boot/boot.log'
[ ! -f "$log_path" ] && touch "$log_path"; sudo chmod 775 "$log_path"; sleep 1

#exec > >(sudo tee $log_path >/dev/null) 2>&1
exec > $log_path 2>&1

include_file='/home/pi/ADMIN/.sys/include.sh'
[ -f $include_file ] && source $include_file; include


# SYSTEM VARIABLES
#----------------------------------------------------

#while read line; do
#  nom=$(echo "$line" | cut -d= -f1); path=$(echo "$line" | cut -d\' -f2)
#  declare "${nom}_id"="$path"
#done< <( cat "$HOMEDIR/ADMIN/.sys/.settings" | awk '{$1=""; print $0}' | sed 's/ //' | grep -Ew '^teensy|^joystick|^gun|^udev' )

declare -a devices=($(grep -Ew "by-id" "$HOMEDIR/ADMIN/.sys/.settings" | sed 's/^DEV //;s/\x27//g'))
for dev in "${devices[@]}"; do declare "${dev%=*}_id"="${dev#*=}"; done

teensy_serial="$(ls -lah /dev/serial/by-id | grep -i Teensy | awk -F/ '{print $NF}')"
gun_serial="$(ls -lah /dev/serial/by-id | grep -i GUN | awk -F/ '{print $NF}')"
states_log="$HOMEDIR/ADMIN/.sys/thd/states.log"
thd_devs="$HOMEDIR/ADMIN/.sys/thd/devices"

title_list="$HOMEDIR/ADMIN/.sys/arkade.titles"
boot_mode=$(grep -w boot_mode "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2); boot_mode="${boot_mode,,}"

fifo_path=$(sed -n '/fifo_com/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")

#____________________________________________________

Main() {
   datestring=$(date | cut -c -20)
   echo -e "\nA U T O S T A R T   L O G:"
   echo -e "( $datestring )\n\n"

   # FILE OPERATIONS
   #-------------------------------------------------

     #fifo_path='/tmp/serial.fifo'
     #sudo mkfifo -m 775 /tmp/vmouse.fifo && sleep 1; sudo chown pi:root /tmp/vmouse.fifo
     sudo mkfifo -m 775 /tmp/elapsed.fifo && sleep 1; sudo chown pi:root /tmp/elapsed.fifo
     sudo mkfifo -m 775 /tmp/omxctrl.fifo && sleep 1; sudo chown pi:root /tmp/omxctrl.fifo
     sudo mkfifo -m 775 "$fifo_path" && sleep 1; sudo chown pi:root "$fifo_path" #&& sudo chmod 775 "$fifo_path"

     sudo sed -i '/serial_teensy/ s/DEV serial_teensy[=].*$/'"DEV serial_teensy=\x27\x2Fdev\x2F$teensy_serial\x27"'/' "$HOMEDIR/ADMIN/.sys/.settings"
     sudo sed -i '/serial_gun/ s/DEV serial_gun[=].*$/'"DEV serial_gun=\x27\x2Fdev\x2F$gun_serial\x27"'/' "$HOMEDIR/ADMIN/.sys/.settings"

     sudo cp -r "$thd_devs.default" "$thd_devs.log"

     [ ! -f "$states_log" ] && { sudo touch "$states_log"; } || { printf '\n' | sudo tee "$states_log" &>/dev/null; }
     sudo chown pi:root "$states_log" && sudo chmod 775 "$states_log"

     sudo chown -R pi:root "$HOMEDIR/ADMIN/CMD/THD"; sudo chmod -R 775 "$HOMEDIR/ADMIN/CMD/THD"

     echo -e "`date +%F`\n" > "$HOMEDIR/ADMIN/.log/emulationstation.log"
     echo -e "E M U L A T I O N S T A T I O N   L O G\n" > "$HOMEDIR/ADMIN/.log/es.log"


   # SCRIPTS
   #-------------------------------------------------

     sudo alsactl --file "$HOMEDIR/.config/asound.state" restore

     sudo thd --socket /run/thd.socket --triggers /home/pi/ADMIN/.sys/thd/conf/triggers --user pi --daemon --uinput /dev/uinput --pidfile /home/pi/ADMIN/.sys/thd/pid

     #th_udev=$(timeout 1 evtest 2>&1 | grep --line-buffered -w -m1 triggerhappy | cut -d: -f1); [[ ! $th_udev =~ "/dev/input" ]] && th_udev='/dev/input/event10'

     th_udev=$(for vpath in /sys/devices/virtual/input/input*; do [[ $(cat "$vpath/name") == triggerhappy ]] && ls -la $vpath | grep -o '[^ ]*$' | grep '^event'; done)
     sudo sed -i 's|DEV udev[=].*$|DEV udev='"\x27/dev/input/$th_udev\x27"'|g' "$HOMEDIR/ADMIN/.sys/.settings"

     sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --add teensy --tag "$([[ $mode == es ]] && echo 'teensy_es' || echo 'teensy')"

     #sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab "$spinner_id" --tag spinner
     #[[ $boot_mode == es ]] && { udev_name='udev_es'; teensy_name='teensy_es'; } || { udev_name='udev'; teensy_name='teensy'; }
     #sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --add "$th_udev" --tag "$udev_name"

     sudo bash "$HOMEDIR/ADMIN/.sys/input_info.sh"; echo ""

     retro_joypad_index=$(grep -w -m1 '^joystick' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{print $(NF-2)}' | sed 's/\(.*\)_//'); sudo sed -i "/input_player1_joypad_index/ s/=\s.*$/= \x22${retro_joypad_index:-0}\x22/" "$HOMEDIR/CAFCA/cfg/cafca.cfg"
     retro_mouse_index=$(grep -w -m1 '^spinner' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{print $(NF-2)}' | sed 's/\(.*\)_//'); sudo sed -i "/input_player1_mouse_index/ s/=\s.*$/= \x22${retro_mouse_index:-0}\x22/" "$HOMEDIR/CAFCA/cfg/cafca.cfg"
     retro_gun_index=$(grep -w -m1 '^gun' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{print $(NF-2)}' | sed 's/\(.*\)_//'); sudo sed -i "/input_player1_mouse_index/ s/=\s.*$/= \x22${retro_gun_index:-3}\x22/" "$HOMEDIR/CAFCA/cfg/gun.cfg"

     #spinner_event=$(grep -w -m1 '^spinner' "/home/pi/ADMIN/.sys/.inputs" | awk '{print "/dev/input/"$2}')
     #[[ "$spinner_event" == /dev/input/event* ]] && /usr/bin/evemu-event "$spinner_event" --type EV_MSC --code 1 --value 0 --sync
     #mouse_event=$(grep -w -m1 '^mouse' "/home/pi/ADMIN/.sys/.inputs" | awk '{print $2}')
     #[[ "$mouse_event" == event* ]] && sed "/evemu/ s/event[[:digit:]]/${mouse_event}/" "$HOMEDIR/ADMIN/.sys/thd/conf/triggers/spinner.conf"
     #( sudo bash /home/pi/vmouse.sh & )

     sudo bash "$HOMEDIR/ADMIN/CMD/SERIAL/SERIAL.sh" & sleep 1
     echo "BOOTED 1" > "$fifo_path"
     sudo sed -i '/BOOTED/ s/BOOTED[=].*$/BOOTED=1/' "$HOMEDIR/ADMIN/.sys/.states"

     #echo "SPIN_SENS 72" > "$fifo_path"

     ( keyLogger & )

     echo -e "TEENSY SERIAL: /dev/$teensy_serial\nGUN SERIAL:    /dev/$gun_serial\n"
     sleep 5; system_info

     #( last=$EPOCHSECONDS; while true; do read -sr -t 0.1 input >/dev/null; [[ ${#input} -gt 0 ]] && { last=$EPOCHSECONDS; read -sr -t 1 void >/dev/null; } || { sleep 1; }; echo "$(( $EPOCHSECONDS - $last ))" > /tmp/elapsed.fifo; done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#' |& awk -W interactive '{$1=$1;print $NF}' | grep --line-buffered -vw '/dev/input/event1') & )
}

# _______________________________________________________________________________________________________________

keyLogger() {
  local last=$EPOCHSECONDS;
  local asleep=0

  #local blacklist=($(grep -w '^gun\|^spinner' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{print $2}'))
  local blacklist=$(grep -w '^gun\|^spinner' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{printf $2"|"}' | sed 's/\(.\)$//')

  while true; do read -sr -t 0.1 input >/dev/null;
    [[ ${#input} -gt 0 ]] && [[ ! "${input//*\//}" == @($(echo "${devs}")) ]] && { last=$EPOCHSECONDS; read -sr -t 1 void >/dev/null; } || { sleep 1; }
    #[[ ${#input} -gt 0 ]] && [[ ! "${input//*\//}" == @($(echo "${devs[*]}" | sed 's/ /|/')) ]] && { last=$EPOCHSECONDS; read -sr -t 1 void >/dev/null; } || { sleep 1; }
    #[[ ${#input} -gt 0 ]] && [[ ! "${input//*\//}" == @(event1|event5) ]] && { last=$EPOCHSECONDS; read -sr -t 1 void >/dev/null; } || { sleep 1; }

    echo "$(( $EPOCHSECONDS - $last ))" > /tmp/elapsed.fifo; sleep 0.1
  done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#\|REL\|ABS' |& awk -W interactive '{$1=$1;print}')
}


keyLogger_old() {
  local last=$EPOCHSECONDS;
  local asleep=0
  local dump='/home/pi/.last_key'

  printf '' > $dump

  while true; do read -sr -t 0.1 input >/dev/null;
    if [[ ${#input} -gt 0 ]]; then
      [[ ! "${input}" =~ ^(.*'event1'|.*'event5') ]] && last=$EPOCHSECONDS; read -sr -t 1 void >/dev/null
      [[ $(pgrep -c retroarch) -lt 1 ]] && echo "[$(date +%T)] $input" >> $dump
    else sleep 1;
    fi
    echo "$(( $EPOCHSECONDS - $last ))" > /tmp/elapsed.fifo
  done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#' |& awk -W interactive '{$1=$1;print}')

  #while true; do read -sr -t 0.1 input >/dev/null;
  #  [[ ${#input} -gt 0 ]] && { last=$EPOCHSECONDS; read -sr -t 1 void >/dev/null; [[ $(pgrep -c retroarch) -lt 1 ]] && echo "[$(date +%T)] $input" >> $dump; } || { sleep 1; }
  #  echo "$(( $EPOCHSECONDS - $last ))" > /tmp/elapsed.fifo
  #done< <(thd --dump $(grep '^teensy\|^joystick' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{printf "/dev/input/"$2" "}') | grep -v --line-buffered '^#\|event1\|event5' |& awk -W interactive '{$1=$1;print}')
}

# _______________________________________________________________________________________________________________


system_info() {
   echo -e "BOOT MODE: ${boot_mode}"

   data_model=$(cat /proc/cpuinfo | grep Model | cut -d':' -f2 | sed 's/ //')
   data_serno=$(cat /proc/cpuinfo | grep Serial | cut -d ' ' -f 2 | cut -c 9- | awk '{print "0x" $0}')
   data_os=$(cat /etc/os-release | sed -n '1p' | cut -d\" -f2)
   data_ip=$(hostname -I | cut -d' ' -f1)

   echo -e "\nMODEL:   $data_model\nSERIAL:  $data_serno\nOS:      $data_os\n\nIP ADDR: $data_ip\n"

   sudo systemd-analyze | xargs | sed 's/(//g; s/)//g' | awk -F' ' '{print "BOOT TIMES:\n" $5 "\t\t" $4 "\n" $8 "\t" $7 "\n" $1 "\t\t" $10}'

   STATUS=$(vcgencmd get_throttled | sed -n 's|^throttled=\(.*\)|\1|p')

   if [[ ${STATUS} -ne 0 ]]; then
    echo -n "WARNING: "
     [ $((${STATUS} & 0x00001)) -ne 0 ] && echo "Power is currently Under Voltage" || { [ $((${STATUS} & 0x10000)) -ne 0 ] && echo "Power has previously been Under Voltage"; }
     [ $((${STATUS} & 0x00002)) -ne 0 ] && echo "ARM Frequency is currently Capped" || { [ $((${STATUS} & 0x20000)) -ne 0 ] && echo "ARM Frequency has previously been Capped"; }
     [ $((${STATUS} & 0x00004)) -ne 0 ] && echo "CPU is currently Throttled" || { [ $((${STATUS} & 0x40000)) -ne 0 ] && echo "CPU has previously been Throttled"; }
     [ $((${STATUS} & 0x00008)) -ne 0 ] && echo "Currently at Soft Temperature Limit" || { [ $((${STATUS} & 0x80000)) -ne 0 ] && echo "Previously at Soft Temperature Limit"; }
     echo ""
   fi

   echo -e "\nDISK USAGE:"
   sudo df -h | head -n 2

   #echo -e "\nDEVICES:\n_____________________________________\n"
   #echo -e " SERIAL:\n   TEENSY:   /dev/$teensy_serial\n   LIGHTGUN: /dev/$gun_serial\n"
   #echo -e " INPUTS:\n" #echo -e "teensy_id:\t$teensy_id\njoystick_id:\t$joystick_id\nlightgun_id:\t$gun_id\nudev_id:\t$th_udev\n"

   #if [[ $boot_mode == es ]]; then
   #  es_loaded=0
   #  while [[ $es_loaded -lt 1 ]]; do es_loaded=$(grep -c "device index" "$HOMEDIR/ADMIN/.log/emulationstation.log"); done; sleep 2
   #  echo -e "\n EMULATIONSTATION:"
   #  grep "device index" "$HOMEDIR/ADMIN/.log/emulationstation.log" | awk -F'joystick' '{print $2}' | awk -F'\(|\)' '{parts=split($2,n,","); print " ",n[parts],":", $1}'
   #fi
}

#_______________________________________________________________________________________________________________

# FOR EMULATIONSTATION:

if [[ $boot_mode == es ]]; then
  declare -ga selected=(1 1)
  declare -ga pages=(0 0)
  declare -a KEYS=('ARKADE' 'LIGHTGUN' 'PINBALL' 'CAFCA' 'MAME' 'AMIGA' 'RETROPIE')
  declare -a LENGTHS=(65 51 8)
  declare -a INDEX=(1 1 1 1 1 1 1)

  startup_system=$(grep -wi StartupSystem "$HOMEDIR/.emulationstation/es_settings.cfg" | cut -d\" -f4)
  selection=1; page=0; printed=1
  startT=$(( $(date +%s%N) / 1000 ))

  function dump_menu() {
    pages[0]=$(grep -w -m1 'JOY_POS_X' "$HOMEDIR/ADMIN/.sys/.states" | cut -d= -f2)

    if [[ ${pages[0]} != ${pages[1]} ]]; then
      page=${pages[0]}
      [[ $page -lt 0 ]] && page=$(( 7 + $page ))
      [[ $page -lt ${#LENGTHS[@]} ]] && { sudo sed -i "/JOY_POS_Y/ s/JOY_POS_Y[=].*$/JOY_POS_Y=${INDEX[$page]}/" "$HOMEDIR/ADMIN/.sys/.states"; selected[1]='0'; }
    fi
    pages[1]="${pages[0]}"

    if [[ $page -lt ${#LENGTHS[@]} ]]; then
      selected[0]=$(grep -w -m1 'JOY_POS_Y' "$HOMEDIR/ADMIN/.sys/.states" | cut -d= -f2)

      if [[ ${selected[0]} -ne ${selected[1]} ]]; then
        if [[ ${selected[0]} -lt 1 ]]; then
          selected[0]="${LENGTHS[$page]}"; sudo sed -i "/JOY_POS_Y/ s/JOY_POS_Y[=].*$/JOY_POS_Y=${selected[0]}/" "$HOMEDIR/ADMIN/.sys/.states"
        elif [[ ${selected[0]} -gt ${LENGTHS[$page]} ]]; then
          selected[0]='1'; sudo sed -i "/JOY_POS_Y/ s/JOY_POS_Y[=].*$/JOY_POS_Y=${selected[0]}/" "$HOMEDIR/ADMIN/.sys/.states"
        fi
        INDEX[$page]="${selected[0]}"; selected[1]="${selected[0]}"
        echo -e "INDEX[$page] (${KEYS[$page]}) = ${INDEX[$page]}"
        startT=$(( $(date +%s%N) / 1000 )); printed=0
      else
        if [[ $printed -lt 1 ]]; then
          elapsed=$(( ( $(date +%s%N) / 1000 ) - startT ))
          if [[ $(( elapsed / 1000 )) -gt 2000 ]]; then
            file="$HOMEDIR/ADMIN/.sys/${KEYS[$page],,}.titles"
            title=$(awk -v ln="${selected[0]}" 'NR==ln' "$file")
            echo -e "VFD 1 $title" > /tmp/serial.fifo
            printed=1
          fi
        fi
      fi
    fi
    sleep 1
  }
fi

# ---------------------------------------------------------------------------------------------------------------

Main

exit


# ---------------------------------------------------------------------------------------------------------------

sleepBg() {
  local asleep=0
  local count=0
  local timeout=$(grep -w -m1 'timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)

  #while [[ $(pgrep -fc 'GAMES') -gt 0 ]]; do
  while true; do
    read -t 1 input
    if [[ $count -ge $timeout ]]; then
        [[ $(pgrep -c 'retroarch') -lt 1 ]] && \
        [[ $asleep -eq 0 ]] && { echo -e "ASLEEP 1" > /tmp/serial.fifo; }
        asleep=1; count=0
    elif [[ ${#input} -gt 0 ]]; then
      [[ $asleep -eq 1 ]] && { echo -e "ASLEEP 0" > /tmp/serial.fifo; }
      asleep=0; count=0;
    fi
    (( count++ ))
  done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#' |& awk -W interactive '{$1=$1;print $NF}' | grep --line-buffered -vw '/dev/input/event1')
}



sleepBg_old() {
  local menu_name='GAMES.sh'
  local timeout=$(grep -w -m1 'timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)
  local start=$(echo $(( 10#$(date +%s | tail -c 4) )))

  while :; do
    sudo timeout $timeout bash -c 'while read line; do break; done< <(thd --dump /dev/input/event*)'
    end=$(echo $(( 10#$(date +%s | tail -c 4) )))
    elapsed=$(echo $(( 10#$(( end - start )) )) )

    if [[ $elapsed -ge $timeout ]]; then
      if [[ $(pgrep -fc "$menu_name") -lt 1 ]] \
      && [[ $(pgrep -xc 'omxplayer|retroarch|vlc|ffplay') -lt 1 ]]; then
        echo -e "ASLEEP 1" > /tmp/serial.fifo
        while read line; do break; done< <(thd --dump /dev/input/event* | grep 'EV_KEY')
        echo -e "ASLEEP 0" > /tmp/serial.fifo
        start=$(echo $(( 10#$(date +%s | tail -c 4) )))
      fi
    fi
  done
}




    # --------------------------------------------------------------------------------------------------------------------

    #boot_modes=( 'none' 'term' 'es' 'menu' 'game' )

    #if [[ ${boot_modes[@]} =~ $boot_mode ]]; then
    #  [[ $boot_mode != es ]] && sleep 10
    #
    #  case $boot_mode in
    #    'term')
    #      sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
    #      sudo setterm --cursor on
    #      ;;
    #
    #    'menu'|'game')
    #      start_game=$(grep -w -m1 'game_on_boot' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
    #
    #      if [[ ${#start_game} -gt 0 ]]; then
    #        system="${start_game%%/*}"; game="${start_game##*/}"
    #        ext=$(grep -w -A3 "<name>${system}</name>" /home/pi/.emulationstation/es_systems.cfg | grep -w -m1 '<extension>' | cut -d. -f2)
    #        path="${roms_path}/${system}/${game}.${ext}"
    #
    #        sudo sed -i "s|ACTIVE_GAME[=].*$|ACTIVE_GAME=\x27${system}\/${game}\x27|g" "$HOMEDIR/CAFCA/data/.settings"
    #        sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode game; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    #        sudo -u pi bash -c "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} ${system} dummy"
    #        sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
    #      fi
    #
    #      # echo "$(id -u)"
    #      #sudo -u pi bash "$HOMEDIR/ADMIN/MENU/GAMES/GAMES.sh" BOOT
    #      #if [[ $boot_mode == menu ]]; then
    #      #  sudo bash "$HOMEDIR/ADMIN/CMD/PLAY/INTRO.sh" >/dev/null 2>&1 & sleep 2
    #      #  sudo bash "$HOMEDIR/ADMIN/MENU/GAMES/GAMES.sh" BOOT
    #      #  [ $? -eq 42 ] && sudo bash "$HOMEDIR/ADMIN/MENU/MAIN.sh"
    #      #fi
    #      ;;
    #    'es')
    #      while true; do dump_menu; done
    #      ;;
    #    *)
    #      ;;
    #  esac
    #fi

    #sleep 5
    #system_info

   #( sleepBg & )
