_#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

declare -a files=()

download_dir='/root/Downloads/MAME2003_Reference_Set_MAME0.78_ROMs_CHDs_Samples/roms'
torrent_file="$HOMEDIR/ADMIN/FILES/TORRENTS/mame078_romset.torrent"

# --------------------------------------------------------------------------------------

clear; echo "Starting transmission.."

transmission-daemon --logfile "$DIR/transmission.log"
trap 'sudo service transmission-daemon stop && sudo pkill -f "transmission-daemon"; ls -la $download_dir; exit' INT SIGINT EXIT

transmission-remote -a $torrent_file; sleep 1
transmission-remote -l; sleep 1

id=$(transmission-remote -l | grep 'MAME2003_Reference_Set*' | awk '{$1=$1; print $1}')

transmission-remote -t $id -Gall
transmission-remote -t $id -f | grep -we 'roms' | sed 's/:.*\/roms\// /' | sudo tee "$DIR/torrent.dump" &>/dev/null

sed 's/\([[:digit:]]\) \+\([[:alnum:]]\)/\1_\2/g' "$DIR/torrent.dump" | grep -v '^.*.chd\|^.*.png' | pr -10T -s' ' | column -t | sed 's/_/ /g'

sleep 1

echo -e "\nPress ENTER to add id(s); ESC TO EXIT. \n"

while true; do read -r -N 1 a; case $a in $'\n') echo "DOWNLOADING"; break ;; $'\E') echo "QUIT"; exit ;; *) read -r b; [[ $a$b =~ ^[0-9]+$ ]] && { files+=($((10#$a$b))); } ;; esac; done

file_list=$(IFS=,; echo "${files[*]}")


if [[ ${#files[@]} -gt 0 ]]; then
  transmission-remote -t $id -g$file_list
  transmission-remote -t $id --start

  downloading=1

  #while true; do
  #  transmission-remote -t $id -f | grep $(for file in ${files[@]}; do printf "^$file,"; done | sed 's/\(.\)$//' | sed 's/,/\\|/g')
  #  sleep 1
  #  #transmission-remote -t $id -f | grep -w 'Yes'; sleep 1
  #done

  while [[ $downloading -gt 0 ]]; do
    transmission-remote -t $id -f | grep -w 'Yes' | sudo tee "$DIR/status.log"
    #[[ $(grep -c '100% "$DIR/status.log") -ge ${#files[@]} ]] && downloading=0
    sleep 1; clear

    #downloading=$(grep "$(echo $file_list | sed 's/,/\\\|/g')" "$DIR/status.log" | awk '{gsub(/%/,"", $2);print $2}' | grep -c '[^100]')
    #read line < <(transmission-remote -t $id -f | grep -w 'Yes'); echo "$line"
    #progress=$(echo $line | awk '{gsub(/%/,"", $2);print $2}')
    ##finished=$(( progress / 100 ))

  done
fi






if [[ ${#files[@]} -gt 0 ]]; then
  transmission-remote -t $id -g$file_list
  transmission-remote -t $id --start

  downloading=1

  while [[ $downloading -gt 0 ]]; do
    read status < <(transmission-remote -t $id -f | grep "$(echo "${files[*]}" | sed 's/ /\\\|/g')");
    active=$(echo "$status" | awk '{gsub(/%/,"", $2);print $2}' | grep -c '[^100]')

    echo "STATUS: $status - active: $active"

    #downloading=$(echo "$status" | awk '{gsub(/%/,"", $2);print $2}' | grep -c '[^100]')

    #downloading=$(grep "$(echo "${ids[*]}" | sed 's/ /\\\|/g')" test.log | awk '{gsub(/%/,"", $2);print $2}' | grep -c '[^100]')

    #clear
    #while read line; do
    #  key=$(echo "$line" | grep -o '[^/]*$');
    #  echo "$line" | awk -v key="$key" '{print $1" "key" "$5" "$6" "$2}';
    #done< <(echo "$status" ) | column -t
    sleep 1

    #done< <(grep "$(echo "${ids[*]}" | sed 's/ /\\\|/g')" test.log ) | column -t
  done
  echo "DONE!"
  #while [[ $finished -eq 0 ]]; do
  #  read line < <(transmission-remote -t $id -f | grep -w 'Yes'); echo "$line"
  #  progress=$(echo $line | awk '{gsub(/%/,"", $2);print $2}')
  #  finished=$(( progress / 100 ))
  #  sleep 1
  #done
fi

exit









if [[ ${#files[@]} -gt 0 ]]; then
  transmission-remote -t $id -g$file_list
  transmission-remote -t $id --start

  downloading=1

  while [[ $downloading -gt 0 ]]; do
    status=$(transmission-remote -t $id -f | grep "$(echo "${files[*]}" | sed 's/ /\\\|/g')")
    downloading=1; echo "ACTIVE: $(echo "$status" | awk '{gsub(/%/,"", $2);print $2}' | grep -c '[^100]')"
    #downloading=$(echo "$status" | awk '{gsub(/%/,"", $2);print $2}' | grep -c '[^100]')

    #downloading=$(grep "$(echo "${ids[*]}" | sed 's/ /\\\|/g')" test.log | awk '{gsub(/%/,"", $2);print $2}' | grep -c '[^100]')

    clear
    while read line; do
      key=$(echo "$line" | grep -o '[^/]*$');
      echo "$line" | awk -v key="$key" '{print $1" "key" "$5" "$6" "$2}';
    done< <(echo "$status" ) | column -t
    sleep 1

    #done< <(grep "$(echo "${ids[*]}" | sed 's/ /\\\|/g')" test.log ) | column -t
  done
  echo "DONE!"
  #while [[ $finished -eq 0 ]]; do
  #  read line < <(transmission-remote -t $id -f | grep -w 'Yes'); echo "$line"
  #  progress=$(echo $line | awk '{gsub(/%/,"", $2);print $2}')
  #  finished=$(( progress / 100 ))
  #  sleep 1
  #done
fi

exit



while true; do read -r -N 1 a; case $a in $'\n') break ;; $'\E') exit ;; *) read -r b; [[ $a$b =~ ^[0-9]+$ ]] && { files+=($((10#$a$b))); } ;; esac; done
#while true; do read -N 1 a; case $a in $'\n') break ;; $'\E') exit ;; *) read b; [[ $a$b =~ ^[0-9]+$ ]] && { files+=("$a$b"); } ;; esac; done

file_list=$(IFS=,; echo "${files[*]}")

if [[ ${#files[@]} -gt 0 ]]; then
  transmission-remote -t $id -g$file_list
  #transmission-remote -t 1 $(for file in "${files[@]}"; do printf -- "-g$file "; done)
  #transmission-remote -t $id $(for file in ${files[@]}; do printf "-g$file "; done) #-g$input
  transmission-remote -t $id --start

  finished=0

  while true; do
    transmission-remote -t $id -f | grep $(for file in ${files[@]}; do printf "^$file,"; done | sed 's/\(.\)$//' | sed 's/,/\\|/g')
    sleep 1
    #transmission-remote -t $id -f | grep -w 'Yes'; sleep 1
  done

  #while [[ $finished -eq 0 ]]; do
  #  read line < <(transmission-remote -t $id -f | grep -w 'Yes'); echo "$line"
  #  progress=$(echo $line | awk '{gsub(/%/,"", $2);print $2}')
  #  finished=$(( progress / 100 ))
  #  sleep 1
  #done
fi

exit

echo -e "\ntype file id(s)\n - enter to download; escape to quit\n"
read input >/dev/null

if [[ $input =~ ^[0-9]+$ ]]; then
  transmission-remote -t $id -g$input
  sleep 1
  transmission-remote -t 1 --start

  finished=0

  while [[ $finished -eq 0 ]]; do
    read line < <(transmission-remote -t $id -f | grep -w 'Yes'); echo "$line"
    progress=$(echo $line | awk '{gsub(/%/,"", $2);print $2}')
    finished=$(( progress / 100 ))
    sleep 1
  done
  #tail -F /home/pi/transmission.log
fi
