#!/bin/bash

log_file='/home/pi/ADMIN/.log/serial.log'
fifo_file='/tmp/serial.fifo'
path='/dev/ttyACM'
req='/home/pi/ADMIN/.sys/.REQ'

[ ! -f "$log_file" ] && touch "$log_file"; sudo chmod 775 "$log_file";

printf '' > /home/pi/ADMIN/.log/teensy_cmd.log

echo -e "`date +%F`\n_______________________________________________________________\n" | sudo tee "$log_file" &>/dev/null

while IFS=$'\n' read line; do
  if [[ ${#line} -gt 1 ]]; then
    INBOX="$line"; nom='TEENSY'; dev=1; response=''

    if [[ ${INBOX:1:1} == ':' ]]; then
      [[ ${INBOX:0:1} =~ ^[0-9]+$ ]] && [[ ${INBOX:0:1} < 1 ]] && { nom='RPPICO'; dev=0; }
      INBOX="${INBOX:2}"
    fi

    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo  min 0 time 30 && printf "$INBOX;" > "$path$dev"
      [[ $nom == TEENSY ]] && response=$(head -n1 "$path$dev" | sed -z 's/\n//g' | col -b) || response=''
      [[ "$INBOX" =~ 'REQ'.* ]] && echo "${INBOX//REQ /} : $response" > $req

      entry="[ `date +%T` ] RPI > $nom: '$INBOX'\n             RPI < $nom: '$response'\n             --------------------------------------------------"
      offset=$(grep -n -m1 '^_.*' $log_file)
      sudo sed -n -i "p;$(( ${offset%%:*} + 1 ))a ${entry}" "$log_file"

      #echo -e "[ `date +%T` ] RPI > $nom: '$INBOX'\n             RPI < $nom: '$response'\n             --------------------------------------------------" | sudo tee -a "$log_file" &> /dev/null; sleep 0.5
    fi
  elif [[ ${#line} -lt 1 ]]; then
    cmd=$(cat /dev/ttyACM1 | head -n 1); [[ ${#cmd} -gt 0 ]] && echo "$input" >> /home/pi/ADMIN/.log/teensy_cmd.log
  fi
done< <( cat <>"$fifo_file" )


