#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

Password() {
  rc=$(pass 3>&1 &>/dev/null); echo "$rc"
}

pass() {
  #exec 2>/dev/null
  #exec 3>&1 &>/dev/null

  #cat /home/pi            # suppress stderr
  #echo "VOID"             # suppress stdout

  #echo "MSG!" >/dev/tty1  # show on console
  #echo "OUTPUT" >&3       # output to stdout

  #local pass=''
  #local key=$(grep -w -m1 'admin_menu_pass' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)

  clear; echo -ne "PASS: " >"$(tty)" #>/dev/tty1

  while [[ ${#pass} -lt ${#key} ]]; do
    input=$(readIn)
    if [[ ${#input} -gt 0 ]]; then
      case "${input^^}" in
        'U'|'D'|'L'|'R'|'A'|'B') echo -ne "*" >"$(tty)"; pass+="${input^^}" ;;
        'S'|'ESC') break ;;
      esac
    fi
  done
  echo "" >"$(tty)"

  [[ "${pass}" == "$key" ]] && echo "1" >&3 || echo "0" >&3

  #echo -e "\nENTERED: ${pass}"
  #[[ "${pass}" == "$key" ]] && echo -e "\nVALID!" >/dev/tty1 || echo -e "\nINVALID PASS.." >/dev/tty1
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

readIn() {
    Event=''
    read -rs -N 1 -t 0.1 Event1 >/dev/null
    [[ $? -gt 127 ]] && return

    case "$Event1" in
      $'\163')          Event="S"   ;;
      $'\n')            Event="A"   ;;
      ' ')              Event="B"   ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="U"   ;;
          "[B")         Event="D"   ;;
          "[D")         Event="L"   ;;
          "[C")         Event="R"   ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

key=$(grep -w -m1 'admin_menu_pass' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
pass=''


if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
  #Password; exit
  rc=$(Password 3>&1 &>/dev/null); echo "$rc"
  #Password 3>&1 &>/dev/null
  #[[ "${pass}" == "$key" ]] && echo "1" >&3 || echo "0" >&3
  exit
#else
#  rc=$(Password 3>&1 &>/dev/null); echo "$rc"
#  Password 3>&1 &>/dev/null
#  #[[ "${pass}" == "$key" ]] && echo "1" >&3 || echo "0" >&3
fi

