#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

roms_dir="$HOMEDIR/RetroPie/roms/mame-libretro"
torrent_dir="$HOMEDIR/downloads/MAME2003_Reference_Set_MAME0.78_ROMs_CHDs_Samples/roms"
output_dir="$DIR/roms"
assets_path="$HOMEDIR/ADMIN/MENU/.assets"

export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"

# ______________________________________________________________________________________

game=
action=

# --------------------------------------------------------------------------------------

Main() {
  entries=($(awk -F'\x27' '{ print $2; }' "$assets_path/GAMES/.list")); items=()
  for (( i=0; i<${#entries[@]}; i++ )); do [[ $i -eq 0 ]] && items+=("${entries[$i]}" "" ON) || items+=("${entries[$i]}" "" OFF); done

  game=$(whiptail --radiolist "SELECT GAME" 0 0 0 "${items[@]}" 2>&1 1>$(tty))
  action=$(whiptail --radiolist "ACTION" 0 0 0 "UPDATE" "" ON "REMOVE" "" OFF 2>&1 1>$(tty))

  if [[ ${#game} -gt 0 && ${#action} -gt 0 ]]; then
    [[ ${action,,} == remove ]] && remover "$game" || { [[ ${action,,} == update ]] && updater "$game"; }
  fi
}

# --------------------------------------------------------------------------------------

updater() {
  local name="${1}"
  declare -a pages=($(sed -n '/\[ \([^]]*\) \]/ { s/.*\[ \([^]]*\) \].*/\1/; s/ /\n/g;/^$/d; p }' "$assets_path/GAMES/.list" | sort -u))
  declare -a game_pages=($(grep -w -m1 "$name" "$assets_path/GAMES/.list" | awk -F'\x27' '{print $(NF-1)}' | sed 's/[][]//g;s/ //'))

  action=$(whiptail --radiolist "ACTION" 0 0 0 "PAGES" "" ON "INPUT" "" OFF 2>&1 1>$(tty))

  if [[ $? -eq 0 && ${#action} -gt 0 ]]; then
    if [[ $action == PAGES ]]; then items=();
      for p in ${pages[@]}; do [[ "${game_pages[@]}" =~ "$p" ]] && items+=("$p" "" ON) || items+=("$p" "" OFF); done
        filter=$(whiptail --checklist "TOGGLE PAGES" 0 0 0 "${items[@]}" 2>&1 1>$(tty))
        if [ $? -eq 0 ] && [[ ${#filter} -gt 0 ]]; then
          filter=$(echo "$filter" | sed 's/\x22//g')
          #sudo cp "$assets_path/GAMES/.list" "$assets_path/GAMES/.list.bak$(date +%y%m%d%H%M%S)"
          sed -i "/outrun/ s/\[[^]]*\]/[ ${filter} ]/" "$assets_path/GAMES/.list"

          declare -a game_pages=($(grep -w -m1 "$name" "$assets_path/GAMES/.list" | awk -F'\x27' '{print $(NF-1)}' | sed 's/[][]//g;s/ //'))

          local inputType=$(grep "$name" "$assets_path/GAMES/.list" | awk -F'\x27' '{print $10}')
          local inShooters=$(grep -c "^$name" "$assets_path/GAMES/.shooters")
          local inSpinners=$(grep -c "^$name" "$assets_path/GAMES/.spinners")

          if [[ "${game_pages[@]}" =~ GUN ]] || [[ $inputType == GUN ]]; then
            [[ $inShooters -lt 1 ]] && { printf '%-8s\t1\n' "$name"; sort -k1,1 "$assets_path/GAMES/.shooters" --output="$assets_path/GAMES/.shooters"; }
          else
            [[ $inShooters -gt 0 ]] && { sudo sed -i "/^${name}/d" "$assets_path/GAMES/.shooters"; }
          fi

          if [[ "${game_pages[@]}" =~ SPIN ]] || [[ $inputType == SPIN ]]; then
            [[ $inSpinners -lt 1 ]] && { printf '%-8s\t72\t\t1\t\t255\t\t255\n' "$name"; sort -k1,1 "$assets_path/GAMES/.spinners" --output="$assets_path/GAMES/.spinners"; }
          else
            [[ $inSpinners -gt 0 ]] && { sudo sed -i "/^${name}/d" "$assets_path/GAMES/.spinners"; }
          fi
        fi
    fi
  fi
}

# --------------------------------------------------------------------------------------

remover() {
  local name="${1}"
  whiptail --title "WARNING" --yesno "$( echo -e "\nREMOVE '${name}' from list?\n\n")" 10 32 0 2>&1 1>$(tty)

  if [ $? -eq 0 ]; then
    sudo sed -i "/${name}/d" "$assets_path/GAMES/.list"
    awk '{$1="";print}' "$assets_path/GAMES/.list" | sed 's/ //' | grep -n '' | sed 's/:/ /' | sudo tee "$assets_path/GAMES/.list"
    for f in .shooters .spinners; do sudo sed -i "/^${name}/d" "$assets_path/GAMES/$f"; done
    for f in table timers clearram; do sudo sed -i "/^${name}/d" "$HOMEDIR/CAFCA/data/mame-libretro/$f"; done

    if [ -f "$roms_dir/$name.zip" ]; then
      whiptail --title "WARNING" --yesno "$( echo -e "\nRemove '$roms_dir/$name.zip' from roms?\n\n")" 10 80 0 2>&1 1>$(tty)
      [ $? -eq 0 ] && sudo rm -v "$roms_dir/$name.zip"
    fi
  fi
}

# --------------------------------------------------------------------------------------

Main
exit










# ______________________________________________________________________________________

# OLD

[ $# -lt 1 ] && read -p "Please type rom name: " name || name="${1}"

echo "rom name: $name"

if [[ $(read -n1 -p "$(echo -e '\nREMOVE DATA?') " a</dev/stdin; echo $a) == [yY] ]]; then echo "";
  #sudo find $roms_dir -type f -iname "$name.zip" -exec false {} +

  #if [ $? -gt 0 ]; then
    sudo rm -v "$roms_dir/$name.zip"
    sudo sed -i "/${name}/d" "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.list"
    awk '{$1="";print}' "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.list" | sed 's/ //' | grep -n '' | sed 's/:/ /' | sudo tee "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.list"
    for f in .shooters .spinners; do sudo sed -i "/^${name}/d" "$HOMEDIR/ADMIN/MENU/.assets/GAMES/$f"; done
    for f in table timers clearram; do sudo sed -i "/^${name}/d" "$HOMEDIR/CAFCA/data/mame-libretro/$f"; done
  #fi
fi

