#!/bin/bash

printf 'clear\r' > /tmp/vkbdd.fifo

# Set framebuffer dimensions, iterations, and precision
WIDTH=$(cat /sys/class/graphics/fb0/stride)
HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
MAX_ITER=100      # Max iterations for Mandelbrot calculation
BLOCK_SIZE=4      # Block size factor to lower resolution and increase speed


# Function to map a coordinate to a point in the Mandelbrot set
mandelbrot() {
  local real=$1
  local imag=$2
  local zr=0.0
  local zi=0.0
  local zr2=0.0
  local zi2=0.0

  for ((i=0; i<MAX_ITER; i++)); do
    zi=$(echo "$zr * $zi * 2 + $imag" | bc -l)
    zr=$(echo "$zr2 - $zi2 + $real" | bc -l)
    zr2=$(echo "$zr * $zr" | bc -l)
    zi2=$(echo "$zi * $zi" | bc -l)

    # Break out if the point has escaped
    [[ $(echo "$zr2 + $zi2 > 4" | bc -l) ]] && break
  done

  echo $i
}

# Calculate each block and write to framebuffer
for ((y = 0; y < HEIGHT; y += BLOCK_SIZE)); do
  for ((x = 0; x < WIDTH; x += BLOCK_SIZE)); do
    # Map block top-left pixel (x, y) to complex plane (real, imag)
    real=$(echo "scale=5; ($x - $WIDTH / 2) * 3.5 / $WIDTH - 0.7" | bc -l)
    imag=$(echo "scale=5; ($y - $HEIGHT / 2) * 2.0 / $HEIGHT" | bc -l)

    # Determine escape count (iteration) for Mandelbrot set
    iter=$(mandelbrot $real $imag)
    COLOR=`printf "\\\\x$(printf %02x $(( (iter * 9) % 255 )))\\\\x$(printf %02x $(( (iter * 7) % 255 )))\\\\x$(printf %02x $(( (iter * 5) % 255 )))\\\\\\\\x00%0.s" $(seq 1 $BLOCK_SIZE)`
    #COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $BLOCK_SIZE)`
    printf $COLOR | dd bs=$BLOCK_SIZE count=$BLOCK_SIZE seek=$((y * ( WIDTH / 4 ) + x)) of=/dev/fb0

    # Set color based on iteration count
    #COLOR=`printf "\\\\x$(printf %02x $(( (iter * 9) % 255 )))\\\\x$(printf %02x $(( (iter * 7) % 255 )))\\\\x$(printf %02x $(( (iter * 5) % 255 )))\\\\\\\\x00%0.s" $(seq 1 $BLOCK_SIZE)`
    #printf $COLOR | dd bs=$((4 * BLOCK_SIZE)) count=1 seek=$((y * WIDTH + x)) of=/dev/fb0 #&>/dev/null

    # Build COLOR_BLOCK by repeating the color for the block width
    #COLOR_BLOCK=""
    #for ((i = 0; i < BLOCK_SIZE; i++)); do
    #  COLOR_BLOCK+="${COLOR}"
    #done

    # Write the color block to framebuffer
    #printf "${COLOR_BLOCK}" | dd bs=$((4 * BLOCK_SIZE)) count=1 seek=$((y * WIDTH + x)) of=/dev/fb0 2>/dev/null
  done
done

echo "Low-resolution Mandelbrot fractal drawn to framebuffer /dev/fb0!"

