#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

roms_dir="$HOMEDIR/RetroPie/roms/mame-libretro"
torrent_dir="$HOMEDIR/downloads/MAME2003_Reference_Set_MAME0.78_ROMs_CHDs_Samples/roms"
output_dir="$DIR/roms"
assets_path="$DIR/assets"

# -----------------------------------------------------------------------------------------------------------------------------------

ignore_existing=1
force=1

# ___________________________________________________________________________________________________________________________________


Main() {

  # DOWNLOADER
  if [[ $(ls -1 $output_dir | wc -l) -lt 1 ]]; then #|| [[ $ignore_existing -eq 1 ]]; then
    #[[ $(read -rp "$(echo -e '\nRUN TRANSMISSION?') " a</dev/stdin; echo $a) == [yY] ]] && bash "$DIR/SCRIPTS/DOWNLOADER.sh"
    bash "$DIR/SCRIPTS/DOWNLOADER.sh"
    [ $? -gt 0 ] && exit 1
    sudo find $torrent_dir -maxdepth 1 -type f -iname '*.zip' -exec cp -vf {} $output_dir \;
  fi

  if [[ $(ls -1 $output_dir | wc -l) -gt 0 ]]; then
    echo "FOUND $(ls -1 $output_dir | wc -l) files in roms dir"

   [ ! -d "$DIR/assets/scraper" ] && sudo mkdir "$DIR/assets/scraper"
   printf '' | sudo tee "$DIR/assets/scraper/downloads.txt" &>/dev/null

    sudo chmod -R 775 $output_dir

    for rom in $(ls -1 $output_dir); do
      sudo cp -n "$output_dir/$rom" "$roms_dir"
      sudo chown pi:pi $roms_dir/$rom; sudo chmod 775 $roms_dir/$rom
      echo "$roms_dir/$rom" | sudo tee -a "$DIR/assets/scraper/downloads.txt"
    done
  fi

  # ---------------------------------------------------

  # UPDATER
  whiptail --yesno "UPDATE?" 0 0 2>&1 1>$(tty)
  if [ $? -eq 0 ]; then
  #if [[ $(read -rp "$(echo -e '\nUPDATE?') " a</dev/stdin; echo $a) == [yY] ]]; then echo "";
    Scraper
    #EditLists
    listUpdate
    #CafcaUpdate
    ApplyChanges
  fi
}

# -----------------------------------------------------------------------------------------------------------------------------------

Scraper() {
  if [[ $(cat "$DIR/assets/scraper/downloads.txt" | wc -l) -gt 0 ]]; then
    bash "$DIR/SCRIPTS/SCRAPER.sh"
  fi
}

# -----------------------------------------------------------------------------------------------------------------------------------

EditLists() {
  local game_list="$assets_path/.list"


  #if [[ $(read -p "$(echo -e '\nEDIT DATA?') " a</dev/stdin; echo $a) == [yY] ]]; then echo "";
  whiptail --yesno "EDIT DATA?" 0 0 2>&1 1>$(tty)
  if [ $? -eq 0 ]; then
    for name in $(cat "$assets_path/scraper/downloads.txt" | grep -o '[^/]*$' | sed 's/[.].*$//'); do
      if grep "$name" "$game_list"; then echo "EDIT DATA for '$name'? (Y/n)";
        if [[ $(read -r a</dev/stdin; echo $a) == [yY] ]]; then echo "";
          echo "- type 'input type' and 'lists' (comma-separated)"
          read type list; echo "type: '${type^^}', list: '${list^^}'"
          [[ ${type^^} == @(JOY|GUN|SPIN) ]] && sed -i "/${name}/ s/JOY/${type^^}/" "$game_list"
          [[ ${#list} -gt 0 ]] && { list="${list//,/ }"; sed -i "/${name}/ s/\[\(.*\)\]/[ ${list^^} ]/" "$game_list"; }
        fi
      fi
    done
    cat "$game_list"
  fi
}

# -----------------------------------------------------------------------------------------------------------------------------------

listUpdate() {
  sudo cp "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.shooters" "$assets_path/.shooters"
  for game in $(cat "$assets_path/.list" | grep '\[*GUN*' | awk -F'\x27' '{print $2}'); do
    [[ $(grep -c "^$game" "$assets_path/.shooters") -lt 1 ]] && printf '%-8s\t1\n' "$game"
  done >> "$assets_path/.shooters"
  sort -k1,1 "$assets_path/.shooters" --output="$assets_path/.shooters"

  sudo cp "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.spinners" "$assets_path/.spinners"
  for game in $(awk -F'\x27' '{if ($10 ~ "SPIN") print $2;}' "$assets_path/.list"); do
    [[ $(grep -c "^$game" "$assets_path/.spinners") -lt 1 ]] && printf '%-8s\t72\t\t1\t\t255\t\t255\n' "$game"
  done >> "$assets_path/.spinners"
  sort -k1,1 "$assets_path/.spinners" --output="$assets_path/.spinners"

  bash "$DIR/SCRIPTS/CAFCA_UPDATE.sh"
}

# -----------------------------------------------------------------------------------------------------------------------------------

#CafcaUpdate() {
#  if [[ $(read -rp "$(echo -e '\nUPDATE CAFCA LISTS?') " a</dev/stdin; echo $a) == [yY] ]] || [[ $force -eq 1 ]]; then echo "";
#    bash "$DIR/SCRIPTS/CAFCA_UPDATE.sh"
#  fi
#}

# -----------------------------------------------------------------------------------------------------------------------------------

ApplyChanges() {
  #if [[ $(read -n1 -p "$(echo -e '\nAPPLY CHANGES?') " a</dev/stdin; echo $a) == [yY] ]]; then echo "";
  whiptail --yesno "APPLY CHANGES?" 0 0 2>&1 1>$(tty)
  if [ $? -eq 0 ]; then
    for f in .list .shooters .spinners; do sudo cp -vf "$assets_path/$f" "$HOMEDIR/ADMIN/MENU/.assets/GAMES/$f"; done
    for f in table timers clearram; do sudo cp -vf "$assets_path/cafca/$f" "$HOMEDIR/CAFCA/data/mame-libretro/$f"; done
  else
    for rom in $(ls -1 $output_dir); do sudo rm -vf "$roms_dir/$rom"; done
  fi
  for rom in $(ls -1 $output_dir); do sudo rm -vf "$output_dir/$rom"; done
}

# -----------------------------------------------------------------------------------------------------------------------------------

cleanup() {
  sudo /etc/init.d/transmission-daemon stop
  sudo pkill -f "transmission-daemon"
  #sudo rm "$DIR/torrent.dump"
  sudo rm -r "$DIR/assets/scraper/*"
  #sudo find "$DIR/assets/scraper" -type f -name '*.*' -exec rm -rf -- {} +
  exit 0
}

# ___________________________________________________________________________________________________________________________________

trap 'cleanup &>/dev/null' EXIT INT HUP SIGINT SIGHUP TERM EXIT

Main
exit 1
