#!/bin/bash

WIDTH=$(cat /sys/class/graphics/fb0/stride)
HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)

i=0

printf 'clear\r' > /tmp/vkbdd.fifo

tiles_rand() {
  while true; do
    LINE=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $(( ( RANDOM % ( WIDTH / 4 ) ) % WIDTH )) )`
    printf $LINE | dd bs=1 count=$(( RANDOM % WIDTH )) seek=$(( (WIDTH / (( RANDOM % 8 )+1)) * (( RANDOM % HEIGHT )+1) )) of=/dev/fb0 >/dev/null 2>&1
  done
}

tiles_rand &>/dev/null

tiles() {
  local COUNT_H=1
  local COUNT_W=0
  local LINE='';

  local ADD_W=${1:-20}
  local ADD_H=${2:-8}

  local DIV_W=0
  local DIV_H=$(( ( RANDOM % ADD_H ) + 2 ))

  #while [[ $COUNT_H -lt $HEIGHT ]]; do
  for COUNT_H in $(seq 1 $HEIGHT | shuf); do
    COUNT_W=0; LINE=''

    while [[ $COUNT_W -lt $WIDTH ]]; do
      #DIV_W=$(( (RANDOM % ADD_W) + 1 ))
      #DIV_W=$(( (RANDOM % ( ADD_W * (( RANDOM % 8 )+1) ) ) + (( RANDOM % 8 )+1) ))
      DIV_W=$(( ((RANDOM % ADD_W)+1) * ( (( RANDOM % 8 )*4) * (( RANDOM % 8 )*4) ) ))
      COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $(( WIDTH / DIV_W )) )`
      LINE=${LINE}${COLOR}
      COUNT_W=$(( COUNT_W + ( WIDTH / DIV_W ) ))
    done
    ADD_H=$(( (( RANDOM % 3 )+1) * ((RANDOM % 3 )+1) ))
    for c in $(seq 1 $ADD_H); do
      printf $LINE | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT_H )) of=/dev/fb0 >/dev/null 2>&1
      (( COUNT_H++ ))
    done
  done
}

tiles &>/dev/null
exit


drawcols() {
  local COL_W=${1:-10};
  local COL_H=${2:-8}
  local W=$(( WIDTH / COL_W ))
  local R=$(( RANDOM % 255 )); local G=$(( RANDOM % 255 )); local B=$(( RANDOM % 255 ));

  for (( i=1; i<HEIGHT; i++ )); do
    COL_W=$(( ( RANDOM % 10 ) * (( RANDOM % 3 )+1) ))
    for (( n=0; n<COL_W; n++ )); do
      printf "\x$(printf %02x $R)\x$(printf %02x $G)\x$(printf %02x $B)\x00%0.s" $(seq 1 $W) | dd bs=1 seek=$(( ( i * WIDTH ) + ( n * W ) )) of=/dev/fb0 &>/dev/null
    done
    [[ $(( i % (( RANDOM % COL_H ) * 10 ) )) -eq 0 ]] && { R=$(( RANDOM % 255 )); G=$(( RANDOM % 255 )); B=$(( RANDOM % 255 )); }
  done
}


drawcols
exit


while [[ $i -lt $(( $WIDTH * $HEIGHT )) ]]; do
  R=$(( RANDOM % 255 )); G=$(( RANDOM % 255 )); B=$(( RANDOM % 255 ));
  X=$(( RANDOM % 100 )); Y=$(( RANDOM % 10 ))

  for (( a=0; a<Y; a++ )); do
    for (( n=0; n<X; n++ )); do
      printf "\x$(printf %02x $R)\x$(printf %02x $G)\x$(printf %02x $B)\x00%0.s" $(seq 1 $X) | dd bs=$(( Y * ( RANDOM % 10 ) )) seek=$(( ( RANDOM % i) * (n % HEIGHT) )) of=/dev/fb0 &>/dev/null
    done
    i=$(( i + n ))
  done
done


fbdrawcols() {
  local COL_W=${1:-10};
  local COL_H=${2:-8}
  local W=$(( WIDTH / COL_W ))
  local R=$(( RANDOM % 255 )); local G=$(( RANDOM % 255 )); local B=$(( RANDOM % 255 ));

  for (( i=1; i<HEIGHT; i++ )); do
    for (( n=0; n<COL_W; n++ )); do
      printf "\x$(printf %02x $R)\x$(printf %02x $G)\x$(printf %02x $B)\x00%0.s" $(seq 1 $W) | dd bs=1 seek=$(( ( i * WIDTH ) + ( n * W ) )) of=/dev/fb0 &>/dev/null
    done
    [[ $(( i % COL_H )) -eq 0 ]] && { R=$(( RANDOM % 255 )); G=$(( RANDOM % 255 )); B=$(( RANDOM % 255 )); }
  done
}


fbdrawcols


tiles() {
  local COUNT_H=1
  local COUNT_W=0
  local LINE='';

  local ADD_W=${1:-20}
  local ADD_H=${2:-8}

  local DIV_W=0
  local DIV_H=$(( ( RANDOM % ADD_H ) + 2 ))

  while [[ $COUNT_H -lt $HEIGHT ]]; do
    COUNT_W=0; LINE=''

    while [[ $COUNT_W -lt $WIDTH ]]; do
      DIV_W=$(( (RANDOM % ADD_W) + 1 ))
      COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $(( WIDTH / DIV_W )) )`
      LINE=${LINE}${COLOR}
      COUNT_W=$(( COUNT_W + ( WIDTH / DIV_W ) ))
    done
    for c in $(seq 1 $ADD_H); do
      printf $LINE | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT_H )) of=/dev/fb0 >/dev/null 2>&1
      (( COUNT_H++ ))
    done
  done
}
