#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$HOMEDIR/ADMIN/MENU/.assets"
list_path="$assets_path/GAMES/.list"
font="$assets_path/fonts/Calvin_S.flf"

#________________________________________________________________________________

# REM

width=$(echo "$(tput cols)")
start_page='FAV'
pageIndex=0
header_height=0

declare -A pageTitles=()
declare -a pages=()
declare -a headers=()



# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

clear; sleep 1


sortPages() { pages=();
  echo "sortPages()"
  for i in $(seq 1 $#); do [[ "${!i}" == $start_page ]] && { shift $((i-1)); break; } || pages+=("${!i}"); done; pages=( "${@}" "ALL" "${pages[@]}" )
  for p in $(seq 0 $(( ${#pages[@]}-1))); do echo "  ${pages[$p]}"; [[ "${pages[$p]}" == "${start_page}" ]] && { pageIndex=$p; page="${pages[$pageIndex]}"; }; done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

createPages() {
  local key=; local str=; local text=;
  local w=$(( width - 2 ))

  echo "createPages()"
  while read line; do key="${line%%=*}"; str="${line##*=}"; pageTitles["${key}"]="${str//\"/}"; echo "  ${key}: '${str//\"/}'"; done< <(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^page_titles/ { s/^[^=]*=//; s/\x27//g; s/\s*$//; p; q } }' "$assets_path/.settings" | sed 's/[,]/\n/g' | awk '{$1=$1;print}')
  declare -ag pages=($(sed -n '/\[ \([^]]*\) \]/ { s/.*\[ \([^]]*\) \].*/\1/; s/ /\n/g;/^$/d; p }' $list_path | sort -u));
  for key in 70s 80s 90s; do pageTitles["${key^^}"]="19${key}"; pages+=("${key^^}"); echo "  ${key^^}: '19${key}'"; done; echo ""

  sortPages "${pages[@]}"; echo ""

  for p in $(seq 0 $(( ${#pages[@]}-1))); do
    #str=$(printf "${pageTitles[${pages[$p]}]}" | sed 's/8/B/g; s/0/O/g');
    str=$(printf "${pageTitles[${pages[$p]}]}");
    text=$(printf "$(figlet -w $w -c ${str,,} -f $font)");
    headers+=("$(printf "${text}")");
    [ $header_height -eq 0 ] && { header_height="$( echo "${headers[-1]}" | wc -l)"; maxPage=$(( maxPage - ( $header_height + 2 ) )); }
    echo "str: $str, text: $text"
  done
}


createPages


exit




#################################################################################





whiptail --yesno "CONTINUE?" 0 0 0 2>&1 1>$(tty); [ $? -gt 0 ] && { cat "$DIR/.list2"; exit; }

grep '&apos;' "$DIR/.list2"

#________________________________________________________________________________


# RE-FORMAT HTML CHARACHTERS
sed -i 's/&apos;//' "$DIR/.list2"
edited=0
for line in "$(grep '&.*;' $DIR/.list2)"; do
  line_num=$(echo "$line" | awk '{print $1}')
  line_fmt=$(echo "$line" | perl -MHTML::Entities -pe 'decode_entities($_);')
  sed -i "/${line_num}/d" "$DIR/.list2"; echo "$line_fmt" | sudo tee -a "$DIR/.list2" &>/dev/null; edited=1
done
[[ $edited -gt 0 ]] && tac "$DIR/.list2" | sort -k4,4 -t \' --output "$DIR/.list2"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

for i in $(seq 1 $(cat "$DIR/.list2" | wc -l)); do
  name=$(sed -n "${i}p" "$DIR/.list2" | cut -d\' -f2)
  find "$assets_path/media/marquees" -type f -iname "$name*.ppm" -exec false {} +; found=$?; sed -i "${i}{s/'[^']*'/'${found}'/7}" "$DIR/.list2"
done

exit

#for line in "$(cat ./GAMES/.list2)"; do echo "$line" | sed "s/'[^']*'/'0'/7"; done

for i in $(seq 1 $(cat "$DIR/.list2" | wc -l)); do
  name=$(sed -n "${i}p" "$DIR/.list2" | cut -d\' -f2)
  age=$(sed -n "${i}p" "$DIR/.list2" | cut -d\' -f6);
  pages=$(sed -n "${i}{ s/^.*\[\(.*\)\].*$/\1/;p;q}" "$DIR/.list2"); pages=$(echo "$pages" | awk '{$1=$1;print}')

  find "$assets_path/media/marquees" -type f -iname "$name*.ppm" -exec false {} +; found=$?; sed -i "${i}{s/'[^']*'/'${found}'/7}" "$DIR/.list2"

  if [[ "$age" == 19* ]] && [[ "${age:2:1}" == @(7|8|9) ]]; then page="${age:2:1}0S";
    if [[ ! "$pages" =~ "$page" ]]; then
      [[ ${#pages} -gt 0 ]] && pages="$pages $page" || pages="$page"
      sed -i "${i} s/\[\(.*\)\]/[ $pages ]/" "$DIR/.list2"
    fi
  fi

  #page=
  #[[ "$age" == 19* ]] && [[ "${age:2:1}" == @(7|8|9) ]] && page="${age:2:1}0S"
  #[ ! -z "$page" ] && [[ ! "$pages" =~ "$page" ]] && echo "page: $page" || echo "page:"; done

  #dec=${age:2:1}; [[ "$age" == 19* ]] && [[ "$dec" == @(7|8|9) ]] && { group=$([[ $dec -eq 7 ]] && echo 70S || { [[ $dec -eq 8 ]] && echo 80S || { [[ $dec -eq 9 ]] && echo 90S; } ; }); }


done

exit


#________________________________________________________________________________

