#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$HOMEDIR/ADMIN/MENU/.assets"

#________________________________________________________________________________

# REM
cp .list32 .list2

clear; sleep 1

whiptail --yesno "CONTINUE?" 0 0 0 2>&1 1>$(tty); [ $? -gt 0 ] && { cat "$DIR/.list2"; exit; }

grep '&apos;' "$DIR/.list2"

#________________________________________________________________________________


# RE-FORMAT HTML CHARACHTERS
sed -i 's/&apos;//' "$DIR/.list2"
edited=0
for line in "$(grep '&.*;' $DIR/.list2)"; do
  line_num=$(echo "$line" | awk '{print $1}')
  line_fmt=$(echo "$line" | perl -MHTML::Entities -pe 'decode_entities($_);')
  sed -i "/${line_num}/d" "$DIR/.list2"; echo "$line_fmt" | sudo tee -a "$DIR/.list2" &>/dev/null; edited=1
done
[[ $edited -gt 0 ]] && tac "$DIR/.list2" | sort -k4,4 -t \' --output "$DIR/.list2"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

for i in $(seq 1 $(cat "$DIR/.list2" | wc -l)); do
  name=$(sed -n "${i}p" "$DIR/.list2" | cut -d\' -f2)
  find "$assets_path/media/marquees" -type f -iname "$name*.ppm" -exec false {} +; found=$?; sed -i "${i}{s/'[^']*'/'${found}'/7}" "$DIR/.list2"
done

exit

#for line in "$(cat ./GAMES/.list2)"; do echo "$line" | sed "s/'[^']*'/'0'/7"; done

for i in $(seq 1 $(cat "$DIR/.list2" | wc -l)); do
  name=$(sed -n "${i}p" "$DIR/.list2" | cut -d\' -f2)
  age=$(sed -n "${i}p" "$DIR/.list2" | cut -d\' -f6);
  pages=$(sed -n "${i}{ s/^.*\[\(.*\)\].*$/\1/;p;q}" "$DIR/.list2"); pages=$(echo "$pages" | awk '{$1=$1;print}')

  find "$assets_path/media/marquees" -type f -iname "$name*.ppm" -exec false {} +; found=$?; sed -i "${i}{s/'[^']*'/'${found}'/7}" "$DIR/.list2"

  if [[ "$age" == 19* ]] && [[ "${age:2:1}" == @(7|8|9) ]]; then page="${age:2:1}0S";
    if [[ ! "$pages" =~ "$page" ]]; then
      [[ ${#pages} -gt 0 ]] && pages="$pages $page" || pages="$page"
      sed -i "${i} s/\[\(.*\)\]/[ $pages ]/" "$DIR/.list2"
    fi
  fi

  #page=
  #[[ "$age" == 19* ]] && [[ "${age:2:1}" == @(7|8|9) ]] && page="${age:2:1}0S"
  #[ ! -z "$page" ] && [[ ! "$pages" =~ "$page" ]] && echo "page: $page" || echo "page:"; done

  #dec=${age:2:1}; [[ "$age" == 19* ]] && [[ "$dec" == @(7|8|9) ]] && { group=$([[ $dec -eq 7 ]] && echo 70S || { [[ $dec -eq 8 ]] && echo 80S || { [[ $dec -eq 9 ]] && echo 90S; } ; }); }


done

exit


#________________________________________________________________________________

