#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$HOMEDIR/ADMIN/MENU/.assets"
sys_states="$HOMEDIR/ADMIN/.sys/.states"
index="$assets_path/index"
req="$HOMEDIR/ADMIN/.sys/.REQ"

declare -a entries=()
declare -a last_items=()

level=0; offset=1; start=0
choice='0: '; level_index=''; nav_string=''

source "$assets_path/helpers/commands.sh"; commands_set_globals

# ------------------------------------------------------------------------------------------------------------

Init() {
  declare -g blanktime=$(cat /sys/module/kernel/parameters/consoleblank)
  declare -g console=$(sed -n '/console=/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")
  declare -g prev_state=$(sed -n '/UI=/ { s/\(.*\)=//g; s/\x27//g; p }' "$sys_states")
  local boot_games_menu=$(sed -n '/boot_games_menu/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")

  loadSettings

  sudo -E -u pi bash -c "dialog --create-rc /home/pi/.dialogrc; cp -f /home/pi/ADMIN/MENU/.assets/config/.dialogrc /home/pi/.dialogrc"

  sed -i "/UI=/ s/[=].*$/=\x27MENU\x27/" "$sys_states"

  menuSaver ${t_saver:-120} &

  if [[ "${ARG^^}" == BOOT ]]; then
    [[ $play_intro -eq 1 ]] && startupSound &
    [[ $show_splash -eq 1 ]] && { clear; showSplash >/dev/null 2>&1; }
    [[ $boot_games_menu -eq 1 ]] && [[ "${commands[@]}" =~ run_games_menu ]] && run_games_menu BOOT
  fi

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode admin
  sudo setterm --cursor off

  setBlankTime 0

  [[ $mono_colors -eq 1 ]] && export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
  [[ $TERM == linux ]] && echo -en "\e]P7C0C0C0"

  printf '' > "$DIR/.log/errors.log"
  trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

  clear
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Menu() {
  level_index=$(grep -v '^$\|^\s*#' $index | grep -Pn "^(\t){$level}[[:graph:]].*$")
  items=$(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}')
  entries=()

  for n in $(seq 1 $(echo "$items" | wc -l)); do item=$(echo "$items" | awk -v n="$n" 'NR==n' | sed 's/\t//g;s/\(.*\)://g' | sed '/\]$/! s/$/ >/g;/\]$/ s/[][]\(.*\)//g'); entries+=("$n" "$item"); done

  offset=$( whiptail --title "A R C A N G E L" --menu "$(navString)" $MENU_H $MENU_W 8 "${entries[@]}" 3>&2 2>&1 1>&3 ); exit_code=$?

  [[ $exit_code -gt 0 ]] && [[ $level -lt 1 ]] && exit

  if [[ $offset -le $(echo "$items" | wc -l) ]]; then
    if [[ ${#offset} -gt 0 ]]; then
      if [[ ! $(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g') =~ .*"[".* ]]; then
        (( level++ ))
        last_items[$level]="$choice"; choice=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
      else
        line=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g');
        id=$(echo "${line##*:}" | sed 's/[][]\(.*\)//g')
        cmd=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/;s/\x27//g' | cut -d' ' -f1)
        params=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/;s/\x27//g' | cut -d' ' -f2-)
        runCmd "$cmd" "$params"
      fi
    else
      choice="${last_items[$level]}"
      unset last_items[$level]
      (( level-- ))
    fi
    start=${choice%%:*}
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

runCmd() {
  local ARGS=("${@}")
  local CMD="${ARGS[0]}"; local params="${ARGS[@]:1}"

  [ ${#CMD} -lt 1 ] && return; clear

  [ ! -z $CMD ] && [[ "${commands[@]}" =~ "$CMD" ]] && $cmd "${params}" 3>&1 1>&2 2>"$DIR/.log/errors.log"

  checkErrors
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkErrors() {
  local errors=$(cat "$DIR/.log/errors.log" | wc -l)
  [[ $errors -gt 0 ]] && whiptail --msgbox "$(echo -e "ERRORS:\n"; cat $DIR/.log/errors.log)" 0 0 2>&1 1>/dev/tty
  printf '' > "$DIR/.log/errors.log"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navString() {
 nav_string="$(echo -e '\nMENU ')"

 if [[ $level -gt 0 ]]; then
   nav_string+="> "
   for i in "${last_items[@]:2}"; do nav_string+="$( echo "${i##*:}" | sed 's/ //g') > "; done
   nav_string+="${choice##*:}"
 fi
 echo "$nav_string"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

startupSound() {
  local path_files="$assets_path/media/audio/sounds"
  local path_last="$assets_path/.last_sample"

  declare -a samples=($(for f in $assets_path/media/audio/sounds/*; do echo $f | grep -o '[^/]*$'; done))
  local last=$(cat $path_last)
  local total=$(( $(find $path_files -type f -name "*.wav" -printf x | wc -c) -1 ))
  local this=$(( last + 1 )); [[ $this > $total ]] && this=0
  local sample="$path_files/${samples[$this]}"
  local vol=90

  echo "$this" > $path_last

  SDL_AUDIODRIVER='alsa'; AUDIODEV='hw:1,0'
  ffplay -volume "$vol" -nodisp -autoexit -loglevel quiet "$sample"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showSplash() {
  local timeout=${1:-5}
  local img_path=$(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { /^splash_path/ { s/.*=//; s/\x27//g; s/#.*$//; s/\s*$//; p; q } }' "$assets_path/.settings")

  [ -f $img_path ] && { sleep $(( timeout / 2 )); sudo fbi -a -T 1 -d /dev/fb0 -t $timeout --once --noverbose $img_path; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

loadSettings() {
  while read line; do
    key=$(echo "$line" | cut -d= -f1)
    val=$(echo "$line" | cut -d= -f2- | sed "s/'//g")
    declare -g "${key}"="$val"; #echo "$key : $val"
  done< <(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { s/#.*$//; /^\s*$/d; p }' "$assets_path/.settings")
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setBlankTime() { [[ $# -gt 0 ]] && [[ $1 =~ ^[0-9]+$ ]] && echo -ne "\033[9;$1]" > "$console"; }

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

menuSaver() {
  local timeout=${1:-60}
  local elapsed=0
  local elapsed_last=$elapsed
  local saver_state=0
  local saver_pid=
  local asleep=0
  local first_boot=1
  local teensy_timer=0
  local spike_delay=3
  local stored_mode='admin'

  while true; do IFS=$'\n' read -sr elapsed >/dev/null 2>&1;
    if [[ ! $(pgrep -c retroarch) -gt 0 ]]; then
      if [[ $elapsed -ge $timeout ]]; then
        if [[ $first_boot -eq 1 ]]; then
          echo "REQ MILLIS" > /tmp/serial.fifo; sleep 1; teensy_timer=$(cat "$HOMEDIR/ADMIN/.sys/.REQ" | cut -d: -f2)
          [[ $teensy_timer -lt $timeout ]] && { printf '\010' > /tmp/vkbdd.fifo; } || { first_boot=0; }
        else
          if [[ $saver_state -eq 0 ]]; then
            [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; }
            sudo bash "$assets_path/saver/bgSaver.sh" & saver_pid=$!; sleep 1
            stored_mode=$(sed -n '1 {s/\(^.*\t\)//g;p}' "$HOMEDIR/ADMIN/.sys/thd/devices.log")
            sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode saver
            saver_state=1
          elif [[ $saver_state -eq 1 ]]; then
            if [[ ! -z $saver_pid ]] && [[ $(ps --no-headers -p $saver_pid | wc -c) -lt 1 ]]; then
              if [[ $asleep -eq 0 ]]; then
                sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab teensy; sleep 1
                echo "ASLEEP 1" > /tmp/serial.fifo
                sudo sed -i "/ASLEEP/ s/[=].*$/=1/" "$HOMEDIR/ADMIN/.sys/.states"
                asleep=1
              fi
            fi
            sleep 1
          fi
        fi
      elif [[ $elapsed -lt $elapsed_last ]]; then
        if [[ $saver_state -eq 1 ]]; then
          [[ ! -z $saver_pid ]] && [[ $(ps --no-headers -p $saver_pid | wc -c) -gt 0 ]] && { sudo kill -9 $saver_pid >/dev/null 2>&1; wait $saver_pid; saver_pid=; } &>/dev/null
          sudo pkill -f 'bgSaver' >/dev/null 2>&1
          [ -f "$assets_path/fb0.dump" ] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; }
          if [[ $asleep -eq 1 ]]; then
            echo "ASLEEP 0" > /tmp/serial.fifo
            sudo sed -i "/ASLEEP/ s/[=].*$/=0/" "$HOMEDIR/ADMIN/.sys/.states"
            sleep $spike_delay
            sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --add teensy
            asleep=0
          fi
          sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode $stored_mode
          saver_state=0
        fi
      fi
      sleep 0.1
      elapsed_last=$elapsed
    fi
  done< <( cat <>/tmp/elapsed.fifo )
}

menuSaver_old() {
  local timeout=${1:-60}
  local elapsed=$(cat /tmp/elapsed.fifo)
  local elapsed_last=$elapsed
  local saver_state=0
  local asleep=0
  local first_boot=1
  local teensy_timer=
  local await_sleep=0
  local saver_pid=
  local stored_mode='admin'

  #printf '\010' > /tmp/vkbdd.fifo; cat /tmp/elapsed.fifo | head -n 1 >/dev/null 2>&1

  #local count=0; while [[ $count -lt 3 ]]; do cat /tmp/elapsed.fifo && (( count++ )); done

  while true; do IFS=$'\n' read -sr elapsed >/dev/null 2>&1
    if [[ ! $(pgrep -c retroarch) -gt 0 ]]; then
      if [[ $elapsed =~ ^[0-9]+$ ]]; then
        if [[ $saver_state -eq 0 ]] && [[ $elapsed -ge $timeout ]]; then

          if [[ $first_boot -lt 1 ]]; then
            teensy_timer=$elapsed
          else
            echo "REQ MILLIS" > /tmp/serial.fifo; sleep 0.5
            teensy_timer=$(cat $req | cut -d: -f2)

            [[ $teensy_timer -lt $timeout ]] && { \
              printf '\010' > /tmp/vkbdd.fifo; sleep 1; \
              while [[ $count -lt 3 ]]; do cat /tmp/elapsed.fifo | head -n 1 >/dev/null 2>&1 && (( count++ )); done; \
              elapsed=$teensy_timer; \
            }

            echo "LCD 0 TEENSY TIME:" > /tmp/serial.fifo; echo "LCD 1 $teensy_timer" > /tmp/serial.fifo

            [[ ! $teensy_timer =~ ^[0-9]+$ ]] && teensy_timer=$elapsed
            first_boot=0;
          fi

          if [[ $teensy_timer -ge $timeout ]]; then saver_state=1;
            [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; }
            stored_mode=$(sed -n '1 {s/\(^.*\t\)//g;p}' "$HOMEDIR/ADMIN/.sys/thd/devices.log")
            sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode saver
            sudo bash "$assets_path/saver/bgSaver.sh" & saver_pid=$!
          fi

        elif [[ $saver_state -eq 1 ]]; then
          if [[ $elapsed -lt $elapsed_last ]]; then saver_state=0;

            if [[ $asleep -eq 1 ]]; then
              echo "ASLEEP 0" > /tmp/serial.fifo; asleep=0
              sudo sed -i "/ASLEEP/ s/[=].*$/=0/" "$sys_states";
              sleep 3 # wait for power to come on
              sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --add teensy
            fi

            #[[ $asleep -eq 1 ]] && { echo "ASLEEP 0" > /tmp/serial.fifo; asleep=0; await_sleep=0; sudo sed -i "/ASLEEP/ s/[=].*$/=0/" "$sys_states"; }

            sudo pkill -f 'bgSaver'; saver_pid=

            [ -f "$assets_path/fb0.dump" ] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; }
            [[ $(pgrep -c ffplay) -gt 0 ]] && sudo pkill ffplay

            sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode $stored_mode;
            sudo setterm --blank poke --term linux </dev/tty1; #printf '\010' > /tmp/vkbdd.fifo;
          else
            if [[ $asleep -eq 0 ]] && [[ $(pgrep -fc 'bgSaver') -lt 1 ]]; then
              declare -c exit_code=$(cat "$assets_path/saver/exit_code");

              if [[ $exit_code -eq 0 ]] && [[ $(pgrep -c ffplay) -lt 1 ]]; then
                echo "ASLEEP 1" > /tmp/serial.fifo; asleep=1
                sudo sed -i "/ASLEEP/ s/[=].*$/=1/" "$sys_states"
                printf '' > "$assets_path/saver/exit_code"
                sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab teensy
                sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode sleep
              fi

              #[[ $exit_code -eq 0 ]] && [[ $(pgrep -c ffplay) -lt 1 ]] && { echo "ASLEEP 1" > /tmp/serial.fifo; asleep=1; sudo sed -i "/ASLEEP/ s/[=].*$/=1/" "$sys_states"; printf '' > "$assets_path/saver/exit_code"; }
            fi
          fi
        fi
        elapsed_last=$elapsed
      fi
    elif [[ $(pgrep -c retroarch) -gt 0 ]]; then
      [[ $(pgrep -fc 'bgSaver') -gt 0 ]] && sudo pkill -f 'bgSaver'; saver_pid=
      [[ $(pgrep -c ffplay) -gt 0 ]] && sudo pkill ffplay
      [[ $(pgrep -c omxplayer) -gt 0 ]] && sudo pkill omxplayer
    fi
    sleep 0.1
  done< <( cat <>/tmp/elapsed.fifo )
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  local signal=$1
  [ -f "$HOMEDIR/.dialogrc" ] && sudo rm "$HOMEDIR/.dialogrc"

  JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && { sudo kill -9 "${JOBS[@]}"; } >/dev/null 2>&1
  sudo pkill -f 'bgSaver' >/dev/null 2>&1

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term
  sed -i "/ASLEEP/ s/[=].*$/=0/" "$sys_states"
  sed -i "/UI=/ s/[=].*$/=\x27${prev_state:-term}\x27/" "$sys_states"

  [[ $TERM == linux ]] && echo -en "\e]P700FC00"

  [[ $(pgrep -fc 'bgSaver') -gt 0 ]] && sudo pkill -f 'bgSaver'
  [[ $(pgrep -c ffplay) -gt 0 ]] && sudo pkill ffplay
  [[ $(pgrep -c omxplayer) -gt 0 ]] && sudo pkill omxplayer

  echo "ASLEEP 0" > /tmp/serial.fifo
  echo "VFD 4  G O O D B Y E" > /tmp/serial.fifo

  setBlankTime "$(( t_blank / 60 ))"

  export PS1="$PS1_STORED"; stty -F /dev/tty1 sane ; sudo setterm --cursor on

  clear
  exit $signal
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init

while true; do Menu; done

exit


# ------------------------------------------------------------------------------------------------------------

#if [[ $asleep -eq 0 ]] && [[ $(pgrep -fc 'bgSaver') -lt 1 ]]; then
#  if [[ $await_sleep -eq 0 ]]; then
#    declare -c exit_code=$(cat "$assets_path/saver/exit_code");
#    [[ $exit_code -eq 0 ]] && [[ $(pgrep -c ffplay) -lt 1 ]] && { await_sleep=1; printf '' > "$assets_path/saver/exit_code"; }
#  else
#    echo "REQ PIR" > /tmp/serial.fifo; sleep 1; teensy_timer=$(cat $req | cut -d: -f2); [[ ! $teensy_timer =~ ^[0-9]+$ ]] && teensy_timer=$timeout
#    [[ $teensy_timer -ge $timeout ]] && { echo "ASLEEP 1" > /tmp/serial.fifo; asleep=1; sudo sed -i "/ASLEEP/ s/[=].*$/=1/" "$sys_states"; }
#  fi
#fi

#if [[ $asleep -eq 0 ]] && [[ $(pgrep -fc 'bgSaver') -lt 1 ]]; then
#  declare -c exit_code=$(cat "$assets_path/saver/exit_code");
#  [[ $exit_code -eq 0 ]] && [[ $(pgrep -c ffplay) -lt 1 ]] && { \
#    echo "ASLEEP 1" > /tmp/serial.fifo; asleep=1; \
#    sudo sed -i "/ASLEEP/ s/[=].*$/=1/" "$sys_states"
#    printf '' > "$assets_path/saver/exit_code"; }
#fi

#if [[ $saver_state -eq 0 ]] && [[ $elapsed -ge $timeout ]]; then saver_state=1;
#  #teensy_uptime=$(echo "REQ MILLIS" > /tmp/serial.fifo; sleep 0.5; cat $req | cut -d: -f2)
#  #if [[ $teensy_uptime -ge $elapsed ]]; then saver_state=1;
#    [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; }
#    stored_mode=$(sed -n '1 {s/\(^.*\t\)//g;p}' "$HOMEDIR/ADMIN/.sys/thd/devices.log")
#    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode saver
#    sudo bash "$assets_path/saver/bgSaver.sh" & saver_pid=$!
#  #fi
