#!/bin/bash

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$DIR/.assets"
media_path="$assets_path/media"
list_path="$assets_path/GAMES/.list"
font_path="$assets_path/fonts"


width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 ))
height=$(echo "$(tput lines)")
maxPage=$(( height - 3 ))
header_height=0
p=0

declare -a headers
declare -a pages=('70S' '80S' '90S')
declare -a fonts=('halfiwi' 'Straight' 'Small' 'Mini' 'kompaktblk' 'smslant' 'Chunky' 'ublk' 'Stampatello' 'eftifont')
declare -A pageTitles=( [70S]="1970s" [80S]="1980s" [90S]="1990s" )


#font="$font_path/halfiwi.flf"
#font="$font_path/Calvin_S.flf"

pageIndex=0

# ------------------------------------------------------------------------------

header() {
  local text=$(printf "${headers[$pageIndex]}"); #[[ $colors -gt 0 ]] && text=${C}${text}${NC}
  local line=$(printf "$(for i in $(seq 0 $(( width-1 ))); do printf "${line_char:-.}"; done)"); #[[ $colors -gt 0 ]] && line=${C}${line}${NC}

  tput cup 0 0; echo "${text}"; vpos=$header_height
  tput cup $vpos 0; printf "${line}"; (( vpos+=2 )); tput cup $vpos 0; tput sc
}

# ------------------------------------------------------------------------------

echo "$maxPage ( $height )"
echo -e "${pages[$p]}\n"

for font in "${fonts[@]}"; do
  font="$font_path/$font.flf"; echo "$font";
  str=$(printf "${pageTitles[${pages[$p]}]}"); txt=$(printf "$(figlet -w $w -c ${str,,} -f $font)");
  headers+=("$(printf "${txt}")");
  [ $header_height -eq 0 ] && { header_height="$( echo "${headers[-1]}" | wc -l)";
  maxPage=$(( maxPage - ( $header_height + 2 ) )); }
  echo -e "height: $height\nmaxPage: $maxPage\nheader_height: $header_height"
  read -srn1 void &>/dev/null
  clear; header
  read -srn1 void &>/dev/null
  (( pageIndex++ ))
done

exit

# ------------------------------------------------------------------------------

for p in $(seq 0 $(( ${#pages[@]}-1 )) ); do
  echo "$p - ${pages[$p]}"
  str=$(printf "${pageTitles[${pages[$p]}]}"); txt=$(printf "$(figlet -w $w -c ${str,,} -f $font)");
  #echo "$(printf "${txt}") ( $(echo "$(printf "${txt}")" | wc -l) )"
  headers+=("$(printf "${txt}")");
  [ $header_height -eq 0 ] && { header_height="$( echo "${headers[-1]}" | wc -l)";
  maxPage=$(( maxPage - ( $header_height + 2 ) )); }
  echo -e "height: $height\nmaxPage: $maxPage\nheader_height: $header_height"
  read -srn1 void &>/dev/null
  clear; header
  read -srn1 void &>/dev/null
done

exit

# ------------------------------------------------------------------------------

declare -a fonts=('halfiwi' 'Straight' 'Small' 'Mini' 'kompaktblk' 'smslant' 'Chunky' 'ublk' 'Stampatello' 'eftifont')
declare -A font_ids=( [70S]="0 1 2 4 7" [80S]="0 1 2 5 8" [90S]="0 1 3 6 9" );
declare -A font_idx=( [70S]="0" [80S]="0" [90S]="0" )

function makeArr() {
  declare -a uniq_idx=($(for i in $(seq 1 "$(echo ${font_ids[@]:0:1} | wc -w)"); do echo $i; done | shuf))
  for i in $(seq 1 $#); do font_idx["${!i}"]="${uniq_idx[$i]}"; done
}

makeArr "${!font_ids[@]}"; sleep 1

for key in "${!font_ids[@]}"; do idx=$(echo "${font_ids[$key]}" | awk -v i="${font_idx[$key]}" '{print $(i)}'); font="${fonts[$idx]}"; done

#for key in "${!font_ids[@]}"; do idx=$(echo "${font_ids[$key]}" | awk -v i="${font_idx[$key]}" '{print $(i)}'); font="${fonts[$idx]}"; echo "$key : \${fonts[$idx]} = $font"; done

exit

# ------------------------------------------------------------------------------
