#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$HOMEDIR/ADMIN/MENU/.assets"

#________________________________________________________________________________

# REM
cp .list32 .list2

clear; sleep 1

whiptail --yesno "CONTINUE?" 0 0 0 2>&1 1>$(tty); [ $? -gt 0 ] && { cat "$DIR/.list2"; exit; }

grep '&apos;' "$DIR/.list2"

#________________________________________________________________________________


# RE-FORMAT HTML CHARACHTERS
sed -i 's/&apos;//' "$DIR/.list2"
edited=0
for line in "$(grep '&.*;' $DIR/.list2)"; do
  line_num=$(echo "$line" | awk '{print $1}')
  line_fmt=$(echo "$line" | perl -MHTML::Entities -pe 'decode_entities($_);')
  sed -i "/${line_num}/d" "$DIR/.list2"; echo "$line_fmt" | sudo tee -a "$DIR/.list2" &>/dev/null; edited=1
done
[[ $edited -gt 0 ]] && tac "$DIR/.list2" | sort -k4,4 -t \' --output "$DIR/.list2"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

for i in $(seq 1 $(cat "$DIR/.list2" | wc -l)); do
  name=$(sed -n "${i}p" "$DIR/.list2" | cut -d\' -f2)
  find "$assets_path/media/marquees" -type f -iname "$name*.ppm" -exec false {} +; found=$?; sed -i "${i}{s/'[^']*'/'${found}'/7}" "$DIR/.list2"
done

exit

#________________________________________________________________________________

