#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$HOMEDIR/ADMIN/MENU/.assets"
GAMES_DIR="$assets_path/GAMES"
roms_dir="$HOMEDIR/RetroPie/roms/mame-libretro"

#________________________________________________________________________________

# REM
cp "$GAMES_DIR/.list" "$GAMES_DIR/.list2"

clear; sleep 1

#whiptail --yesno "CONTINUE?" 0 0 0 2>&1 1>$(tty); [ $? -gt 0 ] && { cat "$GAMES_DIR/.list2"; exit; }

#________________________________________________________________________________

# RE-FORMAT HTML CHARACHTERS

sed -i 's/&apos;//' "$GAMES_DIR/.list2"

if [[ $(grep -c '&.*;' "$GAMES_DIR/.list2") -gt 0 ]]; then
  echo "REPLACING HTML CHARACTERS"
  for line in "$(grep '&.*;' $GAMES_DIR/.list2)"; do
    line_num=$(echo "$line" | awk '{print $1}')
    line_fmt=$(echo "$line" | perl -MHTML::Entities -pe 'decode_entities($_);')
    sed -i "/${line_num}/d" "$GAMES_DIR/.list2"; echo "$line_fmt" | sudo tee -a "$GAMES_DIR/.list2" &>/dev/null
  done
  tac "$GAMES_DIR/.list2" | sort -k4,4 -t \' --output "$GAMES_DIR/.list2"
fi

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# CHECK FOR MARQUEE AND SET FLAG
for i in $(seq 1 $(cat "$GAMES_DIR/.list2" | wc -l)); do
  name=$(sed -n "${i}p" "$GAMES_DIR/.list2" | cut -d\' -f2)
  find "$assets_path/media/marquees" -type f -iname "$name*.ppm" -exec false {} +; found=$?; sed -i "${i}{s/'[^']*'/'${found}'/7}" "$GAMES_DIR/.list2"
done

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# CHECK MISSING ROMS
missing=()
for game in $(awk -F'\x27' '{print $2}' "$GAMES_DIR/.list2"); do find "$roms_dir" -type f -iname "$game.zip" -exec false {} +; [ $? -eq 0 ] && missing+=("$game"); done

if [[ ${#missing[@]} -gt 0 ]]; then
  echo -e "\nREMOVING MISSING ROMS FROM LIST:\n$(for i in ${missing[@]}; do echo $i; done)"
  for n in "${missing[@]}"; do sed -i "/.*${n}.*$/d" "$GAMES_DIR/.list2"; done
  awk '{$1="";print NR""$0}' "$GAMES_DIR/.list2" | sudo tee "$GAMES_DIR/.list2" &>/dev/null
fi

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# CHECK DUPLICATE LINES
dups=$(awk '{$1=""; print}' "$GAMES_DIR/.list2" | uniq -d | wc -l)

if [[ $dups -gt 0 ]]; then
  echo -e "\nREMOVING DUPLICATES:"

  while read line; do
    name=$(echo "$line" | awk -F'\x27' '{print $2}'); echo "  $name"
    sed -i "0,/${name}/{/${name}/d}" "$GAMES_DIR/.list2"
  done< <(awk '{$1=""; print}' "$GAMES_DIR/.list2" | sed 's/ //' | uniq -d)

  awk '{$1="";print NR""$0}' "$GAMES_DIR/.list2" | sudo tee "$GAMES_DIR/.list2" &>/dev/null
fi

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# ADD FILENAME TO DUPLICATE TITLES
dup_titles=($(while read title; do grep -w "$title" "$GAMES_DIR/.list2" | tail -n +2 | awk '{print $1}'; done< <(awk -F'\x27' '{print $4}' "$GAMES_DIR/.list2" | uniq -d)))

if [[ ${#dup_titles[@]} -gt 0 ]]; then
  echo -e "\nRENAMING DUPLICATE TITLES\nLINES:"

  for n in ${dup_titles[@]}; do
    line=$(sed "/${n}/q;d" "$GAMES_DIR/.list2"); echo "  $line"
    new_title=$(echo "$line" | awk -F'\x27' '{$4=$4" ("$2")";print "\x27"$4"\x27"}')
    sed -i "/^${n}/ s/'[^']*'/${new_title}/2" "$GAMES_DIR/.list2";
  done
fi

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# CHECK INVALID PATHS
invalid=()

while read line; do
  path=$(echo "$line" | awk -F'\x27' '{print $12}'); path="${path%/*}";
  [[ ! "$path" == $roms_dir ]] && invalid+=($(echo "$line" | grep -o '^[^ ]*'))
done< <(cat "$GAMES_DIR/.list2")
[[ ${#invalid[@]} -gt 0 ]] && { echo -e "\nINVALID PATHS ON LINES:"; for i in "${invalid[@]}"; do echo "  $i"; done; }

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# DONE
echo ""; sleep 2
cat "$GAMES_DIR/.list2"
exit

#________________________________________________________________________________

