#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

data_dir="$HOMEDIR/CAFCA/data/mame-libretro"
roms_dir="$HOMEDIR/RetroPie/roms/mame-libretro"

# ------------------------------------------------------------------------------------------------

sudo cp -f "$data_dir/table" "$data_dir/table.bak"
sudo cp -f "$data_dir/timers" "$data_dir/timers.bak"
sudo cp -f "$data_dir/clearram" "$data_dir/clearram.bak"

#for game in $(ls -la "$roms_dir" | tail -n +4 | grep -v 'mame*' | grep -o '[^ ]*$' | sed 's/[.].*$//'); do
for game in $(sudo find "$roms_dir" -type f -iname '*.zip' | grep -o '[^/]*$' | sed 's/[.].*$//' | sort -k 1,1); do
  [[ $(grep -wc "^${game}" "$data_dir/table") -lt 1 ]] && { echo "$game " >> "$data_dir/table"; echo "$game -> table"; }
  [[ $(grep -wc "^${game}" "$data_dir/timers") -lt 1 ]] && { echo "$game 1" >> "$data_dir/timers"; echo "$game -> timers"; }
  [[ $(grep -wc "^${game}" "$data_dir/clearram") -lt 1 ]] && { echo "$game 0" >> "$data_dir/clearram"; echo "$game -> clearram"; }
done

cat "$data_dir/table" | sort -k 1,1 | column -t | sudo tee "$data_dir/table" &> /dev/null
cat "$data_dir/timers" | sort -k 1,1 | column -t | sudo tee "$data_dir/timers" &> /dev/null
cat "$data_dir/clearram" | sort -k 1,1 | column -t | sudo tee "$data_dir/clearram" &> /dev/null

# ------------------------------------------------------------------------------------------------
