#!/bin/bash

SCRIPT=$(readlink -f $0)
SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

gun_games='/home/pi/.emulationstation/collections/custom-lightgun.cfg'
fav_games='/home/pi/.emulationstation/collections/custom-arkade.cfg'
gamelist='/home/pi/.emulationstation/gamelists/mame-libretro/gamelist.xml'

game_count=$(grep -Ec '<game>' "$gamelist")
system="$(echo $gamelist | cut -d. -f2 | awk -F'/' '{print $(NF-1)}')"
rom_dir="/home/pi/RetroPie/roms/$system"
list_dir="$SCRIPT_DIR/../GAMES"

concat_title=0
strip_title=1

safe_mode=1

[[ $safe_mode -eq 1 ]] && list_path="$list_dir/.list-test" || list_path="$list_dir/.list"

cleanString() {
 input="${1}"; word="${2}"
 echo "$input" | grep -E "<$word>" | awk '{$1=$1;print}' | sed "s/<$word>//g; s/<\/$word>//g"
}

dumpData() {
  for (( n=1; n<=$game_count; n++ )); do
    data=$(awk -v p="<game>" -v n="$n" '$0~p{i++}i==n' "$gamelist")
    title=$(cleanString "$data" 'name' | sed "s/\x27//g")
    date=$(cleanString "$data" 'releasedate');date="${date:0:4}"; [[ ${#date} -lt 1 ]] && date='19xx'
    publisher=$(cleanString "$data" 'publisher');publisher=$(echo "$publisher" | cut -d, -f1); [[ ${#publisher} -lt 1 ]] && publisher='<unknown>'
    path=$(cleanString "$data" 'path'); path=$(echo "$path" | cut -d\/ -f2-)
    name=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)

    [[ $(grep -c "$rom_dir/$path" "$gun_games") -lt 1 ]] && type='JOY' || type='GUN'

    [[ $strip_title -gt 0 ]] && { title="${title%%'  '*}"; title="${title%%' ('*}"; }  #{ title="${title%%' ('*}"; title="${title%%'  '*}"; }
    [[ $concat_title -gt 0 ]] && title="${title} (${date}) [${publisher}]"

    img_path="$SCRIPT_DIR/../media/slideshow/mame-libretro/$name"; images=''
    [ -s "$img_path" ] && images=$(find "$SCRIPT_DIR/../media/slideshow/mame-libretro/$name" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit 2>/dev/null)
    [ -n "$images" ] && images="${images##*.}"
    echo -n "'$name' '$title' '$date' '$publisher' '$type' '$rom_dir/$path' '$images' '[ "
    [[ $(grep -c "$path" "$fav_games") -gt 0 ]] && echo -n "FAV "
    [[ "${type}" == GUN ]] && echo -n "${type} "; echo "]'"
  done | sudo tee "$list_path" &>/dev/null
}

makeList() {
  tac "$list_path" \
  | sort -k4,4 -t \' \
  | awk -F'\x27' '{ \
    if (++dup[$4] == 1){ print $0; } \
    else { $4=$4" ("$2")"; for(i=2;i<=NF;i+=2) { printf "\x27%s\x27 ", $i }; print "" } \
  }' \
  | sudo tee "$list_path" &>/dev/null

  grep -n '' "$list_path" | sed 's/:/ /g' | sudo tee "$list_path" #&>/dev/null
  sudo chown pi:root "$list_path"; sudo chmod 775 "$list_path"
}

sudo cp -R "$list_path" "$list_path.bak"
dumpData
makeList

exit
