#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
assets_path="$HOMEDIR/ADMIN/MENU/.assets"

path_files="$assets_path/media/audio/sounds"
path_last="$assets_path/.last_sample"

SDL_AUDIODRIVER='alsa'; AUDIODEV='hw:1,0'

samples=($(for f in $assets_path/media/audio/sounds/*; do echo $f | grep -o '[^/]*$'; done))
last=$(cat $path_last)
total=$(( $(find $path_files -type f -name "*.wav" -printf x | wc -c) -1 ))
this=$(( last + 1 )); [[ $this > $total ]] && this=0
sample="$path_files/${samples[$this]}"
vol=90

# DEBUG:
echo -e "Playing sample $this / $total - $sample\ndevice: $AUDIODEV, driver: $SDL_AUDIODRIVER\nplayer: ffplay, params: -volume $vol -nodisp -autoexit -loglevel quiet"

echo "$this" > $path_last

#[[ $# -gt 0 ]] && [[ "$1" =~ ^[0-9]+$ ]] && sleep "$1"

ffplay -volume "$vol" -nodisp -autoexit -loglevel quiet "$sample"
