#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$HOMEDIR/ADMIN/MENU/.assets"
roms_dir="$HOMEDIR/RetroPie/roms/mame-libretro"
temp_dir="$DIR/tmp"

#________________________________________________________________________________

# SETUP

export NEWT_COLORS="$(cat $HOMEDIR/ADMIN/MENU/.assets/config/whiptail_theme.cfg)"

[ -d $temp_dir ] && sudo rm -R $temp_dir
mktemp -d --suffix=_TEMP --tmpdir=$DIR &>/dev/null && { mv -f $DIR/tmp*_TEMP $temp_dir; for tmp in $temp_dir; do sudo chmod 775 $temp_dir; sudo chown pi:root $temp_dir; done; }

cp "$assets_path/GAMES/.list" "$temp_dir/.list"

clear

# -------------------------------------------------------------------------------

Main() {
  #downloader
  scraper
  #refresher
  #update_lists
  #submit_changes
}

# ----------------------------------------------------------------------------------------------

downloader() {
  local torrent_file="$HOMEDIR/ADMIN/FILES/TORRENTS/mame078_romset.torrent"
  local torrent_dir="$HOMEDIR/downloads/MAME2003_Reference_Set_MAME0.78_ROMs_CHDs_Samples/roms"
  local items=()

  #echo "torrent_file: $torrent_file"; echo "torrent_dir: $torrent_dir"
  echo "Starting transmission.."

  sudo -u pi bash -c 'transmission-daemon'; sleep 1
  declare -c id=$(sudo -u pi bash -c 'transmission-remote -l' | grep -A1 '^ID' | tail -n 1 | grep -m1 'MAME' | awk '{print $1}')
  [[ $id =~ ^[0-9]+$ ]] && { sudo -u pi id=$id bash -c 'transmission-remote -t $id -r' &>/dev/null; sudo rm $torrent_dir/*.* 2>/dev/null; }
  sudo -u pi file=$torrent_file bash -c 'transmission-remote -a $file; while [[ $(transmission-remote -l | grep -c Verifying) -gt 0 ]]; do :; done' &>/dev/null
  declare -c id=$(sudo -u pi bash -c 'transmission-remote -l' | grep -A1 '^ID' | tail -n 1 | grep -m1 'MAME' | awk '{print $1}')

  sudo -u pi id=$id bash -c 'transmission-remote -t $id -Gall' &>/dev/null
  sudo -u pi id=$id bash -c 'transmission-remote -t $id -f' | grep -we 'roms' | sed 's/:.*\/roms\// /' | sudo tee "$temp_dir/torrent.dump" &>/dev/null
  sed -i '/^.*.chd/d;/^.*.png/d' "$temp_dir/torrent.dump"

  local entries=($(awk '{ print $1"_"$2; }' "$temp_dir/torrent.dump"))
  for item in "${entries[@]}"; do items+=("${item%%_*}" "${item##*_}" OFF); done

  local indexes=$(whiptail --checklist "SELECT GAME" 0 0 0 "${items[@]}" 2>&1 1>$(tty)); indexes=($(echo "$indexes" | sed 's/\x22//g'))
  local file_list=$(IFS=,; echo "${indexes[*]}")
  local log=

  if [[ ${#indexes[@]} -gt 0 ]]; then
    [ -d $output_dir ] && sudo rm $output_dir/* 2>/dev/null

    sudo -u pi id=$id list=$file_list bash -c 'transmission-remote -t $id -g$list'
    sudo -u pi id=$id bash -c 'transmission-remote -t $id --start'

    while true; do
      log=$(sudo -u pi id=$id bash -c 'transmission-remote -t $id -f' | awk '{if ($4 ~ "Yes") print;}');
      for p in $(echo "$log" | awk '{gsub(/%/,"", $2);print $2}'); do [[ $p -lt 100 ]] && { downloading=1; break; }; done; clear
      echo -e "Downloading:\n"; echo "$log" | awk '{n=split($NF,a,"/"); print $1" "a[n]" "$2}' | column -t; sleep 1;
      [[ $(echo "$log" | grep -c '100%') -eq ${#indexes[@]} ]] && break
    done
  else
    exit 1
  fi

  while [[ $(find $torrent_dir -type f -iname '*.part' | wc -l) -gt 0 ]]; do sleep 1; done; sleep 3

  find $torrent_dir -type f -iname '*.zip' ! -iname '*.part' -exec cp -v {} $roms_dir \;
}

# -------------------------------------------------------------------------------

scraper() {
  local SCRAPER='/opt/retropie/supplementary/skyscraper/Skyscraper'
  local WORKDIR="$temp_dir/scraper"
  local gamelist="$WORKDIR/gamelist.xml"
  local writing=0
  local count=0

  mkdir "$WORKDIR"
  sudo cp "$HOMEDIR/.emulationstation/gamelists/mame-libretro/gamelist.xml" "$WORKDIR/gamelist.xml"

  printf '' > "$temp_dir/downloaded"
  find $roms_dir -type f -iname '*.zip' -exec bash -c '[[ ! ${1} =~ ${0} ]] && echo "${0}"' {} "$(awk -F'\x27' '{print $12}' $temp_dir/.list)" \; | sudo tee "$temp_dir/downloaded" &>/dev/null

  if [[ $(cat "$temp_dir/downloaded" | wc -l) -gt 0 ]]; then
    while read line; do line=$(echo "$line" | sed -E "s/\x1B\[([0-9]{1,2}(;[0-9]{1,2})*)?[m,K,H,f,J]//gm" | sed -E "s/\x1B\([A-Z]{1}(\x1B\[[m,K,H,f,J])?//gm");
      [[ "$line" =~ 'Pass 1' ]] && { writing=1; clear; } #echo "$line" #{ echo "${scr}"; scr=''; }
      [[ $writing -eq 1 ]] && { echo "$line"; (( count++ )); }
      [[ $count -ge 15 ]] && { writing=0; count=0; }
    done< <( \
      $SCRAPER \
        -p mame-libretro -s screenscraper -i "$roms_dir" -g "$WORKDIR" -a "$HOMEDIR/.skyscraper/artwork.xml" --flags unattendskip --includefrom "$temp_dir/downloaded" \
    )

    echo -e "\nWRITING GAMELIST\n"

    $SCRAPER -p mame-libretro -i "$HOMEDIR/RetroPie/roms/mame-libretro" -g "$WORKDIR" -a "$HOMEDIR/.skyscraper/artwork.xml" --flags unattend &>/dev/null

    local game_count=$(grep -Ec '<game>' "$WORKDIR/gamelist.xml"); echo "game_count: $game_count"

    for (( n=1; n<=$game_count; n++ )); do
      data=$(awk -v p="<game>" -v n="$n" '$0~p{i++}i==n' "$WORKDIR/gamelist.xml")
      path=$(echo "$data" | grep -E "<path>" | awk '{$1=$1;print}' | sed 's/<path>//g; s/<\/path>//g')
      name=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)

      if [[ $(grep -c "$name" "$temp_dir/downloaded") -gt 0 ]] && [[ ${#data} -gt 0 ]]; then
        title=$(echo "$data" | grep -E "<name>" | awk '{$1=$1;print}' | sed 's/<name>//g; s/<\/name>//g')
        date=$(echo "$data" | grep -E "<releasedate>" | awk '{$1=$1;print}' | sed 's/<releasedate>//g; s/<\/releasedate>//g'); date="${date:0:4}"; [[ ${#date} -lt 1 ]] && date='19xx'
        publisher=$(echo "$data" | grep -E "<publisher>" | awk '{$1=$1;print}' | sed 's/<publisher>//g; s/<\/publisher>//g'); publisher=$(echo "$publisher" | cut -d, -f1); [[ ${#publisher} -lt 1 ]] && publisher='<unknown>'
        type='JOY'
        find "$assets_path/media/marquees" -type f -iname "$name*" -exec false {} +; marquee=$?
        echo "'$name' '$title' '$date' '$publisher' '$type' '$path' '$marquee' '[ ]'"

        [[ $(grep -c "<path>$path</path>" "$WORKDIR/gamelist.xml") -lt 1 ]] && echo "${data}" | sed 's/^/\t/' | sudo tee -a "$WORKDIR/gamelist.xml" &>/dev/null
      fi
    done | sudo tee "$WORKDIR/new_entries" &>/dev/null

    #awk '{$1="";print $0}' "$temp_dir/.list" | sed 's/ //' | sudo tee "$temp_dir/.list" &>/dev/null
    cat "$WORKDIR/new_entries" | awk '{print "0 "$0}' | sudo tee -a "$temp_dir/.list" &>/dev/null
    cat "$temp_dir/.list" | sort -k4,4 -t \' --output "$temp_dir/.list"
    awk '{$1="";print NR""$0}' "$temp_dir/.list" | sudo tee "$temp_dir/.list"

    echo "DONE"
  fi
}

# ----------------------------------------------------------------------------------------------

refresher() {
  # RE-FORMAT HTML CHARACHTERS
  sed -i 's/&apos;//' "$temp_dir/.list"
  if [[ $(grep -c '&.*;' "$temp_dir/.list") -gt 0 ]]; then
    for line in "$(grep '&.*;' $temp_dir/.list)"; do
      line_num=$(echo "$line" | awk '{print $1}')
      line_fmt=$(echo "$line" | perl -MHTML::Entities -pe 'decode_entities($_);')
      sed -i "/${line_num}/d" "$temp_dir/.list"; echo "$line_fmt" | sudo tee -a "$temp_dir/.list" &>/dev/null
    done
    tac "$temp_dir/.list" | sort -k4,4 -t \' --output "$temp_dir/.list"
  fi
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # CHECK FOR MARQUEE AND SET FLAG
  for i in $(seq 1 $(cat "$temp_dir/.list" | wc -l)); do
    name=$(sed -n "${i}p" "$temp_dir/.list" | cut -d\' -f2)
    find "$assets_path/media/marquees" -type f -iname "$name*.ppm" -exec false {} +; found=$?;
    sed -i "${i}{s/'[^']*'/'${found}'/7}" "$temp_dir/.list"
  done
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # CHECK MISSING ROMS
  local missing=()
  for game in $(awk -F'\x27' '{print $2}' "$temp_dir/.list"); do find "$roms_dir" -type f -iname "$game.zip" -exec false {} +; [ $? -eq 0 ] && missing+=("$game"); done
  if [[ ${#missing[@]} -gt 0 ]]; then
    for n in "${missing[@]}"; do sed -i "/.*${n}.*$/d" "$temp_dir/.list"; done
    awk '{$1="";print NR""$0}' "$temp_dir/.list" | sudo tee "$temp_dir/.list" &>/dev/null
  fi
  #while read path; do index=$(echo $path | awk '{print $1}'); path=$(echo $path | cut -d' ' -f2-); [ ! -f $path ] && sed -i "/^${index}/d" "$temp_dir/.list"; done< <(awk -F'\x27' '{print $1" "$12}' "$temp_dir/.list"); awk '{$1="";print NR""$0}' "$temp_dir/.list" | sudo tee "$temp_dir/.list" &>/dev/null
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # CHECK DUPLICATE LINES
  local dups=$(awk '{$1=""; print}' "$temp_dir/.list" | uniq -d | wc -l)
  if [[ $dups -gt 0 ]]; then
    while read line; do
      local name=$(echo "$line" | awk -F'\x27' '{print $2}'); sed -i "0,/${name}/{/${name}/d}" "$temp_dir/.list"
    done< <(awk '{$1=""; print}' "$temp_dir/.list" | sed 's/ //' | uniq -d)
    awk '{$1="";print NR""$0}' "$temp_dir/.list" | sudo tee "$temp_dir/.list" &>/dev/null
  fi
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # ADD FILENAME TO DUPLICATE TITLES
  local dup_titles=($(while read title; do grep -w "$title" "$temp_dir/.list" | tail -n +2 | awk '{print $1}'; done< <(awk -F'\x27' '{print $4}' "$temp_dir/.list" | uniq -d)))
  if [[ ${#dup_titles[@]} -gt 0 ]]; then
    for n in ${dup_titles[@]}; do
      line=$(sed "/${n}/q;d" "$temp_dir/.list");
      new_title=$(echo "$line" | awk -F'\x27' '{$4=$4" ("$2")";print "\x27"$4"\x27"}')
      sed -i "/^${n}/ s/'[^']*'/${new_title}/2" "$temp_dir/.list"
    done
  fi
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # CHECK INVALID PATHS
  #local invalid=(); while read line; do path=$(echo "$line" | awk -F'\x27' '{print $12}'); path="${path%/*}"; [[ ! "$path" == $roms_dir ]] && invalid+=($(echo "$line" | grep -o '^[^ ]*')); done< <(cat "$temp_dir/.list"); [[ ${#invalid[@]} -gt 0 ]] && { echo -e "\nINVALID PATHS ON LINES:"; for i in "${invalid[@]}"; do echo "  $i"; done; }
}

# -------------------------------------------------------------------------------

update_lists() {
  local cafca_dir="$HOMEDIR/CAFCA/data/mame-libretro"

  sudo cp "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.shooters" "$temp_dir/.shooters"
  for game in $(cat "$temp_dir/.list" | grep '\[*GUN*' | awk -F'\x27' '{print $2}'); do
    [[ $(grep -c "^$game" "$temp_dir/.shooters") -lt 1 ]] && printf '%-8s\t1\n' "$game"
  done >> "$temp_dir/.shooters"
  sort -k1,1 "$temp_dir/.shooters" --output="$temp_dir/.shooters"

  sudo cp "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.spinners" "$temp_dir/.spinners"
  for game in $(awk -F'\x27' '{if ($10 ~ "SPIN") print $2;}' "$temp_dir/.list"); do
    [[ $(grep -c "^$game" "$temp_dir/.spinners") -lt 1 ]] && printf '%-8s\t72\t\t1\t\t255\t\t255\n' "$game"
  done >> "$temp_dir/.spinners"
  sort -k1,1 "$temp_dir/.spinners" --output="$temp_dir/.spinners"

  for file in table timers clearram; do sudo cp -f "$cafca_dir/$file" "$temp_dir/cafca_$file"; done
  for game in $(sudo find "$roms_dir" -type f -iname '*.zip' | grep -o '[^/]*$' | sed 's/[.].*$//' | sort -k 1,1); do
    [[ $(grep -wc "^${game}" "$temp_dir/cafca_table") -lt 1 ]] && echo "$game " >> "$temp_dir/cafca_table"
    [[ $(grep -wc "^${game}" "$temp_dir/cafca_timers") -lt 1 ]] && echo "$game 1" >> "$temp_dir/cafca_timers"
    [[ $(grep -wc "^${game}" "$temp_dir/cafca_clearram") -lt 1 ]] && echo "$game 0" >> "$temp_dir/cafca_clearram"
  done
  for file in table timers clearram; do cat "$temp_dir/cafca_$file" | sort -k 1,1 | column -t | sudo tee "$temp_dir/cafca_$file" &> /dev/null; done
}

# -------------------------------------------------------------------------------

submit_changes() {
  whiptail --yesno "APPLY CHANGES?" 0 0 2>&1 1>$(tty)
  if [ $? -eq 0 ]; then
    for f in .list .shooters .spinners; do sudo cp -vf "$temp_dir/$f" "$HOMEDIR/ADMIN/MENU/.assets/GAMES/$f"; done
    for f in table timers clearram; do sudo cp -vf "$temp_dir/cafca_$f" "$HOMEDIR/CAFCA/data/mame-libretro/$f"; done
  fi
}

# -------------------------------------------------------------------------------

cleanup() {
  sudo /etc/init.d/transmission-daemon stop; sudo pkill -f "transmission-daemon" #; sudo rm -R "$temp_dir"
  exit 0
}

# -------------------------------------------------------------------------------

trap 'cleanup &>/dev/null' EXIT INT HUP SIGINT SIGHUP TERM

Main
exit 0
