#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

[ "$(id -u)" -ne 1000 ] && { echo -e "please run script as user 'pi'"; exit; }

#echo -e "DIRS:\n$torrent_dir\n$output_dir" # REM !
#exit # REM !

declare -a files=()

torrent_file="$HOMEDIR/ADMIN/FILES/TORRENTS/mame078_romset.torrent"
torrent_dir="$HOMEDIR/downloads/MAME2003_Reference_Set_MAME0.78_ROMs_CHDs_Samples/roms"
output_dir="$DIR/roms"

# --------------------------------------------------------------------------------------

clear; echo "Starting transmission.."
transmission-daemon #--logfile "$DIR/transmission.log"
trap 'sudo service transmission-daemon stop && sudo pkill -f "transmission-daemon" 2>/dev/null; sudo rm "$DIR/torrent.dump" 2>/dev/null; exit' INT SIGINT EXIT

#[[ $(transmission-remote -l | grep -c MAME) -gt 0 ]] && { id=$(transmission-remote -l | grep -m1 'MAME2003_Reference_Set*' | awk '{$1=$1; print $1}'); transmission-remote -t $id -r; sleep 1; }

declare -c id=$(transmission-remote -l | grep MAME | awk '{print $1}')
[[ $id =~ ^[0-9]+$ ]] && { transmission-remote -t $id -r; while [[ $(transmission-remote -t | grep -c 'Verifying') -gt 0 ]]; do :; done; }

transmission-remote -a $torrent_file; transmission-remote -l
id=$(transmission-remote -l | grep -m1 'MAME2003_Reference_Set*' | awk '{$1=$1; print $1}')

transmission-remote -t $id -Gall
transmission-remote -t $id -f | grep -we 'roms' | sed 's/:.*\/roms\// /' | sudo tee "$DIR/torrent.dump" &>/dev/null

sed 's/\([[:digit:]]\) \+\([[:alnum:]]\)/\1_\2/g' "$DIR/torrent.dump" | grep -v '^.*.chd\|^.*.png' | pr -10T -s' ' | column -t | sed 's/_/ /g'; sleep 1
echo -e "\nWrite id(s) to add.\nENTER to start; ESC to exit.\n"

while true; do read -r -N 1 a; case $a in $'\n') echo "DOWNLOADING"; break ;; $'\E') echo "QUIT"; exit ;; *) read -r b; [[ $a$b =~ ^[0-9]+$ ]] && { files+=($((10#$a$b))); } ;; esac; done

file_list=$(IFS=,; echo "${files[*]}")
log=

if [[ ${#files[@]} -gt 0 ]]; then

  #[ -d $torrent_dir ] && sudo rm $torrent_dir/*
  [ -d $output_dir ] && sudo rm $output_dir/*

  transmission-remote -t $id -g$file_list
  transmission-remote -t $id --start

  while true; do
    log="$(transmission-remote -t $id -f | awk '{if ($4 ~ "Yes") print;}')";
    for p in $(echo "$log" | awk '{gsub(/%/,"", $2);print $2}'); do [[ $p -lt 100 ]] && { downloading=1; break; }; done; clear
    echo -e "Downloading:\n"; echo "$log" | awk '{n=split($NF,a,"/"); print $1" "a[n]" "$2}' | column -t; sleep 1;
    [[ $(echo "$log" | grep -c '100%') -eq ${#files[@]} ]] && break
  done
fi

while [[ $(sudo find $torrent_dir/ -type f -iname '*.part' | wc -l) -gt 0 ]]; do sleep 1; done; sleep 2

echo "DONE"

sudo find $torrent_dir -maxdepth 1 -type f -iname '*.zip' -exec cp -vf {} $output_dir \;
sleep 2

exit
