#!/bin/bash

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"


width="$(($(tput cols)+1))"

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; pad=''; str=''; mark="${2:-0}"

  [[ $colors -gt 0 ]] && str="${C}";
  str+="${txt}"; strlen=${#str}

  if [[ $center -gt 0 ]]; then
    [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 ))
    strlen=$(( strlen / 2 )); length=$(( width / 2 )); length=$(( length - strlen ))
    printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"; str="${pad}${str}";
  [[ $colors -gt 0 ]] && str+="${NC}"

  [[ $show_data -eq 1 ]] && { printf "${str}"; for (( i=0; i<"$(( width - ${#str} ))"; i++ )); do printf '\x20'; done; echo '1'; } || echo -e "${str}"

}

show_data=1
colors=1; [[ $colors -eq 1 ]] && width=$(( width + 2 ))
center=1

clear

printer "HELLO"

for (( i=1; i<$(($(tput lines)-4)); i++ )); do echo ""; done
