#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
cafca_dir="$HOMEDIR/CAFCA"
SYSTEM='mame-libretro'

clear
echo ""

for file in table timers clearram; do
  cp -f "$cafca_dir/data/$SYSTEM/$file" "$DIR/$file"

  echo -e "\n${file^^}"

  for game in $(awk -F'\x27' '{print $2}' "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.list"); do
    [[ $(grep -wc "^$game" "$DIR/$file") -eq 0 ]] && echo "$game $([[ $file == timers ]] && echo 1 || { [[ $file == clearram ]] && echo 0; })"
  done | sudo tee -a "$DIR/$file" &>/dev/null

  echo ""
  cat "$DIR/$file" | sort -k 1,1 | column -t | sudo tee "$DIR/$file" #&>/dev/null
done
