#!/bin/bash

HOMEDIR=$(getent passwd pi | cut -d: -f6)
cafca_dir="$HOMEDIR/CAFCA/data"
state_file="$cafca_dir/.states"


update_state() {
  clear

  game_loaded=$(grep "GAME_LOADED" "$state_file" | cut -d= -f2)
  echo -e "\nGAME LOADED: $game_loaded"

  if [[ $game_loaded > 0 ]]; then
    credits=$(grep "COINS_COUNT" "$state_file" | cut -d= -f2)

    if [[ $credits < 1 ]]; then
      sudo sed -i '/COIN_INSERTED/ s/BOOL COIN_INSERTED[=].*$/BOOL COIN_INSERTED=1/' "$state_file"

      #inotifywait -e CLOSE_WRITE,CLOSE_NOWRITE -t 1 "$state_file" && sudo sed -i '/COIN_INSERTED/d' "$state_file" && echo "COIN_INSERTED=1" | sudo tee -a "$state_file"
    fi

    credits=$(( credits + 1 ))
    sudo sed -i '/COINS_COUNT/ s/BYTE COINS_COUNT[=].*$/BYTE COINS_COUNT=$credits/' "$state_file"

    #inotifywait -e CLOSE_WRITE,CLOSE_NOWRITE -t 1 "$state_file" && sudo sed -i '/COINS_COUNT/d' "$state_file" && echo "COINS_COUNT=$credits" | sudo tee -a "$state_file"
  fi

}


function file_ready() {
  if inotifywait -e CLOSE_WRITE,CLOSE_NOWRITE -t 2 "$state_file"; then
    return 0
  else
    return 1
  fi
}

update_state
exit
