#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

temp_dir="$DIR/tmp"
log_file="$DIR/.logfile"
roms_dir="$HOMEDIR/RetroPie/roms/mame-libretro"
assets_path="$HOMEDIR/ADMIN/MENU/.assets"
cafca_dir="$HOMEDIR/CAFCA/data/mame-libretro"
joytyper_dir="$HOMEDIR/ADMIN/.sys/joytyper"
download_dir="$HOMEDIR/downloads/MAME2003_Reference_Set_MAME0.78_ROMs_CHDs_Samples/roms"
torrent_file="$HOMEDIR/ADMIN/FILES/TORRENTS/mame078_romset.torrent"

prompt=$(sed -n '/^editor_prompt=/ {s/\(.*\)=//g;s/#.*$//;p}' "$assets_path/.settings")
preserve_roms=$(sed -n '/^editor_preserve_roms=/ {s/\(.*\)=//g;s/#.*$//;p}' "$assets_path/.settings")

finished=0

#________________________________________________________________________________

# SETUP

export NEWT_COLORS="$(cat $HOMEDIR/ADMIN/MENU/.assets/config/whiptail_theme.cfg)"

shopt -s expand_aliases
alias log_append="sudo tee -a \"$log_file\""
alias log_append_silent="sudo tee -a \"$log_file\" &>/dev/null"

sudo -E -u pi bash -c "dialog --create-rc /home/pi/.dialogrc; cp -f /home/pi/ADMIN/MENU/.assets/config/.dialogrc /home/pi/.dialogrc"
sudo rm $download_dir/*.* 2>/dev/null

[ -d $temp_dir ] && sudo rm -R $temp_dir; mktemp -d --suffix=_TEMP --tmpdir=$DIR &>/dev/null && { mv -f $DIR/tmp*_TEMP $temp_dir; for tmp in $temp_dir; do sudo chmod 775 $temp_dir; sudo chown pi:root $temp_dir; done; }
[[ $TERM == linux ]] && echo -en "\e]P700FC00"

printf '' > "$temp_dir/downloaded"
printf '' > "$log_file"

clear

# -------------------------------------------------------------------------------

# MAIN

Main() {
  clear

  changed="$([ -f $temp_dir/.list ] && echo 1 || echo 0)"

  choice=$( \
    whiptail --menu "MENU" 0 0 0 \
      "APPEND" "" \
      "EDIT" "" \
      "REFRESH" "$([[ $changed -eq 1 ]] && echo ' *')" \
      "REMOVE" "" \
      "APPLY" "$([[ $changed -eq 1 ]] && echo ' *')" \
    2>&1 1>$(tty)) #2>&1 1>&3 3>&2)

  [[ $? -gt 0 ]] && return 1

  case "$choice" in
    APPEND) 	Append 	;;
    EDIT) 	Edit    ;;
    REFRESH) 	Refresh ;;
    REMOVE) 	Remove 	;;
    APPLY) 	Apply 	;;
  esac
  return 0
}

# -------------------------------------------------------------------------------

Edit() {
  declare -A game_data=()
  declare -a entries=()
  declare -a changed=()
  local game=''
  local input_str=''
  local index=0
  local edit_done=0
  local typer_file="$joytyper_dir/IO/output"
  local typer_output=''

  [ ! -f "$temp_dir/.list" ] && cp -f "$assets_path/GAMES/.list" "$temp_dir/.list"

  clear
  echo -e "\nBulding list. Please wait.."

  while read line; do
    entries+=("$line" "")
  done< <( \
    awk -F '\x27' -v path="$cafca_dir" '{
      n=split($4,t,/\ -\ |\(|\//); $4=t[1]; if(length($4)>8){$4=substr($4,1,6);$4=$4".."}gsub(/\ +/," ",$16);gsub(/\[|\]/,"",$16);sub(/^\ /,"",$16);n=split($16,s," ");for(i=0;i<=n;i++)page=page""substr(s[i],1,1);gsub(/^\ +|\ +$/,"",page)
      param="table";    cmd="grep -w  "$2" "path"/"param; cmd | getline str; close(cmd); gsub(/\ +/," ",str); n=split(str,d," "); byte=((length(d[2])>0?"x":"-")); sub(/^0x/,"",byte); key=substr(param,1,3); data[key]=byte
      param="clearram"; cmd="grep -w  "$2" "path"/"param; cmd | getline str; close(cmd); gsub(/\ +/," ",str); n=split(str,d," "); byte=((length(d[2])>0?d[2]:"0")); key=substr(param,1,3); data[key]=byte
      param="timers";   cmd="grep -w  "$2" "path"/"param; cmd | getline str; close(cmd); gsub(/\ +/," ",str); n=split(str,d," "); byte=((length(d[2])>0?d[2]:"0")); key=substr(param,1,3); data[key]=byte
      printf("%-4s %-9s %-8s %-4s %-2s [ %-3s ] %-1s %-1s %-1s %-2s\n",$1,$2,$4,$6,substr($10,1,3),page,data["tab"],$14,data["cle"],data["tim"]); page=""
    }' "$temp_dir/.list"; \
  )
  clear
  data=$(whiptail --menu "$(echo '~# NAME TITLE YEAR TYPE PAGES D M C T' | awk '{printf("%-5s %-9s %-8s %-4s %-2s %-6s %-1s %-1s %-1s %-2s\n",$1,$2,$3,$4,$5,$6,$7,$8,$9,$10)}')" 0 0 0 "${entries[@]}" 2>&1 1>$(tty)); [ $? -gt 0 ] && return $?
  declare -a labels=('' 'index' 'name' '' 'title' '' 'year' '' 'publish' '' 'type' '' 'path' '' 'marquee' '' 'pages' 'timer' 'clear' 'cafca' 'config')

  while read line; do game_data["${labels[${line%% *}]^^}"]="$(echo "$line" | cut -d ' ' -f2-)"; done< <(awk -F '\x27' -v l="${data%% *}" 'NR == l { for (i=2;i<=NF;i+=2) print i" "$i; }' "$temp_dir/.list")
  while read line; do game_data["${line%% *}"]="${line##* }"; done< <(echo "$data" | awk '{print "TIMER "$NF; print "CLEAR "$(NF-1); print "CAFCA "$(NF-3)}')

  while [[ $edit_done -eq 0 ]]; do
    entries=()
    for (( i=2; i<${#labels[@]}; i++ )); do k="${labels[$i]^^}"
      if [[ ${#k} -gt 0 ]]; then val="${game_data[$k]}"
        [[ $k == CAFCA ]] && [[ ${val:0:1} == $'\x78' ]] && val="$(grep -w -m1 ${game_data[NAME]} $cafca_dir/table | awk '{print $2}')"
        [[ $k == PATH ]]  && val="${val//$roms_dir/}"; game_data[$k]="${val:-${game_data[$k]}}"
        [[ $k == PAGES ]] && val=$(echo "$val" | sed 's/\[ *[^[:alnum:]]*//g;s/[^[:alnum:]]*\( *\|\]\)$//;s/ /,/g')
        [[ $k == CONFIG ]]  && val=$(find $roms_dir -type f -iname "${game_data[NAME]}.zip.cfg" -exec false {} +; echo "$?")
        game_data[$k]="$val"
        entry_key="${k} $([[ ${changed[@]} =~ $k ]] && echo '*' || echo ' ')"
        entries+=("$entry_key " "${game_data[$k]}");
      fi
    done

    choice=$(whiptail --menu "MENU" 20 0 0 "${entries[@]}" 2>&1 1>$(tty)); edit_done=$?;

    [[ $edit_done -gt 0 ]] && break

    choice="${choice%% *}"

    case "$choice" in
      'NAME'|'TITLE'|'PUBLISH'|'YEAR'|'PATH')
                bash "$joytyper_dir/joytyper.sh" "${game_data[$choice]}" "EDIT $choice:"
                typer_output="$(cat $typer_file)"

                [[ ${#typer_output} -gt 0 ]] && [[ ! "$typer_output" == "${game_data[$choice]}" ]] && { game_data["$choice"]="$(cat $typer_file)"; changed+=("$choice"); }
                ;;&
      'TYPE')
		entries=()
                for type in JOY GUN SPIN; do [[ $type == ${game_data[TYPE]} ]] && entries+=("$type" "" ON) || entries+=("$type" "" OFF); done
                result=$(whiptail --radiolist "SELECT $choice" 0 0 0 "${entries[@]}" 2>&1 1>$(tty))
                [ $? -eq 0 ] && { game_data["$choice"]="$result"; changed+=("$choice"); }
		;;
      'MARQUEE') ;;
      'PAGES')
                entries=()
		declare -a all_pages=($(IFS=$'\n'; sed -n '/\[ \([^]]*\) \]/ { s/.*\[ \([^]]*\) \].*/\1/; s/ /\n/g;/^$/d; p }' "$temp_dir/.list" | sort -u))
                for page in "${all_pages[@]}"; do [[ $(IFS=,; echo "${game_data[PAGES]}") =~ $page ]] && entries+=("$page" "" ON) || entries+=("$page" "" OFF); done
                result=$(whiptail --checklist "SELECT $choice" 0 0 0 "${entries[@]}" 2>&1 1>$(tty))
                [ $? -eq 0 ] && { game_data["$choice"]=$(echo "$result" | sed 's/\x22//g;s/ /,/g'); changed+=("$choice"); }
		;;
      'TIMER') 	;;
      'CLEAR') 	;;
      'CAFCA') 	;;
      'CONFIG') ;;
    esac
  done

  return 0
}

# -------------------------------------------------------------------------------

Append() {
  dls="$(cat $temp_dir/downloaded | wc -l)"

  clear
  choice=$( \
    whiptail --menu "MENU" 0 0 0 \
      "DOWNLOAD" "" \
      "SCRAPE" "$([[ $dls -gt 0 ]] && echo ' *')" \
      "MARQUEES" "" 2>&1 1>$(tty))

  [ $? -gt 0 ] && return 1

  case "$choice" in
    DOWNLOAD) 	[[ "${global_funcs[@]}" =~ downloader ]] &&  downloader ;;
    SCRAPE) 	[[ "${global_funcs[@]}" =~ scraper ]] 	 &&  scraper;    [ $? -eq 0 ] && return 0 ;;
    MARQUEES) 	[[ "${global_funcs[@]}" =~ marquees ]]   &&  marquees;   [ $? -eq 0 ] && return 0 ;;
  esac

  Append
}

# -------------------------------------------------------------------------------

Refresh() {
  clear
  [ ! -f "$temp_dir/.list" ] && cp -f "$assets_path/GAMES/.list" "$temp_dir/.list"

  # DECODE HTML CHARACHTERS
  sed -i 's/&apos;//' "$temp_dir/.list"
  perl -i -MHTML::Entities -pe 'decode_entities($_);' "$temp_dir/.list"

  # CHECK DUPLICATE LINES
  echo -e "\nDUPLICATE LINES:\n" | log_append_silent
  while read row; do
    sed -i "/${row%% *}/d" "$temp_dir/.list"; echo "$row" | log_append_silent
  done< <(awk -F'\x27' 'seen[$12]++' "$temp_dir/.list")
  awk '{$1=""; print NR$0}' "$temp_dir/.list" | sudo tee "$temp_dir/.list" &>/dev/null

  # CHECK DUPLICATE TITLES
  while read row; do
    local title=$(awk -F'\x27' -v n="$row" 'NR==n { print $4" ("$2")" }' "$temp_dir/.list")
    sed -i "${row}{s/'[^']*'/'${title}'/2}" "$temp_dir/.list"
  done< <(awk -F'\x27' 'seen[$4]++' "$temp_dir/.list" | awk '{print $1}')

  # CHECK FOR MARQUEE AND SET FLAG
  for i in $(seq 1 $(cat "$temp_dir/.list" | wc -l)); do
    name=$(sed -n "${i}p" "$temp_dir/.list" | cut -d\' -f2)
    find "$assets_path/media/marquees" -type f -iname "$name*.ppm" -exec false {} +; found=$?;
    sed -i "${i}{s/'[^']*'/'${found}'/7}" "$temp_dir/.list"
  done

  update_lists
  Apply
}

# -------------------------------------------------------------------------------

Remove() {
  declare -a entries=()

  [ ! -f "$temp_dir/.list" ] && cp -f "$assets_path/GAMES/.list" "$temp_dir/.list"

  while read line; do
    name="${line%%.*}"; entries+=("$name" "$([[ $(grep -c $name $temp_dir/.list) -eq 0 ]] && echo '*')")
  done< <(find $roms_dir -type f -iname '*.zip' -print | grep -o '[^/]*$' | sort)

  game=$(whiptail --menu "$(echo -e "\nSELECT GAME"):" --title "REMOVE" 0 0 0 "${entries[@]}" 2>&1 1>$(tty))

  if [ $? -eq 0 ]; then
    whiptail  --yesno "$(echo -e "\n  REMOVE DATA FOR '$game' ?")" --title "! WARNING !" 0 0 2>&1 1>$(tty)
    if [ $? -eq 0 ]; then
      for file in .list .shooters .spinners; do [ ! -f "$temp_dir/$file" ] && cp -f "$assets_path/GAMES/$file" "$temp_dir/$file"; sed -E -i "/${game}[' ]*/d" "$temp_dir/$file"; done
      for file in .list .shooters .spinners; do [ ! -f "$temp_dir/$file" ] && cp -f "$assets_path/GAMES/$file" "$temp_dir/$file"; sed -E -i "/${game}[' ]*/d" "$temp_dir/$file"; done
      for file in table timers clearram; do [ ! -f "$temp_dir/cafca_$file" ] && cp -f "$cafca_dir/$file" "$temp_dir/cafca_$file"; sed -E -i "/${game}[' ]*/d" "$temp_dir/cafca_$file"; done
      awk '{$1="";print NR""$0}' "$temp_dir/.list" | sudo tee "$temp_dir/.list" &>/dev/null

      [[ $(whiptail  --yesno "$(echo -e "\n  DELETE ROM '$game' ?")" --title "! WARNING !" 0 0 2>&1 1>$(tty); echo $?) -eq 0 ]] && sudo rm -fv "$roms_dir/$game.zip" | log_append
    fi
  fi

  return 0
}

# -------------------------------------------------------------------------------

Apply() {
  whiptail --yesno "APPLY CHANGES?" 0 0 2>&1 1>$(tty)

  if [ $? -eq 0 ]; then clear;
    for f in .list .shooters .spinners; do [ -f "$temp_dir/$f" ] && cp -vf "$temp_dir/$f" "$assets_path/GAMES/$f" | sed "s/.*${DIR##*\/}/'/"; done | log_append
    for f in table timers clearram; do [ -f "$temp_dir/cafca_$f" ] && cp -vf "$temp_dir/cafca_$f" "$cafca_dir/$f" | sed "s/.*${DIR##*\/}/'/"; done | log_append

    sudo rm -f $download_dir/*.* 2>/dev/null;
    find "$temp_dir/" -type f -print -exec rm -f {} \;
    printf '' > "$temp_dir/downloaded"
  fi

  return 0
}

# ___________________________________________________________________________________________________________________

downloader() {
  local items=()
  local log=

  echo "Starting transmission.."

  sudo -u pi bash -c 'transmission-daemon' &>/dev/null; sleep 1

  declare -c id=$(sudo -u pi bash -c 'transmission-remote -l' | grep -A1 '^ID' | tail -n 1 | grep -m1 'MAME' | awk '{print $1}')
  [[ $id =~ ^[0-9]+$ ]] && sudo -u pi id=$id bash -c 'transmission-remote -t $id -r' &>/dev/null

  sudo -u pi file=$torrent_file bash -c 'transmission-remote -a $file; while [[ $(transmission-remote -l | grep -c Verifying) -gt 0 ]]; do :; done' &>/dev/null
  declare -c id=$(sudo -u pi bash -c 'transmission-remote -l' | grep -A1 '^ID' | tail -n 1 | grep -m1 'MAME' | awk '{print $1}')

  sudo -u pi id=$id bash -c 'transmission-remote -t $id -Gall' &>/dev/null
  sudo -u pi id=$id bash -c 'transmission-remote -t $id -f' | grep -we 'roms' | sed 's/:.*\/roms\// /' | sudo tee "$temp_dir/torrent.dump" &>/dev/null

  sed -i '/^.*.chd/d;/^.*.png/d' "$temp_dir/torrent.dump"

  local entries=($(awk '{ print $1"_"$2; }' "$temp_dir/torrent.dump")); for item in "${entries[@]}"; do items+=("${item%%_*}" "${item##*_}" OFF); done
  local indexes=$(whiptail --checklist "SELECT GAME" 0 0 0 "${items[@]}" 2>&1 1>$(tty)); indexes=($(echo "$indexes" | sed 's/\x22//g'))
  local file_list=$(IFS=,; echo "${indexes[*]}")
  local printed=0; local pipe="$log_file"

  if [[ ${#indexes[@]} -gt 0 ]]; then
    [ -d $output_dir ] && sudo rm $output_dir/* 2>/dev/null

    sudo -u pi id=$id list=$file_list bash -c 'transmission-remote -t $id -g$list; transmission-remote -t $id --start' &>/dev/null

    while true; do
      log=$(sudo -u pi id=$id bash -c 'transmission-remote -t $id -f' | awk '{if ($4 ~ "Yes") print;}');
      for p in $(echo "$log" | awk '{gsub(/%/,"", $2);print $2}'); do [[ $p -lt 100 ]] && { downloading=1; break; }; done

      clear; echo -e "Downloading:\n"

      [[ $printed -eq 0 ]] && printed=1 || pipe=/dev/null

      echo "$log" | awk 'NR==FNR{i=split($NF,x,/\/|\./);n=x[i-1];s[n]=$1"\t"$2"\t"n;l[n];next}{for (k in l) if ($2 == k){if(k in f == 0){$1="";$2="";gsub(/\x27/,"",$0);sub(/^\ +/,"",$0);s[k]=s[k]"\t\x27"$0"\x27"}f[k];next}}END{for(k in l)print s[k];}' - "$DIR/assets/mame2003-index" | column -t | awk -F'\x27' 'BEGIN{FS=OFS="\x27"}{gsub(/\ +/, " ",$(NF-1)); print}' | sudo tee -a $pipe 2>&1; sleep 1
      #echo "$log" | awk 'NR==FNR{i=split($NF,x,/\/|\./);n=x[i-1];s[n]=$1"\t"$2"\t"n;l[n];next}{for (k in l) if ($2 == k){if(k in f == 0){$1="";$2="";sub(/^\ +/,"",$0);s[k]=s[k]"\t\x27"$0"\x27"}f[k];next}}END{for(k in l)print s[k];}' - "$DIR/assets/mame2003-index" | column -t | awk -F'\x27' 'BEGIN{FS=OFS="\x27"}{gsub(/\ +/, " ",$(NF-1)); print}' | sudo tee -a $pipe 2>&1; sleep 1

      [[ $(echo "$log" | grep -wc '\s100%' ) -eq ${#indexes[@]} ]] && break
    done
  else
    return 1
  fi

  while [[ $(find $download_dir -type f -iname '*.part' | wc -l) -gt 0 ]]; do sleep 1; done; sleep 3

  find $download_dir -type f -iname '*.zip' ! -iname '*.part' -exec cp -v {} $roms_dir \; | log_append_silent #sudo tee -a "$log_file" &>/dev/null
  for dir in $roms_dir; do sudo chown -R pi:pi $dir; sudo chmod -R 775 $dir; done

  for rom in $(find $download_dir -type f -iname '*.zip' ! -iname '*.part' -print | grep -o '[^/]*$'); do
    [ -f "$roms_dir/$rom" ] && echo "$roms_dir/$rom"
  done | sudo tee "$temp_dir/downloaded" &>/dev/null

  return 0
}

# -------------------------------------------------------------------------------

scraper() {
  local SCRAPER='/opt/retropie/supplementary/skyscraper/Skyscraper'
  local WORKDIR="$temp_dir/scraper"
  local gamelist="$WORKDIR/gamelist.xml"
  local writing=0
  local count=0

  mkdir "$WORKDIR" &>/dev/null; sudo cp "$HOMEDIR/.emulationstation/gamelists/mame-libretro/gamelist.xml" "$WORKDIR/gamelist.xml"

  if [[ $(cat "$temp_dir/downloaded" | wc -l) -lt 1 ]]; then
    whiptail --yesno "SCRAPE ROMS DIR?" --title "NO DOWNLOADS" 0 0 0 2>&1 1>$(tty)
    [ $? -eq 0 ] && find $roms_dir -type f -iname '*.zip' -exec bash -c '[[ ! ${1} =~ ${0} ]] && echo "${0}"' {} "$(awk -F'\x27' '{print $12}' $temp_dir/.list)" \; | sudo tee "$temp_dir/downloaded" &>/dev/null
  fi

  if [[ $(cat "$temp_dir/downloaded" | wc -l) -gt 0 ]]; then

    while read line; do line=$(echo "$line" | sed -E "s/\x1B\[([0-9]{1,2}(;[0-9]{1,2})*)?[m,K,H,f,J]//gm" | sed -E "s/\x1B\([A-Z]{1}(\x1B\[[m,K,H,f,J])?//gm");
      [[ "$line" =~ 'Pass 1' ]] && { writing=1; clear; echo "" | log_append ; } #sudo tee -a "$log_file"; }
      [[ $writing -eq 1 ]] && { (( count++ )); echo "$line" | log_append ; } #sudo tee -a "$log_file"; }
      [[ $count -ge 15 ]] && { writing=0; count=0; }
    done< <( $SCRAPER -p mame-libretro -s screenscraper -i "$roms_dir" -g "$WORKDIR" -a "$HOMEDIR/.skyscraper/artwork.xml" --flags unattendskip --includefrom "$temp_dir/downloaded" ); echo -e "\nWRITING GAMELIST\n"

    $SCRAPER -p mame-libretro -i "$HOMEDIR/RetroPie/roms/mame-libretro" -g "$WORKDIR" -a "$HOMEDIR/.skyscraper/artwork.xml" --flags unattend &>/dev/null

    local game_count=$(grep -Ec '<game>' "$WORKDIR/gamelist.xml")

    for (( n=1; n<=$game_count; n++ )); do
      data=$(awk -v p="<game>" -v n="$n" '$0~p{i++}i==n' "$WORKDIR/gamelist.xml")
      path=$(echo "$data" | grep -E "<path>" | awk '{$1=$1;print}' | sed 's/<path>//g; s/<\/path>//g')
      name=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)

      if [[ $(grep -c "$name" "$temp_dir/downloaded") -gt 0 ]] && [[ ${#data} -gt 0 ]]; then
        title=$(echo "$data" | grep -E "<name>" | awk '{$1=$1;print}' | sed 's/<name>//g; s/<\/name>//g')
        date=$(echo "$data" | grep -E "<releasedate>" | awk '{$1=$1;print}' | sed 's/<releasedate>//g; s/<\/releasedate>//g'); date="${date:0:4}"; [[ ${#date} -lt 1 ]] && date='19xx'
        publisher=$(echo "$data" | grep -E "<publisher>" | awk '{$1=$1;print}' | sed 's/<publisher>//g; s/<\/publisher>//g'); publisher=$(echo "$publisher" | cut -d, -f1); [[ ${#publisher} -lt 1 ]] && publisher='<unknown>'
        type='JOY'
        find "$assets_path/media/marquees" -type f -iname "$name*" -exec false {} +; marquee=$?
        echo "'$name' '$title' '$date' '$publisher' '$type' '$path' '$marquee' '[ ]'"

        [[ $(grep -c "<path>$path</path>" "$WORKDIR/gamelist.xml") -lt 1 ]] && echo "${data}" | sed 's/^/\t/' | sudo tee -a "$WORKDIR/gamelist.xml" &>/dev/null
      fi
    done | sudo tee "$WORKDIR/new_entries" &>/dev/null

    [ ! -f "$temp_dir/.list" ] && cp -f "$assets_path/GAMES/.list" "$temp_dir/.list"

    cat "$WORKDIR/new_entries" | awk '{print "0 "$0}' | sudo tee -a "$temp_dir/.list" &>/dev/null
    cat "$temp_dir/.list" | sort -k4,4 -t \' --output "$temp_dir/.list"; awk '{$1="";print NR""$0}' "$temp_dir/.list" | sudo tee "$temp_dir/.list" &>/dev/null
    printf '' > "$temp_dir/downloaded"

    whiptail  --msgbox "$(echo -e "FINISHED SCRAPING $(cat $WORKDIR/new_entries | wc -l) ROM(S)")" --title "SUCCESS" 0 0 2>&1 1>$(tty)
    return 0
  else
    whiptail  --msgbox "NOTHING TO SCRAPE.." --title "WARNING" 0 0 2>&1 1>$(tty)
    return 1
  fi
}

# ----------------------------------------------------------------------------------------------

update_lists() {
  echo -e "\nUPDATING LISTS..\n"

  # SHOOTERS
  echo -e "SHOOTERS:"
  [ ! -f "$temp_dir/.shooters" ] && sudo cp "$assets_path/GAMES/.shooters" "$temp_dir/.shooters"
  for game in $(awk -F'\x27' '{if (($10 ~ "GUN") || ($16 ~ "GUN")) print $2;}' "$temp_dir/.list"); do
    [[ $(grep -wc "^$game" "$temp_dir/.shooters") -eq 0 ]] && printf '%-8s\t1\n' "$game"
  done | sudo tee -a "$temp_dir/.shooters"
  for game in $(grep -v '^$\|^\s*#' "$temp_dir/.shooters" | awk '{print $1}'); do
    [[ $(grep -c "$game.zip" "$temp_dir/.list") -lt 1 ]] && sed -i "/^${game}\s.*$/d" "$temp_dir/.shooters"
  done
  sort -k1,1 "$temp_dir/.shooters" --output="$temp_dir/.shooters"

  # SPINNERS
  echo -e "SPINNERS:"
  [ ! -f "$temp_dir/.spinners" ] && sudo cp "$assets_path/GAMES/.spinners" "$temp_dir/.spinners"
  for game in $(awk -F'\x27' '{if (($10 ~ "SPIN") || ($16 ~ "SPIN")) print $2;}' "$temp_dir/.list"); do
    [[ $(grep -wc "^$game" "$temp_dir/.spinners") -eq 0 ]] && printf '%-8s\t72\t\t1\t\t255\t\t255\n' "$game"
  done | sudo tee -a "$temp_dir/.spinners"
  for game in $(grep -v '^$\|^\s*#' "$temp_dir/.spinners" | awk '{print $1}'); do
    [[ $(grep -c "$game.zip" "$temp_dir/.list") -lt 1 ]] && sed -i "/^${game}\s.*$/d" "$temp_dir/.spinners"
  done
  sort -k1,1 "$temp_dir/.spinners" --output="$temp_dir/.spinners"

  # CAFCA
  echo -e "\nCAFCA FILES:"
  for file in table timers clearram; do [ ! -f "$temp_dir/cafca_$file" ] && cp -f "$cafca_dir/$file" "$temp_dir/cafca_$file"; echo -e "\n${file^^}:"
    for game in $(awk -F'\x27' '{print $2}' "$temp_dir/.list"); do
      [[ $(grep -wc "^$game" "$temp_dir/cafca_$file") -eq 0 ]] && echo "$game $([[ $file == timers ]] && echo 1 || { [[ $file == clearram ]] && echo 0; })"
    done | sudo tee -a "$temp_dir/cafca_$file" &>/dev/null
    sort -k 1,1 "$temp_dir/cafca_$file" | column -t | sudo tee "$temp_dir/cafca_$file" &>/dev/null
  done

  return 0
}

# -------------------------------------------------------------------------------

edit_type_files() {
  local name="${1}" local action="${2}"

  for f in .list .shooters .spinners; do [ ! -f "$temp_dir/$f" ] && cp -f "$assets_path/GAMES/$f" "$temp_dir/$f"; done

  declare -a pages=($(sed -n '/\[ \([^]]*\) \]/ { s/.*\[ \([^]]*\) \].*/\1/; s/ /\n/g;/^$/d; p }' "$temp_dir/.list" | sort -u))
  declare -a game_pages=($(grep -w -m1 "$name" "$temp_dir/.list" | awk -F'\x27' '{print $(NF-1)}' | sed 's/[][]//g;s/ //'))
  local inputType=$(grep "$name" "$temp_dir/.list" | awk -F'\x27' '{print $10}')

  [[ ${#action} -eq 0 ]] && action=$(whiptail --radiolist "ACTION" 0 0 0 "PAGES" "" ON "INPUT" "" OFF 2>&1 1>$(tty))

  if [[ $? -eq 0 ]] || [[ ${#action} -gt 0 ]]; then
    if [[ $action == PAGES ]]; then items=();
      for p in ${pages[@]}; do [[ "${game_pages[@]}" =~ "$p" ]] && items+=("$p" "" ON) || items+=("$p" "" OFF); done
        filter=$(whiptail --checklist "TOGGLE PAGES" 0 0 0 "${items[@]}" 2>&1 1>$(tty))
        if [ $? -eq 0 ] && [[ ${#filter} -gt 0 ]]; then
          filter=$(echo "$filter" | sed 's/\x22//g')
          #sudo cp "$assets_path/GAMES/.list" "$assets_path/GAMES/.list.bak$(date +%y%m%d%H%M%S)"
          sed -i "/${name}/ s/\[[^]]*\]/[ ${filter} ]/" "$temp_dir/.list"

          declare -a game_pages=($(grep -w -m1 "$name" "$temp_dir/.list" | awk -F'\x27' '{print $(NF-1)}' | sed 's/[][]//g;s/ //'))

          local inputType=$(grep "$name" "$temp_dir/.list" | awk -F'\x27' '{print $10}')
          local inShooters=$(grep -c "^$name" "$temp_dir/.shooters")
          local inSpinners=$(grep -c "^$name" "$temp_dir/.spinners")

          if [[ "${game_pages[@]}" =~ GUN ]] || [[ $inputType == GUN ]]; then
            [[ $inShooters -lt 1 ]] && { printf '%-8s\t1\n' "$name"; sort -k1,1 "$temp_dir/.shooters" --output="$temp_dir/.shooters"; }
          else
            [[ $inShooters -gt 0 ]] && { sudo sed -i "/^${name}/d" "$temp_dir/.shooters"; }
          fi

          if [[ "${game_pages[@]}" =~ SPIN ]] || [[ $inputType == SPIN ]]; then
            [[ $inSpinners -lt 1 ]] && { printf '%-8s\t72\t\t1\t\t255\t\t255\n' "$name"; sort -k1,1 "$temp_dir/.spinners" --output="$temp_dir/.spinners"; }
          else
            [[ $inSpinners -gt 0 ]] && { sudo sed -i "/^${name}/d" "$temp_dir/.spinners"; }
          fi
        fi
    elif [[ $action == INPUT ]]; then items=();
      declare -a types=($(awk -F'\x27' '{print $10}' "$temp_dir/.list" | sort -u))
      for type in ${types[@]}; do [[ "$type" == "$inputType" ]] && items+=("$type" "" ON) || items+=("$type" "" OFF); done

      new_type=$(whiptail --radiolist "SET TYPE" 0 0 0 "${items[@]}" 2>&1 1>$(tty))

      if [ $? -eq 0 ]; then
        sudo sed -i "/${name}/ s/\(\x27${inputType}\x27\)/\x27${new_type}\x27/" "$temp_dir/.list"

        local inShooters=$(grep -c "^$name" "$temp_dir/.shooters")
        local inSpinners=$(grep -c "^$name" "$temp_dir/.spinners")

        if [[ $new_type == GUN ]]; then
          [[ $inShooters -lt 1 ]] && { printf '%-8s\t1\n' "$name"; sort -k1,1 "$temp_dir/.shooters" --output="$temp_dir/.shooters"; }
        else
          [[ $inShooters -gt 0 ]] && { sudo sed -i "/^${name}/d" "$temp_dir/.shooters"; }
          [[ "${game_pages[@]}" =~ GUN ]] && { new_pages=$(echo "${game_pages[@]}" | sed 's/GUN//;s/ //'); sed -i "/${name}/ s/\[[^]]*\]/[ ${new_pages} ]/" "$temp_dir/.list"; }
        fi

        if [[ $new_type == SPIN ]]; then
          [[ $inSpinners -lt 1 ]] && { printf '%-8s\t72\t\t1\t\t255\t\t255\n' "$name"; sort -k1,1 "$temp_dir/.spinners" --output="$temp_dir/.spinners"; }
        else
          [[ $inSpinners -gt 0 ]] && { sudo sed -i "/^${name}/d" "$temp_dir/.spinners"; }
          [[ "${game_pages[@]}" =~ SPIN ]] && { new_pages=$(echo "${game_pages[@]}" | sed 's/SPIN//;s/ //'); sed -i "/${name}/ s/\[[^]]*\]/[ ${new_pages} ]/" "$temp_dir/.list"; }
        fi
      fi
    fi
  fi
  Edit "$name"
  return 0
}

# --------------------------------------------------------------------------------------

marquees() {
  echo "MARQUEES"; sleep 1
  return 1
}

# ----------------------------------------------------------------------------------------------

declare -a global_funcs=()
while IFS=, read -ra globals; do for g in "${globals[@]}"; do [[ "$g" =~ ^'f '.* ]] && global_funcs+=("${g##* }"); done; done< <({ declare -p; declare -F; } | grep '^declare' | grep -Ev '\s[A-Z_]+' | sed 's/[=].*$//; s/^declare\s-//g; s/^ //; s/$/,/')

cleanup() { sudo /etc/init.d/transmission-daemon stop; sudo pkill -f "transmission-daemon"; printf '' > "$temp_dir/downloaded"; exit 0; }; trap 'cleanup &>/dev/null' EXIT INT HUP SIGINT SIGHUP TERM

exit_code=0

#Main; exit_code=$?; clear; echo "EXIT STATUS: $exit_code"
while [[ $exit_code -eq 0 ]]; do Main; exit_code=$?; done

#Main


if [[ $(cat "$temp_dir/downloaded" | wc -l) -gt 0 ]] && [[ ! -f "$temp_dir/.list" ]]; then
  whiptail --yesno "$(cat tmp/downloaded | grep -o '[^/]*$')\n" --title "DELETE ROMS?" 0 0 0 2>&1 1>$(tty)
  [ $? -eq 0 ] && { clear; for rom in $(cat "$temp_dir/downloaded"); do sudo rm -vf "$rom"; done | log_append ; } #| sudo tee "$log_file"; }
fi

exit 0

# ----------------------------------------------------------------------------------------------------------------------------------------------


Edit_old2() {
  declare -a entries=()
  local game=''
  local index=0

  [ ! -f "$temp_dir/.list" ] && cp -f "$assets_path/GAMES/.list" "$temp_dir/.list"
  [[ $# -gt 0 ]] && [[ $(grep -wc "$@" "$temp_dir/.list") -gt 0 ]] && game="$@"

  clear

  if [[ ${#game} -lt 1 ]]; then
    while read line; do
      entries+=("$line" "")
    done< <( \
      awk -F '\x27' -v path="$cafca_dir" '{
        n=split($4,t,/\ -\ |\(|\//); $4=t[1]; if(length($4)>8){$4=substr($4,1,6);$4=$4".."}gsub(/\ +/," ",$16);gsub(/\[|\]/,"",$16);sub(/^\ /,"",$16);n=split($16,s," ");for(i=0;i<=n;i++)page=page""substr(s[i],1,1);gsub(/^\ +|\ +$/,"",page)
        param="table";    cmd="grep -w  "$2" "path"/"param; cmd | getline str; close(cmd); gsub(/\ +/," ",str); n=split(str,d," "); byte=((length(d[2])>0?"x":"-")); sub(/^0x/,"",byte); key=substr(param,1,3); data[key]=byte
        param="clearram"; cmd="grep -w  "$2" "path"/"param; cmd | getline str; close(cmd); gsub(/\ +/," ",str); n=split(str,d," "); byte=((length(d[2])>0?d[2]:"0")); key=substr(param,1,3); data[key]=byte
        param="timers";   cmd="grep -w  "$2" "path"/"param; cmd | getline str; close(cmd); gsub(/\ +/," ",str); n=split(str,d," "); byte=((length(d[2])>0?d[2]:"0")); key=substr(param,1,3); data[key]=byte
        printf("%-4s %-9s %-8s %-4s %-1s [ %-3s ] %-1s %-1s %-1s %-2s\n",$1,$2,$4,$6,substr($10,1,3),page,data["tab"],$14,data["cle"],data["tim"]); page=""
      }' "$temp_dir/.list"; \
    )

    data=$(whiptail --menu "$(echo '~# NAME TITLE YEAR INP PAGES D M C T' | awk '{printf("%-5s %-9s %-8s %-4s %-1s  %-6s %-1s %-1s %-1s %-2s\n",$1,$2,$3,$4,$5,$6,$7,$8,$9,$10)}')" 0 0 0 "${entries[@]}" 2>&1 1>$(tty))

    [ $? -gt 0 ] && return

    index=$(echo "$data" | awk '{print $1}')
    data=$(sed -n "${index}p" "$temp_dir/.list")
    game=$(echo "$data" | awk -F'\x27' '{print $2}')

  else
    data=$(sed "/${game}[']/q;d" "$temp_dir/.list")
    index="${data%% *}"
  fi

  game=$(echo "$data" | awk -F'\x27' '{print $2}')
  choice=$( \
    whiptail --title "EDIT" --menu "$(echo -e "\nGAME: $game")" 0 0 0 \
      "MENU ENTRY" "" \
      "TYPE FILES" "" \
      "CAFCA FILES" "" \
    2>&1 1>$(tty) \
  )

  if [ $? -eq 0 ]; then
    case "$choice" in
      'MENU ENTRY')
        choice=$( whiptail --title "EDIT: $choice" --menu "$(echo -e "\nGAME: $game")" 0 0 0 "PAGES" "" "INPUT" "" "TITLE" "" 2>&1 1>$(tty) )
        [[ $? -eq 0 ]] && edit_type_files "$game" "$choice"
        ;;
      'TYPE FILES')
        choice=$( whiptail --title "EDIT: $choice" --menu "$(echo -e "\nGAME: $game")" 0 0 0 "SHOOTERS" "$([[ $(grep -wc $game $assets_path/GAMES/.shooters) -gt 0 ]] && echo ' *')" "SPINNERS" "$([[ $(grep -wc $game $assets_path/GAMES/.spinners) -gt 0 ]] && echo ' *')" 2>&1 1>$(tty) )
        ;;
      'CAFCA FILES')
        choice=$( whiptail --title "EDIT: $choice" --menu "$(echo -e "\nGAME: $game")" 0 0 0 "TABLE" "" "TIMERS" "" "RAMCLEAR" "" 2>&1 1>$(tty) )
        ;;
    esac
  fi

  Main
}

# -------------------------------------------------------------------------------

Edit_old() {
  declare -a entries=()
  local game=''
  local index=0

  [ ! -f "$temp_dir/.list" ] && cp -f "$assets_path/GAMES/.list" "$temp_dir/.list"
  [[ $# -gt 0 ]] && [[ $(grep -wc "$@" "$temp_dir/.list") -gt 0 ]] && game="$@"

  clear

  if [[ ${#game} -lt 1 ]]; then
    while read line; do
      entries+=("$line" "")
    done< <( \
      awk -F '\x27' -v path="$cafca_dir" '{
        n=split($4,t,/\ -\ |\(|\//); $4=t[1]; if(length($4)>8){$4=substr($4,1,6);$4=$4".."}gsub(/\ +/," ",$16);gsub(/\[|\]/,"",$16);sub(/^\ /,"",$16);n=split($16,s," ");for(i=0;i<=n;i++)page=page""substr(s[i],1,1);gsub(/^\ +|\ +$/,"",page)
        param="table";    cmd="grep -w  "$2" "path"/"param; cmd | getline str; close(cmd); gsub(/\ +/," ",str); n=split(str,d," "); byte=((length(d[2])>0?"x":"-")); sub(/^0x/,"",byte); key=substr(param,1,3); data[key]=byte
        param="clearram"; cmd="grep -w  "$2" "path"/"param; cmd | getline str; close(cmd); gsub(/\ +/," ",str); n=split(str,d," "); byte=((length(d[2])>0?d[2]:"0")); key=substr(param,1,3); data[key]=byte
        param="timers";   cmd="grep -w  "$2" "path"/"param; cmd | getline str; close(cmd); gsub(/\ +/," ",str); n=split(str,d," "); byte=((length(d[2])>0?d[2]:"0")); key=substr(param,1,3); data[key]=byte
        printf("%-4s %-9s %-8s %-4s %-1s [ %-3s ] %-1s %-1s %-1s %-2s\n",$1,$2,$4,$6,substr($10,1,3),page,data["tab"],$14,data["cle"],data["tim"]); page=""
      }' "$temp_dir/.list"; \
    )

    data=$(whiptail --menu "$(echo '~# NAME TITLE YEAR INP PAGES D M C T' | awk '{printf("%-5s %-9s %-8s %-4s %-1s  %-6s %-1s %-1s %-1s %-2s\n",$1,$2,$3,$4,$5,$6,$7,$8,$9,$10)}')" 0 0 0 "${entries[@]}" 2>&1 1>$(tty))

    [ $? -gt 0 ] && return 1

    index=$(echo "$data" | awk '{print $1}')
    data=$(sed -n "${index}p" "$temp_dir/.list")
    game=$(echo "$data" | awk -F'\x27' '{print $2}')

  else
    data=$(sed "/${game}[']/q;d" "$temp_dir/.list")
    index="${data%% *}"
  fi

  game=$(echo "$data" | awk -F'\x27' '{print $2}')
  choice=$( \
    whiptail --title "EDIT" --menu "$(echo -e "\nGAME: $game")" 0 0 0 \
      "MENU ENTRY" "" \
      "TYPE FILES" "" \
      "CAFCA FILES" "" \
    2>&1 1>$(tty) \
  )

  if [ $? -eq 0 ]; then
    case "$choice" in
      'MENU ENTRY')
        choice=$( whiptail --title "EDIT: $choice" --menu "$(echo -e "\nGAME: $game")" 0 0 0 "PAGES" "" "INPUT" "" "TITLE" "" 2>&1 1>$(tty) )
        #[ $? -gt 0 ] && Edit "$game"
        ;;
      'TYPE FILES')
        choice=$( whiptail --title "EDIT: $choice" --menu "$(echo -e "\nGAME: $game")" 0 0 0 "SHOOTERS" "$([[ $(grep -wc $game $assets_path/GAMES/.shooters) -gt 0 ]] && echo ' *')" "SPINNERS" "$([[ $(grep -wc $game $assets_path/GAMES/.spinners) -gt 0 ]] && echo ' *')" 2>&1 1>$(tty) )
        #[ $? -gt 0 ] && Edit "$game"
        ;;
      'CAFCA FILES')
        choice=$( whiptail --title "EDIT: $choice" --menu "$(echo -e "\nGAME: $game")" 0 0 0 "PAGES" "" "INPUT" "" "TITLE" "" 2>&1 1>$(tty) )
        #[ $? -gt 0 ] && Edit "$game"
        ;;
    esac
  fi

  Main
}



Remove_old() {
  local entries=()

  for g in $(awk -F'\x27' '{print $2}' "$assets_path/GAMES/.list" | sort -k2,2 -t \'); do entries+=("$g" ""); done
  game=$(whiptail --menu "$(echo -e "\nSELECT GAME"):" --title "REMOVE" 0 0 0 "${entries[@]}" 2>&1 1>$(tty))

  [ $? -eq 0 ] && whiptail  --yesno "$(echo -e "\n  REMOVE GAME '$game' ?")" --title "! WARNING !" 0 0 2>&1 1>$(tty) || Main

  if [ $? -eq 0 ]; then
    for file in .list .shooters .spinners; do [ ! -f "$temp_dir/$file" ] && cp -f "$assets_path/GAMES/$file" "$temp_dir/$file"; sed -E -i "/${game}[' ]*/d" "$temp_dir/$file"; done
    for file in table timers clearram; do [ ! -f "$temp_dir/cafca_$file" ] && cp -f "$cafca_dir/$file" "$temp_dir/cafca_$file"; sed -E -i "/${game}[' ]*/d" "$temp_dir/cafca_$file"; done
    awk '{$1="";print NR""$0}' "$temp_dir/.list" | sudo tee "$temp_dir/.list" &>/dev/null
    whiptail  --msgbox "$(echo -e "\n  GAME '${game}' WAS REMOVED.")" --title "SUCCESS" 0 0 2>&1 1>$(tty)

    #[[ ! $preserve_roms -eq 1 ]] && [[ $(whiptail  --yesno "$(echo -e "\n  DELETE ROM '$game' ?")" --title "! WARNING !" 0 0 2>&1 1>$(tty); echo $?) -eq 0 ]] && sudo rm -f "$roms_dir/$game.zip"
  fi

  Main
}
