#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets="$HOMEDIR/ADMIN/MENU/.assets"

entries=(); choices=(); count=0

long_title=$(cat "$assets/GAMES/.list" | awk -F '\x27' '{print length($4)" "$4}' | sort -k1 -n | tail -n 1 | awk '{print $1}')

printf -v header 'TITLE %*s M D' "$long_title"

clear
echo -e "$header\n"
#exit

printf '%*s' "$(( $(tput cols)-(${#name}+${#str}) ))"
for i in $(seq 1 $(( $(tput lines)-4 )) ); do
  line=$(sed "${i}q;d"  "$assets/GAMES/.list")
  name=$(echo $line | awk -F'\x27' '{print "\x20\x20",$2," "}')
  str=$(echo $line | awk -F'\x27' '{gsub(/\[\ /, "", $(NF-1));print "[ ALL",$(NF-1)," "}')

  echo -n "$name"
  printf '%*s' "$(( $(tput cols)-(${#name}+${#str}) ))"
  echo "${str}"

  #entries+=("$(echo -n $name; printf '%*s' $(( $(tput cols) - ( ${#name} + ${#str} ) )); echo ${str})")
done

