#!/bin/bash

dump() {
  local dev='equal'
  local n_bands=10
  local band=
  local amplitude=

  declare -A bands=()
  declare -a names=()

  while true; do clear
  for i in $(seq 1 $n_bands); do
    lines=$(amixer -D $dev contents | grep -A3 "numid=$i,")
    name=$(echo "$lines" | head -n 1 | cut -d. -f2 | awk '{$1=$1; sub(/Hz/,"",$2); sub(/k/,"000",$2); print $1$2}')
    val=$(echo "$lines" | grep ': values=' | awk -F'=|,' '{print $2}')
    names[$i]="$name"
    bands+=(["$name"]="$val")
  done

  for i in $(seq 1 $n_bands); do echo -e "$(printf '%-2d' $i) :  ${names[$i]}\t${bands[${names[$i]}]}"; done

  echo -e "\nSet band? (y/n)"; read -srn1 confirm; [[ ! $confirm == [yY] ]] && exit

  band=; amplitude=

  while [ -z $band ]; do
    echo -ne "\nchoose band (1-$n_bands): "; read index

    if [[ $index =~ ^[0-9]+$ ]] && [[ $index -ge 1 ]] && [[ $index -le 10 ]]; then band=$index
      while [ -z $amplitude ]; do
        echo -ne "\nchoose amplitude ( $(amixer -D $dev scontents | grep -m1 'Limits' | sed 's/ Playback//;s/^ *//') ) : "; read val
        [[ $val =~ ^[0-9]+$ ]] && [[ $val -ge 0 ]] && [[ $val -le 100 ]] && amplitude=$val
      done
    fi
  done

  #echo -e "\nBAND: $band ( ${names[$band]}Hz ); AMP:  $amplitude"
  amixer --quiet -D $dev cset numid=$band $amplitude; echo
  done
}

export -f dump
su pi -c "bash -c dump"
exit 0
