#!/bin/bash

file='/home/pi/game.cfg'

cp -f "$file.bak" "$file"

declare -a entries=()
declare -a lines_changed=()
editing_file=1

while [[ $editing_file -eq 1 ]]; do entries=()
  while read line; do key=${line%% *}; [[ ${lines_changed[@]} =~ $key ]] && key="$key*"; entries+=("$key" "${line:2}"); done< <(awk '{print NR" "$0}' $file)
  choice=$(whiptail --menu "MENU" 0 0 0 "${entries[@]}" 2>&1 1>$(tty))
  if [ $? -eq 0 ]; then
    index=${choice%% *}; str=$(sed -n "${index}p" $file)
    sed -i "${index}s/^.*$/${str}_copy/" $file
    lines_changed+=("$index")
  else
    editing_file=0
  fi
done


exit

while [[ $editing_file -eq 1 ]]; do entries=()
  while read line; do [[ ${#line} -gt 0 ]] && [[ "${lines_changed[@]}" =~ "$line" ]] && mark='*' || mark=''; entries+=("$line" " $mark"); done< <(cat $file)
  entries+=("< ADD LINE >" "")
  choice=$(whiptail --menu "$file" 0 0 0 "${entries[@]}" 2>&1 1>$(tty)); [ $? -eq 0 ] && lines_changed+=("$choice") || editing_file=0
done

exit

while [[ $editing_file -eq 1 ]]; do entries=()
  while read line; do
    index=${line%% *}
  entries+=("$([[ ${lines_changed[@]} =~ $index ]] && echo '*' || echo ' ')" "${line:2}"); done< <(awk '{print NR" "$0}' $file)
  choice=$(whiptail --menu "MENU" 0 0 0 "${entries[@]}" 2>&1 1>$(tty))
  [ $? -eq 0 ] && lines_changed+=("$index") || editing_file=0
done


exit

cat $file | awk '{print NR" "$0}'

while [[ $editing_file -eq 1 ]]; do entries=() #${line%% *}
  while read line; do entries+=("${line%% *}" " "); done< <(cat $file | awk '{print NR" "$0}')
  #for i in $(seq 1 $(cat $file | wc -l)); do entries+=("$(sed -n "${i}p" $file)" "$i"); done
  whiptail --menu "MENU" 0 0 0 ${entries[@]} 2>&1 1>$(tty)
  break
done
