#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

MENU_DIR="$HOMEDIR/ADMIN/MENU/.assets"
DATA_DIR="$DIR/assets/marquee"
IMG_DIR=$(grep -w -m1 'dir_marquees=' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
IMG_ZIP=$(find "$IMG_DIR" -type f -iname '*.zip' -print -quit)

WIDTH=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f1)
gamelist="$DATA_DIR/.list"

# -------------------------------------------------------------------------------------------

export NEWT_COLORS="$(cat $HOMEDIR/ADMIN/MENU/.assets/config/whiptail_theme.cfg)"

declare -a existing=()

# WIPE DIRECTORIES:
sudo rm -R "$IMG_DIR/Marquees" 2>/dev/null
sudo rm -R "$IMG_DIR/SCALED" 2>/dev/null
mkdir "$IMG_DIR/SCALED" 2>/dev/null
mkdir "$IMG_DIR/SCALED/PPM" 2>/dev/null

# CREATE LIST OF IMAGES IN ARCHIVE:
7z l "$IMG_ZIP" | awk '{$1=$1;print}' | cut -d' ' -f6- | grep '^Marquees' | cut -d/ -f2 | sort > "$IMG_DIR/Marquees.list"

# COPY GAME LIST TO LOCAL FOLDER
cat "$MENU_DIR/GAMES/.list" | awk -F'\x27' '{print $2}' | sudo tee "$gamelist" &>/dev/null && sudo chown pi:root "$gamelist"; sudo chmod 775 "$gamelist"

# -------------------------------------------------------------------------------------------

Main() {
  declare -a items=(); count=0

  clear

  for game in $(cat "$gamelist" | sort); do (( count++ ));
    has_img=$(find "$MENU_DIR/media/marquees" -type f -iname "$game*.ppm"  -exec false {} +; echo $?)
    [[ $has_img -eq 1 ]] && existing+=("$game")
    items+=("$game" "" $([[ $has_img -eq 1 ]] && echo ON || echo OFF))
  done

  selections=$(whiptail --checklist "SELECT GAMES" 0 0 0 "${items[@]}" 2>&1 1>$(tty))

  if [ $? -eq 0 ]; then
    entries=($(echo "$selections" | sed 's/\x22//g'))

    for entry in "${entries[@]}"; do [[ ! "${existing[@]}" =~ "$entry" ]] && echo "$entry"; done
    for entry in "${entries[@]}"; do [[ ! "${existing[@]}" =~ "$entry" ]] && convertImage "$entry"; done; sleep 1
    drawFB; sleep 1
    echo "DONE"
  fi
  #sudo rm -R "$IMG_DIR/Marquees"
}

# -------------------------------------------------------------------------------------------

drawFB() {
  echo -e "\n$IMG_DIR/SCALED:\n"

  for f in $IMG_DIR/SCALED/*.*; do f=${f##*/}; echo "  $f"; done; sleep 1
  for f in $IMG_DIR/SCALED/*.*; do f=${f##*/};
    if [ ! -f "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm" ]; then
      sudo fbi -T 2 -d /dev/fb0 --once --noverbose "$IMG_DIR/SCALED/$f" >/dev/null 2>&1; sleep 1
      cat /dev/fb0 > "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm"
      while [[ $(pgrep -c fbi) -gt 0 ]]; do :; done
      sudo cp -f "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm" "$MENU_DIR/media/marquees/${f%%.*}.ppm"
    fi
  done
  sudo chown pi:root "$IMG_DIR/SCALED/PPM"; sudo chmod -R 775 "$IMG_DIR/SCALED/PPM"
  sudo chown -R pi:root "$MENU_DIR/media/marquees"; sudo chmod -R 775 "$MENU_DIR/media/marquees"
}

# -------------------------------------------------------------------------------------------

convertImage() {
  local name="${1}"
  local file=''

  if [[ $(grep -wc "^$name" "$IMG_DIR/Marquees.list") -gt 0 ]]; then
    #echo -e "Converting $name..."
    unzip -o -d "$IMG_DIR" "$IMG_ZIP" "Marquees/$name*" &> /dev/null

    [[ $(ls "$IMG_DIR/Marquees" | grep -wc "$name.jpg") -gt 0 ]] && [[ ${#file} -lt 1 ]] && file="$IMG_DIR/Marquees/$name.jpg"
    [[ $(ls "$IMG_DIR/Marquees" | grep -wc "$name.png") -gt 0 ]] && [[ ${#file} -lt 1 ]] && file="$IMG_DIR/Marquees/$name.png"
    [[ $(ls "$IMG_DIR/Marquees" | grep -Ec "${name}[\ ].jpg") -gt 0 ]] && [[ ${#file} -lt 1 ]] && file="$IMG_DIR/Marquees/$(ls "$IMG_DIR/Marquees" | grep -E -m1 "${name}[\ ].jpg")"
    [[ $(ls "$IMG_DIR/Marquees" | grep -Ec "${name}[\ ] *") -gt 0 ]] && [[ ${#file} -lt 1 ]] && file="$IMG_DIR/Marquees/$(ls "$IMG_DIR/Marquees" | grep -E -m1 "${name}[\ ] *")"

    #for file in "$IMG_DIR/Marquees/${name}*"; do [[ "${file}" == ${name}.@(jpg|jpeg) ]] && { break; } || { [[ "${file##*.}" == @(jpg|jpeg) ]] && break; }; done
    #for f in "$IMG_DIR/Marquees/${name}*"; do file=$f; [[ ${f##*.} == @(jpg|jpeg) ]] && break; done; echo "$name"
    #[[ ! -z $(find "$IMG_DIR/Marquees" -type f -iname "${name}.jpg") ]] && file="$IMG_DIR/Marquees/${name}.jpg" || file="$IMG_DIR/Marquees/${name}.png"

    if [[ ${#file} -gt 0 ]]; then
      filename="${file##*/}"; ext="${filename##*.}"

      [[ $ext == png ]] && sudo gm convert -resize ${WIDTH}x +profile "*" "${file}" "${file}.converted" &>/dev/null \
      || sudo gm convert -resize ${WIDTH}x "${file}" "${file}.converted" &>/dev/null

      height=$(file "${file}.converted" | sed 's/ //g' | grep -oe '\([0-9.]*\)x\([0-9.]*\)' | grep -E '[0-9]{3}' | tail -n 1 | cut -dx -f2)
      outfile="$IMG_DIR/SCALED/${name}_$height.${ext,,}"

      [ -f "${file}.converted" ] && mv "${file}.converted" "$outfile"
      echo -e "${file##*/} -> ${outfile##*/}"
      #echo -e "input: $file\noutput: $outfile\n"
    fi
  #else
  #  echo -e "No data found for '$name'.."
  fi
}

# -------------------------------------------------------------------------------------------


convertImage_old() {
  local name="${1}"
  local file=''

  if [[ $(grep -wc "^$name" "$IMG_DIR/Marquees.list") -gt 0 ]]; then
    unzip -o -d "$IMG_DIR" "$IMG_ZIP" "Marquees/$name*" &> /dev/null

    [[ $(ls "$IMG_DIR/Marquees" | grep -wc "$name.jpg") -gt 0 ]] && [[ ${#file} -lt 1 ]] && file="$IMG_DIR/Marquees/$name.jpg"
    [[ $(ls "$IMG_DIR/Marquees" | grep -wc "$name.png") -gt 0 ]] && [[ ${#file} -lt 1 ]] && file="$IMG_DIR/Marquees/$name.png"
    [[ $(ls "$IMG_DIR/Marquees" | grep -Ec "${name}[\ ].jpg") -gt 0 ]] && [[ ${#file} -lt 1 ]] && file="$IMG_DIR/Marquees/$(ls "$IMG_DIR/Marquees" | grep -E -m1 "${name}[\ ].jpg")"
    [[ $(ls "$IMG_DIR/Marquees" | grep -Ec "${name}[\ ] *") -gt 0 ]] && [[ ${#file} -lt 1 ]] && file="$IMG_DIR/Marquees/$(ls "$IMG_DIR/Marquees" | grep -E -m1 "${name}[\ ] *")"

    #for file in "$IMG_DIR/Marquees/${name}*"; do [[ "${file}" == ${name}.@(jpg|jpeg) ]] && { break; } || { [[ "${file##*.}" == @(jpg|jpeg) ]] && break; }; done
    #for f in "$IMG_DIR/Marquees/${name}*"; do file=$f; [[ ${f##*.} == @(jpg|jpeg) ]] && break; done; echo "$name"
    #[[ ! -z $(find "$IMG_DIR/Marquees" -type f -iname "${name}.jpg") ]] && file="$IMG_DIR/Marquees/${name}.jpg" || file="$IMG_DIR/Marquees/${name}.png"

    if [[ ${#file} -gt 0 ]]; then
      filename="${file##*/}"; ext="${filename##*.}"

      [[ $ext == png ]] && sudo gm convert -resize ${WIDTH}x +profile "*" "${file}" "${file}.converted" &>/dev/null \
      || sudo gm convert -resize ${WIDTH}x "${file}" "${file}.converted" &>/dev/null

      height=$(file "${file}.converted" | sed 's/ //g' | grep -oe '\([0-9.]*\)x\([0-9.]*\)' | grep -E '[0-9]{3}' | tail -n 1 | cut -dx -f2)
      outfile="$IMG_DIR/SCALED/${name}_$height.${ext,,}"

      [ -f "${file}.converted" ] && mv "${file}.converted" "$outfile"
      echo -e "input: $file\noutput: $outfile\n"
    fi
  fi
}

# -------------------------------------------------------------------------------------------

Main
exit

# WIPE DIRECTORIES:
sudo rm -R "$IMG_DIR/Marquees"
sudo rm -R "$IMG_DIR/SCALED"
mkdir "$IMG_DIR/SCALED"
mkdir "$IMG_DIR/SCALED/PPM"

# CREATE LIST OF IMAGES IN ARCHIVE:
7z l "$IMG_ZIP" | awk '{$1=$1;print}' | cut -d' ' -f6- | grep '^Marquees' | cut -d/ -f2 | sort > "$IMG_DIR/Marquees.list"

# EXTRACT IMAGE FROM ARCHIVE AND RESIZE
while read entry; do
  convertImage "$entry"
done< <(cat "$gamelist")

clear

# GRAB FRAMEBUFFER OF DISPLAYED IMAGES:
for f in $IMG_DIR/SCALED/*.*; do f=${f##*/};
  if [ ! -f "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm" ]; then
    sudo fbi -T 2 -d /dev/fb0 --once --noverbose "$IMG_DIR/SCALED/$f"; sleep 1
    cat /dev/fb0 > "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm"
    while [[ $(pgrep -c fbi) -gt 0 ]]; do :; done
    sudo cp -f "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm" "$DATA_DIR/media/marquees/${f%%.*}.ppm"
    #sudo mv "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm" "$DATA_DIR/media/marquees/${f%%.*}.ppm"
  fi
done

#sudo rm -R "$IMG_DIR/Marquees"

# SET ACCESS RIGHTS FOR MENU SCRIPT:
sudo chown pi:root "$IMG_DIR/SCALED/PPM"
sudo chmod -R 775 "$IMG_DIR/SCALED/PPM"

exit










# ____________________________________________________________________________________________


makePPMfiles() {
  local SCALED_PATH="$IMG_DIR/SCALED"

  for f in $IMG_DIR/SCALED/*.*; do
    f=${f##*/}
    if [ ! -f "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm" ]; then
      sudo fbi -T 2 -d /dev/fb0 --once --noverbose "$IMG_DIR/SCALED/$f"; sleep 1
      cat /dev/fb0 > "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm"
      while [[ $(pgrep -c fbi) -gt 0 ]]; do :; done
      sudo cp "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm" "$DATA_DIR/media/marquees_test/${f%%.*}.ppm"
      #sudo mv "$IMG_DIR/SCALED/PPM/${f%%.*}.ppm" "$DATA_DIR/media/marquees_test/${f%%.*}.ppm"
    fi
  done
}
