#!/bin/bash

setup() {
  verbose=0
  HOMEDIR=$(getent passwd pi | cut -d: -f6)
  SCRIPT=$(readlink -f "$0")
  DIR=$(cd "$(dirname $SCRIPT)" && pwd)

  [ $verbose -gt 0 ] && echo -e "HOMEDIR:$HOMEDIR\nDIR:\t$DIR\nSCRIPT:\t$SCRIPT\n"

  trap_cmds=($(trap -l | awk 'BEGIN{RS=")"}{$1=$1}1' | awk -F' ' '{print $1}' | tail -n +2))
  trap_cmds[130]='EXIT'

  trap 'cleanKill $?' EXIT INT SIGINT
  [ "$(id -u)" -ne 0 ] && { echo "please run script as root."; sleep 1; exit 1; } || { echo "running script as root"; }

}

cleanKill() {
  echo -e "\ncleanKill: $1 \x27${trap_cmds[$1]}\x27"
  #echo -e "\ncleanKill\n\tcode: $1\n\tsig : ${trap_cmds[$1]}"
  exit 0
}


setup

include_file='./DUMP.sh'
[ -f $include_file ] && { source $include_file; include; }
[ "$INCLUDED" ] && echo "succes!" || echo "failure" && exit 1

