#!/bin/bash

HOMEDIR=$(getent passwd pi | cut -d: -f6)
SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)

# ----------------------------------------------------------------

cleanKill() {
  trap_cmds=($(trap -l | awk '{print $0"\t"}' | awk 'BEGIN{RS="\t"}{$1=$1}1' | grep -o '[^ ]*$')); trap_cmds[130]='EXIT'; #echo "${trap_cmds[$1]}"
  exit 0;
}

trap 'cleanKill $?' EXIT INT SIGINT

# ----------------------------------------------------------------
# SET VARS:

names=('' 'action' 'target' 'second' 'param'); name=''
for (( i=1; i<=$#; i++ )); do var="$(eval echo \${$i#--})"; declare "${names[$i]}"="${var,,}"; done

while read line; do
  n=$(echo "$line" | cut -d= -f1); p=$(echo "$line" | cut -d\' -f2); declare "${n}"="${p}"
  [[ $(echo ${p,,} | grep -wc $target) -gt 0 ]] && name="$n"
done< <(cat "$HOMEDIR/ADMIN/.sys/.settings" | cut -d' ' -f2- | grep -Ew '^teensy|^joystick|^gun|^spinner|^udev')

if [[ $action == @(add|remove|grab) ]]; then
  [[ $action == grab ]] && { action='add'; grab=1; }
  [[ "$target" == @(teensy|joystick|gun|spinner|udev) ]] && { name="$target" ; target=$(eval echo \${$target}); }
  ! ( [[ $second == tag ]] && [[ ${#param} -gt 0 ]] ) && { second='tag'; param="$name"; }
fi

# ----------------------------------------------------------------
# TH-CMD:

cmd='sudo th-cmd --socket /run/thd.socket '

[[ $grab -gt 0 ]] && cmd+="--grab "
[[ ${#action} -gt 0 ]] && [[ ${#target} -gt 0 ]] && cmd+="--$action $target "
[[ ${#second} -gt 0 ]] && [[ ${#param} -gt 0 ]]  && cmd+="--$second $param "

if [[ $action == add ]] && [[ $(grep -c "$name" "$DIR/devices.log") -gt 0 ]]; then
  sudo bash -c "sudo th-cmd --socket /run/thd.socket --remove $target"
  line="`date '+%F %T'` : sudo th-cmd --socket /run/thd.socket --remove $name"; sudo sed -n -i "p;1a ${line}" "$DIR/states.log"; sleep 0.5
fi

sudo bash -c "$cmd"

# ----------------------------------------------------------------
# LOG:

line="`date '+%F %T'` : $cmd"; sudo sed -n -i "p;1a ${line}" "$DIR/states.log"

declare -A MODES=( ["none"]=0 ["term"]=1 ["es"]=2 ["menu"]=2 ["admin"]=2 ["game"]=3 ["mc"]=4 )

if [[ $action == @(add|remove) ]]; then
  sed -i "/^\t${name}/d" "$DIR/devices.log"
  [[ $action == add ]] && { echo -e "\t${name} $([[ $grab -gt 0 ]] && echo '(grab)')" >> "$DIR/devices.log"; }
elif [[ $action == mode ]]; then
  prev_mode=$(awk '/mode:/ {print $NF}' "$DIR/devices.log")

  if [[ ${#target} -gt 0 ]]; then
    [[ ${#prev_mode} -lt 1 ]] && prev_mode="${target}"
    sed -i "/THD_MODE=/ s/[=].*$/=\x27${target}\x27/" "$HOMEDIR/ADMIN/.sys/.states"
    sed -i "/THD_MODE_PREV=/ s/[=].*$/=\x27${prev_mode}\x27/" "$HOMEDIR/ADMIN/.sys/.states"
    sed -i "/^mode:/ s/[\t].*$/\t${target}/" "$DIR/devices.log"
  fi

  [[ "${!MODES[@]}" =~ "${target}" ]] && { echo -e "UI ${MODES[$target]}" > /tmp/serial.fifo; }
  [[ "${target}" == txtinput ]] && typer_state=1 || typer_state=0; printf $typer_state > "$HOMEDIR/ADMIN/.sys/joytyper/state"

  #[[ ${#target} -gt 0 ]] && sed -i "/^mode:/ s/[\t].*$/\t${target}/" "$DIR/devices.log"
  #sed -i 's|mode:[\t].*$|mode:\t'"$target"'|g' "$DIR/devices.log"

  #[[ ! "${target}" == txtinput ]] && printf 0 > "$HOMEDIR/ADMIN/.sys/joytyper/state"
  #[[ "${target}" == typer ]] && [[ $(cat "$HOMEDIR/ADMIN/.sys/joytyper/state") -lt 1 ]] && [[ $(pgrep -fc 'joytyper.sh') -eq 0 ]] && ( sudo bash "$HOMEDIR/ADMIN/.sys/joytyper/joytyper.sh" & )
fi

exit

# ----------------------------------------------------------------



# # TH-CMD:
#
#cmd='sudo th-cmd --socket /run/thd.socket '
#
#[[ $grab -gt 0 ]] && cmd+="--grab "
#[[ ${#action} -gt 0 ]] && [[ ${#target} -gt 0 ]] && cmd+="--$action $target "
#[[ ${#second} -gt 0 ]] && [[ ${#param} -gt 0 ]]  && cmd+="--$second $param "
#
#[[ $action == add ]] && [[ $(grep -c "$name" "$DIR/devices.log") -gt 0 ]] && { \
#  sudo bash -c "sudo th-cmd --socket /run/thd.socket --remove $target"; \
#  sleep 1; \
#}
#
#sudo bash -c "$cmd"
#
# ----------------------------------------------------------------
# LOG:
#
#cmd="`date '+%F %T'` : $cmd"; sudo sed -n -i "p;1a ${cmd}" "$DIR/states.log"
#
#declare -A MODES=( ["none"]=0 ["term"]=1 ["es"]=2 ["menu"]=2 ["admin"]=2 ["game"]=3 ["mc"]=4 )
#
#if [[ $action == @(add|remove) ]]; then
#  sed -i "/^\t${name}/d" "$DIR/devices.log"
#  [[ $action == add ]] && { echo -e "\t${name} $([[ $grab -gt 0 ]] && echo '(grab)')" >> "$DIR/devices.log"; }
#elif [[ $action == mode ]]; then
#  sed -i 's|mode:[\t].*$|mode:\t'"$target"'|g' "$DIR/devices.log"
#  [[ "${!MODES[@]}" =~ "${target}" ]] && { echo -e "UI ${MODES[$target]}" > /tmp/serial.fifo; }
#
#  [[ "${target}" == typer ]] && [[ $(cat "$HOMEDIR/ADMIN/.sys/joytyper/state") -lt 1 ]] && [[ $(pgrep -fc 'joytyper.sh') -eq 0 ]] && ( sudo bash "$HOMEDIR/ADMIN/.sys/joytyper/joytyper.sh" & )
#fi
