#!/bin/bash

# show all F-key values
#for x in {1..24}; do echo -n "F$x "; tput kf$x | cat -A; echo; done

# F-KEYS:
#
#F1 ^[OP
#F2 ^[OQ
#F3 ^[OR
#F4 ^[OS
#F5 ^[[15~
#F6 ^[[17~
#F7 ^[[18~
#F8 ^[[19~
#F9 ^[[20~
#F10 ^[[21~
#F11 ^[[23~
#F12 ^[[24~
#F13 ^[[1;2P
#F14 ^[[1;2Q
#F15 ^[[1;2R
#F16 ^[[1;2S
#F17 ^[[15;2~
#F18 ^[[17;2~
#F19 ^[[18;2~
#F20 ^[[19;2~
#F21 ^[[20;2~
#F22 ^[[21;2~
#F23 ^[[23;2~
#F24 ^[[24;2~
#
# _______________________________________________________


while true; do
	read -rs -N 1 Event1

	case "$Event1" in
	    [[:graph:]])    Event="$Event1" ;;
	    $'\n')          Event="ENTER"   ;;
	    ' ')            Event="SPACE"   ;;
	    [[:blank:]])    Event="TAB"     ;; # TAB must remain below SPACE and ENTER
	    *)
	        read -t 0.01 -rsn5 Event2
	        case "$Event2" in
	            "[A")       Event="UP"          ;;
	            "[B")       Event="DOWN"        ;;
	            "[D")       Event="LEFT"        ;;
	            "[C")       Event="RIGHT"       ;;

	            "[P"|"[3~")     Event="DEL"         ;;
	            "[4h"|"[2~")    Event="INS"         ;;
	            "[4~"|"[F")     Event="END"         ;;
	            "[H"|"[1~")     Event="HOM"         ;;
	            "[5~")          Event="PGUP"        ;;
	            "[6~")          Event="PGDO"        ;;

	            "OP"|"[[A")     Event="F1"          ;;
	            "OQ"|"[[B")     Event="F2"          ;;
	            "OR"|"[[C")     Event="F3"          ;;
	            "OS"|"[[D")     Event="F4"          ;;
	            "[15~"|"[[E")   Event="F5"          ;;
	            "[17~")         Event="F6"          ;;
	            "[18~")         Event="F7"          ;;
	            "[19~")         Event="F8"          ;;
	            "[20~")         Event="F9"          ;;
	            "[21~")         Event="F10"         ;;
	            "[23~")         Event="F11"         ;;
	            "[24~")         Event="F12"         ;;
	            *)

	        case "$Event1$Event2" in
	            $'\E')      Event="ESC"     ;;
	            $'\177'|*)  Event="BCKSPC"  ;; # Remaining keys will be treated as Backspace
	        esac
	        ;;
	        esac
	esac
	printf "${Event} \n"
done





exit 0

KEY=''
while [[ ${#KEY} -lt 1 ]]; do
  read -sN1 -t 0.001 input
  KEY+="${input}"
done

ReadKey() {
  if read -sN1 KEY; then
    while read -sN1 -t 0.001 REPLY; do
      KEY+="${REPLY}"
    done
  fi
}

while ReadKey; do
  case "${KEY}" in
    $'\eOP')   echo 'F1';;
    $'\eOQ')   echo 'F2';;
    $'\eOR')   echo 'F3';;
    $'\eOS')   echo 'F4';;
    $'\e[24~') echo 'F12';;
    #*) echo    "Keys pressed: ${KEY}";;
  esac
done
