#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

data_dir="$HOMEDIR/CAFCA/data/mame-libretro"
roms_dir="$HOMEDIR/RetroPie/roms/mame-libretro"
assets_path="$DIR/assets/cafca"

# ------------------------------------------------------------------------------------------------

sudo cp -f "$data_dir/table" "$assets_path/table"
sudo cp -f "$data_dir/timers" "$assets_path/timers"
sudo cp -f "$data_dir/clearram" "$assets_path/clearram"

for game in $(sudo find "$roms_dir" -type f -iname '*.zip' | grep -o '[^/]*$' | sed 's/[.].*$//' | sort -k 1,1); do
  [[ $(grep -wc "^${game}" "$assets_path/table") -lt 1 ]] && { echo "$game " >> "$assets_path/table"; echo "$game -> table"; }
  [[ $(grep -wc "^${game}" "$assets_path/timers") -lt 1 ]] && { echo "$game 1" >> "$assets_path/timers"; echo "$game -> timers"; }
  [[ $(grep -wc "^${game}" "$assets_path/clearram") -lt 1 ]] && { echo "$game 0" >> "$assets_path/clearram"; echo "$game -> clearram"; }
done

cat "$assets_path/table" | sort -k 1,1 | column -t | sudo tee "$assets_path/table" &> /dev/null
cat "$assets_path/timers" | sort -k 1,1 | column -t | sudo tee "$assets_path/timers" &> /dev/null
cat "$assets_path/clearram" | sort -k 1,1 | column -t | sudo tee "$assets_path/clearram" &> /dev/null

# ------------------------------------------------------------------------------------------------
