#!/bin/bash

path_files='/home/pi/ADMIN/FILES/SAMPLES'
path_last='/home/pi/ADMIN/.sys/.last_sample'

SDL_AUDIODRIVER='alsa'; AUDIODEV='hw:1,0'

samples=($(for f in $path_files/*; do echo $f | grep -o '[^/]*$'; done))
last=$(cat $path_last)
total=$(( $(find $path_files -type f -name "*.wav" -printf x | wc -c) -1 ))
this=$(( last + 1 )); [[ $this > $total ]] && this=0
sample="$path_files/${samples[$this]}"
vol=90

# DEBUG:
echo -e "Playing sample $this / $total - $sample\ndevice: $AUDIODEV, driver: $SDL_AUDIODRIVER\nplayer: ffplay, params: -volume $vol -nodisp -autoexit -loglevel quiet"

printf "$this" | sudo tee $path_last &> /dev/null

[[ $# -gt 0 ]] && [[ "$1" =~ ^[0-9]+$ ]] && sleep "$1"

#ffplay -volume "$vol" -nodisp -autoexit -loglevel quiet "$sample"
aplay -v --dump-hw-params -D hw:1,0 -f S16_LE -c 2 "$sample"
