#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

# -------------------------------------------------------------------------------------------

check_teensy=0

port=$(sed -n '/serial_teensy=/ { s/\(.*\)=//g;s/\x27//g;p }' "$HOMEDIR/ADMIN/.sys/.settings" || echo "/dev/ttyACM1")
serial_fifo=$(sed -n '/fifo_com=/ { s/\(.*\)=//g;s/\x27//g;p }' "$HOMEDIR/ADMIN/.sys/.settings")
joy_dev=$(sed -n '/joystick=/ { s/\(.*\)=//g;s/\x27//g;p }' "$HOMEDIR/ADMIN/.sys/.settings")
asleep=$(sed -n '/ASLEEP=/ { s/\(.*\)=//g;s/\x27//g;p }' "$HOMEDIR/ADMIN/.sys/.states")
wake_msg="VFD 6    WAKING UP"

if [ $# -gt 0 ]; then
  if [[ $1 =~ ^[0-9]+$ ]]; then

    if [[ "$2" == thd ]]; then
      [[ $check_teensy -gt 0 ]] && asleep=$(echo "REQ VAR asleep" > $serial_fifo; sleep 0.5; cat "$HOMEDIR/ADMIN/.sys/.REQ")
      [[ $1 -eq 0 ]] && [[ $asleep -eq 0 ]] && exit 0
    fi

    if [[ $1 -eq 1 ]]; then
      echo "ASLEEP 1" > $serial_fifo
      exit 0
    elif [[ $1 -eq 0 ]]; then
      echo "$wake_msg" > $serial_fifo; sleep 0.5
      echo "ASLEEP 0" > $serial_fifo
      for i in {0..1}; do /usr/bin/evemu-event "$joy_dev" --type EV_KEY --code BTN_TRIGGER --value $i --sync; sleep 0.2; done
      exit 0
    fi
  fi
fi

exit 1
