#!/bin/bash

log_file='/home/pi/ADMIN/.log/serial.log'
fifo_file='/tmp/serial.fifo'
path='/dev/ttyACM'
resp='/home/pi/ADMIN/CMD/SERIAL/response.log'

[ ! -f "$log_file" ] && touch "$log_file"; sudo chmod 775 "$log_file";

echo -e "`date +%F`\n_______________________________________________________________\n" | sudo tee "$log_file" &>/dev/null

# - - - - - - - - - - - - - - - - - - - -

#stty -F /dev/ttyACM1 9600 raw -echok -icanon -echo min 1 time 1

printf '' > $resp; while true; do stty -F /dev/ttyACM1 9600 raw -echok -icanon -echo min 1 time 1 && cat /dev/ttyACM1 > $resp; done &

# - - - - - - - - - - - - - - - - - - - -

while IFS=$'\n' read line; do
  if [[ ${#line} -gt 1 ]]; then
    INBOX="$line"; nom='TEENSY'; dev=1; response=''

    if [[ ${INBOX:1:1} == ':' ]]; then
      [[ ${INBOX:0:1} =~ ^[0-9]+$ ]] && [[ ${INBOX:0:1} < 1 ]] && { nom='RPPICO'; dev=0; }
      INBOX="${INBOX:2}"
    fi

    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo min 0 time 1 && printf "$INBOX;" > "$path$dev"
      response=''
      entry="[ `date +%T` ] RPI > $nom: '$INBOX'\n             RPI < $nom: '$response'\n             --------------------------------------------------"
      offset=$(grep -n -m1 '^_.*' $log_file); sudo sed -n -i "p;$(( ${offset%%:*} + 1 ))a ${entry}" "$log_file"
    fi
  fi
done< <( cat <>"$fifo_file" )

# _____________________________________________________________________________________________________________________________________________________________

#req='/home/pi/ADMIN/.sys/.REQ'
#cmd='/home/pi/ADMIN/.log/teensy_cmd.log'
#resp='/home/pi/ADMIN/CMD/SERIAL/response.log'
#
#stty -F /dev/ttyACM1 9600 raw -echok -icanon -echo; printf '' > $cmd
#
#while IFS=$'\n' read line; do
#  if [[ "$line" =~ 'REQ'.* ]]; then
#    echo "${line//REQ /}" > $req
#  elif [[ "$line" =~ 'CMD'.* ]]; then
#    echo "${line//CMD /}" > $cmd
#  else
#    echo "$line" > $resp
#  fi
#done< <(cat /dev/ttyACM1 | head -n 1) &

# - - - - - - - - - - - - - - - - - - - -
