#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

# _____________________________________________

log_path="$DIR/fd.log"


Main() {
  echo "HELLO"
  cat /home/pi
  dialog --timeout 1 --msgbox "MSG" 0 0 2>&1 1>$(tty) #2>&1 1>&4 4>&2
  whiptail --msgbox "MSG" 0 0 2>&1 1>$(tty)
}

exec > $log_path 2>&1

Main
clear
exit

# - - - - - - - - - - -

exec 4<> $log_path
echo "$(date +%T)" >&4
Main 2>&4
clear
exec 4>&-
exit

# - - - - - - - - - - -

#exec > $log_path 2>&1
#exec 2> $log_path
#exec > $log_path 2>&4


#2>&1 1>&3 3>&2










# _____________________________________________________________________________________________________________________________________


temp_dir="$DIR/tmp"
img_path="$HOMEDIR/ADMIN/FILES/IMAGES/MARQUEES"

name='valkyrie'
preview_time=5

for tmp in "$temp_dir"; do [ -d $tmp ] && rm -rf $tmp; mkdir -p -m 775 $tmp; sudo chmod -R 775 $tmp; sudo chown -R pi:root $tmp; done
[ ! -d "$temp_dir/img" ] && mkdir -p -m 775 "$temp_dir/img"
find $img_path -name "$name*.*" \( -exec cp -f {} "$temp_dir/img/" \; -quit -o -quit \)
for dir in "$temp_dir/img"; do sudo chmod -R 775 $dir; sudo chown -R pi:root $dir; done

# _____________________________________________

Main() {
  declare -a items=()
  for img in $(find "$temp_dir/img" -maxdepth 1 -print | file -if - | grep "image" | cut -d: -f1); do items+=("${img##*/}" ""); done
  file=$(whiptail --menu "MENU" 0 0 0 "${items[@]}" 2>&1 1>$(tty))
  [ $? -eq 0 ] && edit_image "$temp_dir/img/$file"
}

# ---------------------------------------------

edit_image() {
  [ $# -eq 0 ] && return 1

  local file="${1}"; [ ! -f "$file" ] && return 1
  local name="$([[ $file =~ .*/(.*)[_].* ]] && echo ${BASH_REMATCH[1]})"
  local img_w=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f1)
  local img_h=0
  local y_top=0
  local y_bot=0
  local code=0
  local status=0
  local new_val=''
  local source=''
  local output=''
  local output_cropped=''

  for dir in "$temp_dir/img/edited"; do [ ! -d $dir ] && mkdir -p -m 775 $dir; sudo chmod -R 775 $dir; sudo chown -R pi:root $dir; done

  output="$temp_dir/img/edited/${file##*/}"; cp -f "$file" "$output"; img_h=$(identify -format "%h" "$output"); y_top=$img_h

  while [[ $code -eq 0 ]]; do
    action=$(whiptail --ok-button "Select" --cancel-button "Done" --menu "edit image for '$name'" 0 0 0 "PREVIEW" "" "CROP IMAGE" "" "NEW SOURCE" "" 2>&1 1>$(tty)); code=$?

    if [ $code -eq 0 ]; then
      case "$action" in
        'PREVIEW')
          sudo fbi -T 2 -d /dev/fb0 -t $preview_time --once --noverbose "${output_cropped:-$output}" &>/dev/null; while [[ $(pgrep -c fbi) -gt 0 ]]; do :; done
	;;
        'CROP IMAGE') status=0
          [[ ${#output_cropped} -gt 0 ]] && { output="$temp_dir/img/edited/${file##*/}"; cp -f "$file" "$output"; output_cropped=''; }

          while [[ $status -eq 0 ]]; do
            crop_mode=$(whiptail --title "CROP IMAGE" --menu "edit ${output##*/} ($img_wx$img_h)" 0 0 0 "TOP" "" "BOTTOM" "" "APPLY" "" 2>&1 1>$(tty)); status=$?
            if [ $status -eq 0 ]; then
              case "$crop_mode" in
                'TOP')
                  new_val=$(dialog --colors --title "CROP IMAGE" --rangebox "TOP" 0 0 $y_bot $img_h $y_top 2>&1 1>$(tty)); [[ $? -eq 0 ]] && y_top=$new_val
                ;;
                'BOTTOM')
                  new_val=$(dialog --colors --title "CROP IMAGE" --rangebox "BOTTOM" 0 0 0 $y_top $y_bot 2>&1 1>$(tty)); [[ $? -eq 0 ]] && y_bot=$new_val
                ;;
                'APPLY')
                  whiptail --title "APPLY CROP?" --yesno "TOP: > $((img_h-y_top))px\nBOT: < ${y_bot}px" 0 0
                  [[ $? -eq 0 ]] && { status=1; output_cropped="${output%%.*}.cropped.jpg"; gm convert "$output" -crop "$img_w"x"$((img_h-y_bot))"+0+"$((img_h-y_top))" "$output_cropped"; }
                ;;
              esac
            fi
          done
	;;
        'NEW SOURCE')
          declare -a sources=()
          declare -a types=()

          for img in $(find "$img_path" -print | file -if - | grep "image" | cut -d: -f1); do sources+=("${img##*/}" ""); done
          source=$(whiptail --menu "MENU" 0 0 0 "${sources[@]}" 2>&1 1>$(tty))

          if [ $? -eq 0 ]; then
            if [ -f "$img_path/$source" ]; then
              for dir in "$temp_dir/img/sourced"; do [ ! -d $dir ] && mkdir -p -m 775 $dir; sudo chmod -R 775 $dir; sudo chown -R pi:root $dir; done
              cp -f "$img_path/$source" "$temp_dir/img/sourced/$source"
              source="$temp_dir/img/sourced/$source"
              types=($(file -b --extension $source | sed 's/\// /g'))

              [[ "${types[@]}" =~ png ]] \
              && gm convert -resize ${img_w}x +profile "*" "${source}" "${source%%.*}-scaled.jpg" &>/dev/null \
              || gm convert -resize ${img_w}x "${source}" "${source%%.*}-scaled.jpg" &>/dev/null

              file="${source%%.*}-scaled.jpg"; output="$file"; output_cropped=''
              img_h=$(identify -format "%h" "$output"); y_top=$img_h; y_bot=0
            fi
          fi
	;;
      esac
    fi
  done
  whiptail --yes-button "Keep" --no-button "Discard" --yesno "Keep Changes?" 0 32

  if [ $? -eq 0 ]; then
    source="${output_cropped:-$output}"; file="$temp_dir/img/${name}_$(( img_h-((img_h-y_top)+y_bot) )).jpg"
    cp -f "${source}" "${file}.new"; rm -f $temp_dir/img/${name}_*.jpg; mv -f "${file}.new" "${file}"; sudo chmod -R 775 "$temp_dir/img"
  fi

  #[ $? -eq 0 ] && cp -f "$output" "$temp_dir/img/edited/${name}_$(( img_h - ((img_h-y_top)+y_bot) )).${output##*.}.final"
  #[ $? -eq 0 ] && cp -f "$output" "$temp_dir/img/edited/${name}_$(( img_h - ((img_h-y_top)+y_bot) )).${output##*.}.final"

  return 0
}

# _____________________________________________

Main
