#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

roms_dir="$HOMEDIR/RetroPie/roms/mame-libretro"
torrent_dir="$HOMEDIR/downloads/MAME2003_Reference_Set_MAME0.78_ROMs_CHDs_Samples/roms"
output_dir="$DIR/roms"
assets_path="$DIR/assets"

# ---------------------------------------------------

Download() {
  [[ $(read -n1 -p "$(echo -e '\nRUN TRANSMISSION?') " a</dev/stdin; echo $a) == [yY] ]] \
  && { echo ""; sudo -u pi bash -c 'bash /home/pi/ADMIN/CMD/DOWNLOADER/01_DOWNLOADER.sh'; }
}

# ---------------------------------------------------

Scrape() {
  sudo find $output_dir -maxdepth 1 -type f -iname '*.zip' -exec sudo -u pi cp -vn {} $roms_dir \; | awk '{gsub(/\x27/,"",$NF);print $NF}' | sudo tee "$assets_path/scraper/downloads.txt"
  [[ $(cat "$assets_path/scraper/downloads.txt" | wc -l) -lt 1 ]] && for rom in $(ls $output_dir | sed -z 's/ /\n/g'); do echo "$roms_dir/$rom"; done | sudo tee "$assets_path/scraper/downloads.txt"

  #[[ ! $(read -n1 -p "$(echo -e '\nSCRAPE?') " a</dev/stdin; echo $a) == [yY] ]] && exit

  bash "$DIR/02_SCRAPER.sh"
}

BuildLists() {
  game_list="$assets_path/.list"

  if [[ $(read -n1 -p "$(echo -e '\nEDIT DATA?') " a</dev/stdin; echo $a) == [yY] ]]; then echo "";
    for name in $(cat "$assets_path/scraper/downloads.txt" | grep -o '[^/]*$' | sed 's/[.].*$//'); do
      if grep "$name" "$assets_path/scraper/.list.new"; then echo "EDIT DATA for '$name'? (Y/n)";
        if [[ $(read -sn1 a</dev/stdin; echo $a) == [yY] ]]; then echo "";
          echo "- type 'input type' and 'lists' (comma-separated)"
          read type list; echo "type: '${type^^}', list: '${list^^}'"
          [[ ${type^^} == @(JOY|GUN|SPIN) ]] && sed -i "/${name}/ s/JOY/${type^^}/" "$assets_path/scraper/.list.new"
          [[ ${#list} -gt 0 ]] && { list="${list//,/ }"; sed -i "/${name}/ s/\[\(.*\)\]/[ ${list^^} ]/" "$assets_path/scraper/.list.new"; }
        fi
      fi
    done
    cat "$assets_path/scraper/.list.new"
  fi

  sudo cp "$assets_path/scraper/.list.new" "$assets_path/.list"
  sudo cp "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.shooters" "$assets_path/.shooters"
  sudo cp "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.spinners" "$assets_path/.spinners"

  for game in $(cat $game_list | grep '\[*GUN*' | awk -F'\x27' '{print $2}'); do
    [[ $(grep -c "^$game" "$assets_path/.shooters") -lt 1 ]] && printf '%-8s\t0\n' "$game"
  done >> "$assets_path/.shooters"

  for game in $(awk -F'\x27' '{if ($10 ~ "SPIN") print $2;}' $game_list); do
    [[ $(grep -c "^$game" "$assets_path/.spinners") -lt 1 ]] && printf '%-8s\t72\t\t1\t\t255\t\t255\n' "$game"
  done >> "$assets_path/.spinners"

  [[ $(read -n1 -p "$(echo -e '\nUPDATE CAFCA LISTS?') " a</dev/stdin; echo $a) == [yY] ]] \
  && { echo ""; sudo bash "$DIR/03_CAFCA_LISTS.sh"; echo ""; }

  sleep 1
}

ApplyChanges() {
  if [[ $(read -n1 -p "$(echo -e '\nAPPLY CHANGES?') " a</dev/stdin; echo $a) == [yY] ]]; then echo "";
    for f in .list .shooters .spinners; do sudo cp -vf "$assets_path/$f" "$HOMEDIR/ADMIN/MENU/.assets/GAMES/$f"; done
    for f in table timers clearram; do sudo cp -vf "$assets_path/cafca/$f" "$HOMEDIR/CAFCA/data/mame-libretro/$f"; done
  fi
}




exit
