#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
SCRIPT_DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

#exec > >(tee "$SCRIPT_DIR/tst.log" >/dev/null) 2>&1
exec > >(tee "$SCRIPT_DIR/tst.log") 2>&1

echo -e "\n$(date '+%F %T')\n"

file=$(ls "$HOMEDIR/ADMIN/.backup" | tr ' ' '\n' | grep 'zip$' | tail -n 1)

sudo cp -f "$HOMEDIR/ADMIN/.backup/$file" "$SCRIPT_DIR/file.zip"

7z l "$SCRIPT_DIR/file.zip" | awk '{$1=$1;print}' | awk '{print $4,$6}' | grep -P '^[[:digit:]].*?[/]' | awk '{ printf("%06d %s\n", $1, $2)}' \
| sort -k1,1 | numfmt --to=si | awk '{print $1"b "$2}' | sed -r 's/([0-9])([a-zA-Z])/\1 \2/g; s/([a-zA-Z])([0-9])/\1 \2/g'; echo "" #| tac; echo ""

echo -e "$(echo $(sudo du -sh $SCRIPT_DIR/file.zip) | cut -d' ' -f1)b total."

 #| xargs -i printf "bytes: %s\n" {}
