#!/bin/bash

HOMEDIR='/home/pi'
output_path='/home/pi/ADMIN/.sys/.inputs'
dump_path='/home/pi/ADMIN/.log/retroarch-boot.log'

header="'GLOBAL' 'ID' 'NAME' 'RETRO_DEV' 'PHYS' 'CAPABILITIES'"
ra_dump=$(grep '\[udev\]' "$dump_path" | sed 's/\[INFO\]\s\[udev\]:\s//g')
names=($(grep -Ew "by-id" "$HOMEDIR/ADMIN/.sys/.settings" | sed 's/^DEV\s\(.*\)=.*$/\1/')); names+=("udev")

for name in "${names[@]}"; do
  path=$(grep -Ew "^DEV $name" "$HOMEDIR/ADMIN/.sys/.settings" | sed 's/\(.*\)=//g; s/\x27//g;s/\/dev\/input\/by-id\///')
  id=$([[ "$path" == usb* ]] && ls -la /dev/input/by-id | grep $path | grep -o '[^/]*$' || echo "${path//*\//}")
  #title=$(cat "/sys/class/input/$id/device/uevent" | grep --color=never '^NAME' | sed 's/\(.*\)=//g;s/\x22//g')
  title=$(cat "/sys/class/input/$id/device/name")
  port=$(echo "$ra_dump" | grep -m1 "$title" | sed 's/\(.*\)on\s//;s/\(.\)$//;s/\s#//')
  ra_index=$(echo "$ra_dump" | grep -w "$id" | sed 's/ (.*$//;s/ #/_/')
  types=$(ls "/sys/class/input/$id/device" | grep 'js\|mouse' | awk '{printf $0","}' | sed 's/\(.\)$//')
  phys=$(cat "/sys/class/input/$id/device/phys"); phys="${phys#*.}"

  echo -e "'${name:--}' '${id:--}' '\x22${title:--}\x22' '${ra_index:--}' '${phys:--}' '[${types:-..}]'"
done | sudo tee "$output_path" >/dev/null 2>&1

sed -i "1i ${header}" "$output_path"
cat "$output_path" | sed "s/' '/|/g" | column -s '|' -t | sed "s/|/' '/g;s/\x27//g" | sudo tee "$output_path" >/dev/null 2>&1

sep=$(printf '#'; for n in $(seq 1 $(sed -n '1p' "$output_path" | wc -c)); do printf '-'; done)
sed -i "2i ${sep}" "$output_path"
cat "$output_path"

exit
