#!/bin/bash

scriptT=$(( $(date +%s%N) / 1000 ))
log_path='/boot/boot.log'
[ ! -f "$log_path" ] && touch "$log_path"; sudo chmod 775 "$log_path"; sleep 1

exec > $log_path 2>&1

include_file='/home/pi/ADMIN/.sys/include.sh'
[ -f $include_file ] && source $include_file; include


# SYSTEM VARIABLES
#----------------------------------------------------

declare -a devices=($(grep -Ew "by-id" "$HOMEDIR/ADMIN/.sys/.settings" | sed 's/^DEV //;s/\x27//g'))
for dev in "${devices[@]}"; do declare "${dev%=*}_id"="${dev#*=}"; done

teensy_serial="$(ls -lah /dev/serial/by-id | grep -i Teensy | awk -F/ '{print $NF}')"
gun_serial="$(ls -lah /dev/serial/by-id | grep -i GUN | awk -F/ '{print $NF}')"
states_log="$HOMEDIR/ADMIN/.sys/thd/states.log"
thd_devs="$HOMEDIR/ADMIN/.sys/thd/devices"
title_list="$HOMEDIR/ADMIN/.sys/arkade.titles"
fifo_path=$(sed -n '/fifo_com/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")

boot_mode=$(sed -n '/boot_mode/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings"); boot_mode="${boot_mode,,}"
protect_time=$(sed -n '/protect_time=/ { s/\(.*\)=//g;p }' "$HOMEDIR/ADMIN/.sys/.settings")

teensy_name="$([[ $boot_mode == es ]] && echo 'teensy_es' || echo 'teensy')"

#____________________________________________________

Main() {
   datestring=$(date | cut -c -20)
   echo -e "\nA U T O S T A R T   L O G:"
   echo -e "( $datestring )\n\n"

   # FILE OPERATIONS
   #-------------------------------------------------

     printf '' > "$HOMEDIR/ADMIN/.log/teensy_cmd.log"
     sudo mkfifo -m 775 "$fifo_path" && sleep 1; sudo chown pi:root "$fifo_path"
     sudo mkfifo -m 775 /tmp/elapsed.fifo && sleep 1; sudo chown pi:root /tmp/elapsed.fifo
     sudo mkfifo -m 775 /tmp/omxctrl.fifo && sleep 1; sudo chown pi:root /tmp/omxctrl.fifo
     sudo mkfifo -m 775 /tmp/joytyper.fifo && sleep 1; sudo chown pi:root /tmp/joytyper.fifo

     sudo sed -i '/serial_teensy/ s/DEV serial_teensy[=].*$/'"DEV serial_teensy=\x27\x2Fdev\x2F$teensy_serial\x27"'/' "$HOMEDIR/ADMIN/.sys/.settings"
     sudo sed -i '/serial_gun/ s/DEV serial_gun[=].*$/'"DEV serial_gun=\x27\x2Fdev\x2F$gun_serial\x27"'/' "$HOMEDIR/ADMIN/.sys/.settings"

     sudo cp -r "$thd_devs.default" "$thd_devs.log"

     [ ! -f "$states_log" ] && { sudo touch "$states_log"; } || { printf '\n' | sudo tee "$states_log" &>/dev/null; }
     sudo chown pi:root "$states_log" && sudo chmod 775 "$states_log"

     sudo chown -R pi:root "$HOMEDIR/ADMIN/CMD/THD"; sudo chmod -R 775 "$HOMEDIR/ADMIN/CMD/THD"

     echo -e "`date +%F`\n" > "$HOMEDIR/ADMIN/.log/emulationstation.log"
     echo -e "E M U L A T I O N S T A T I O N   L O G\n" > "$HOMEDIR/ADMIN/.log/es.log"


   # SCRIPTS
   #-------------------------------------------------

     #( sleep 10; alsactl --file "$HOMEDIR/.config/asound.state" restore; ) &
     ( sleep 10; alsactl --file "$HOMEDIR/.config/asound_eq.state" restore; ) &
     #( while [ -z "$(pidof pulseaudio)" ]; do :; done; sleep 2; alsactl --file "$HOMEDIR/.config/asound_eq.state" restore; ) &
     #( while [ -z "$(pidof pulseaudio)" ]; do sleep 1; done; alsactl --file "$HOMEDIR/.config/asound.state" restore; ) &

     # alsactl --file "$HOMEDIR/.config/eq_default.state" restore
     # alsactl --file "$HOMEDIR/.config/asound.state" restore
     # #amixer -D default set Master 100%

     sudo thd --socket /run/thd.socket --triggers /home/pi/ADMIN/.sys/thd/conf/triggers --user pi --daemon --uinput /dev/uinput --pidfile /home/pi/ADMIN/.sys/thd/pid
     sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --add teensy --tag "${teensy_name:-teensy}"

     th_udev=$(for vpath in /sys/devices/virtual/input/input*; do [[ $(cat "$vpath/name") == triggerhappy ]] && ls -la $vpath | grep -o '[^ ]*$' | grep '^event'; done)
     sudo sed -i 's|DEV udev[=].*$|DEV udev='"\x27/dev/input/$th_udev\x27"'|g' "$HOMEDIR/ADMIN/.sys/.settings"

     sudo bash "$HOMEDIR/ADMIN/.sys/input_info.sh"; echo ""

     retro_joypad_index=$(grep -w -m1 '^joystick' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{print $(NF-2)}' | sed 's/\(.*\)_//'); sudo sed -i "/input_player1_joypad_index/ s/=\s.*$/= \x22${retro_joypad_index:-0}\x22/" "$HOMEDIR/CAFCA/cfg/cafca.cfg"
     retro_mouse_index=$(grep -w -m1 '^spinner' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{print $(NF-2)}' | sed 's/\(.*\)_//'); sudo sed -i "/input_player1_mouse_index/ s/=\s.*$/= \x22${retro_mouse_index:-0}\x22/" "$HOMEDIR/CAFCA/cfg/cafca.cfg"
     retro_gun_index=$(grep -w -m1 '^gun' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{print $(NF-2)}' | sed 's/\(.*\)_//'); sudo sed -i "/input_player1_mouse_index/ s/=\s.*$/= \x22${retro_gun_index:-3}\x22/" "$HOMEDIR/CAFCA/cfg/gun.cfg"

     sudo bash "$HOMEDIR/ADMIN/CMD/SERIAL/SERIAL.sh" & sleep 1

     #spinner_off=$(sed -n '/disable_spinner/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings"); #[[ $spinner_off -eq 0 ]] && echo "SPIN_OFF 0" > "$fifo_path";
     #marquee_on=$(sed -n '/marquee=/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings" )
     #marquee_off=$(echo "$(( ! $(sed -n '/marquee=/ { s/\(.*\)=//g; s/\x27//g; p }' $HOMEDIR/ADMIN/.sys/.settings) ))" ); #[[ $marquee_off -eq 1 ]] && echo "MARQUEE 0" > "$fifo_path";

     # ---------------------------------------------------------

     #declare -A boot_data=( \
     #  [A-MARQUEE]="${marquee_on:-0}" \
     #  [B-PROTECT_TIME]="${protect_time:-5000}" \
     #  [C-SPIN_OFF]="${spinner_off:-0}" \
     #  [D-PIR_SENS]="3" \
     #)

     #for key in $(echo "${!boot_data[@]}" | tr " " "\n" | sort); do echo "${key##*-} ${boot_data[$key]}"  > "$fifo_path"; sleep 0.1; done; sleep 1

     #echo "BOOTED 1" > "$fifo_path";

     #echo "SPIN_OFF ${spinner_off:-0}" > "$fifo_path";
     #echo "MARQUEE ${marquee_off:-0}" > "$fifo_path";
     #sleep 1
     #echo "BOOTED 1" > "$fifo_path";
     #echo "PIR_SENS 3" > "$fifo_path"
     #echo "PROTECT_TIME ${protect_time:-5000}" > "$fifo_path"

     echo "BOOTED 1" > "$fifo_path";

     sudo sed -i '/BOOTED/ s/BOOTED[=].*$/BOOTED=1/' "$HOMEDIR/ADMIN/.sys/.states"

     ( keyLogger & )
     ( joytyper_state & )
     ( check_network & )
     #( teensySerial & )

     echo -e "TEENSY SERIAL: /dev/$teensy_serial\nGUN SERIAL:    /dev/$gun_serial\n"

     sleep 5

     system_info
}

# _______________________________________________________________________________________________________________

check_network() {
  local log_file="$HOMEDIR/ADMIN/.log/unknown_ips.log"
  local whitelist="$(sed -n '/ip_whitelist/ { s/\(.*\)=//g;s/\x27//g;p;q }' $HOMEDIR/ADMIN/.sys/.settings)"
  local online=0
  local eth=''
  declare -a ips=()

  while :; do
    ping -c2 google.com > /dev/null;
    online=$(( ! $? ))

    if [[ $online -eq 1 ]]; then
      eth=$(ifconfig | grep -o '^eth[^:]');
      ips=($(who -s | grep -Eo '[0-9]{3}.[0-9]{3}.[0-9]{1,}.[0-9]{1,}' | sort -u))

      for ip in "${ips[@]}"; do
        if [[ ! $ip == "$whitelist" ]]; then
          echo "$(date '+%F %T'): INTRUDER @ $ip !" >> $log_file
          ifconfig $eth down; online=0
          echo -e "VFD 0   UNKNOWN IP ! \$1,100,10" > /tmp/serial.fifo
        fi
      done
    fi
  done
}

joytyper_state() {
  local state=$(cat "$HOMEDIR/ADMIN/.sys/joytyper/state")
  local last_state=$state
  local thd_state_stored=''
  local activated=0

  #while IFS=$'\n'; do read -rs -N 1 -t 0.1 line >/dev/null; [[ ${#line} -gt 0 ]] && { read -rs line2; line=${line}${line2}; }

  while true; do
    state=$(cat "$HOMEDIR/ADMIN/.sys/joytyper/state")

    if [[ ! $state == $last_state ]]; then thd_state_stored=$(sed -n '/THD_MODE_PREV=/ { s/\(.*\)=//g;s/\x27//g;p }' "$HOMEDIR/ADMIN/.sys/.states")
      if [[ $state -eq 1 ]] && [[ $activated -eq 0 ]]; then activated=1;
        sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode txtinput;
        [[ $(pgrep -fc '.*(MENU|GAMES|editor).sh.*') -eq 0 ]] && { echo "VFD 6 TXT INPUT ON !" > "$fifo_path"; sleep 0.5; }
      elif [[ $state -eq 0 ]] && [[ $activated -eq 1 ]]; then activated=0;
        #sudo kill -9 $(sudo pgrep -f '^(bash|sudo bash) joytyper.sh')
        sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode "${thd_state_stored}";
        [[ $(pgrep -fc '.*(MENU|GAMES|editor).sh.*') -eq 0 ]] && { echo "VFD 3 TXT INPUT OFF" > "$fifo_path"; sleep 0.5; }
        sudo kill -9 $(pgrep -f 'joytyper')
      fi
      last_state=$state
    fi
  done
  #done< <( cat <>/tmp/joytyper.fifo )
}

#teensySerial() {
#  local response='/home/pi/ADMIN/CMD/SERIAL/response.log'
#  local REQ='/home/pi/ADMIN/.sys/.REQ'
#  local pings=0
#
#  declare -a texts=( \
#    '2   HELLO PLAYER' \
#    '3   PRESS TO PLAY' \
#    '1 Press button or joy to wake up' \
#    '2 SHALL WE PLAY A GAME?' \
#    '5    WAKE ME UP!' \
#  )
#
#  while read line; do line=$(printf "$line" | sed -z 's/\r//g');
#    if [[ $line == 'RES '* ]]; then MSG="${line#* }";
#      echo "$MSG" > $REQ
#    #elif [[ $line == 'CMD '* ]]; then MSG="${line#* }";
#    #  [[ $MSG == PING ]] && { echo "VFD ${texts[$pings]}" > /tmp/serial.fifo; (( pings++ )); pings=$(( pings % ${#texts[@]} )); }
#    fi
#  done< <(tail -F $response 2>/dev/null);
#}


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

keyLogger() {
  local blacklist=$(grep -w '^gun\|^spinner' "$HOMEDIR/ADMIN/.sys/.inputs" | awk '{printf $2"|"}' | sed 's/\(.\)$//')
  local last=$EPOCHSECONDS;
  local ssaver=0
  local asleep=0

  while true; do read -sr -t 0.1 input >/dev/null;
    ssaver=$(sed -n '/SSAVER=/ { s/\(.*\)=//g;p }' "$HOMEDIR/ADMIN/.sys/.states")
    asleep=$(sed -n '/ASLEEP=/ { s/\(.*\)=//g;p }' "$HOMEDIR/ADMIN/.sys/.states")

    if [[ $(pgrep -c retroarch) -gt 0 ]]; then
      last=$EPOCHSECONDS; read -sr -t 1 void >/dev/null
    else
      if [[ ${#input} -gt 0 ]] && [[ ! "${input//*\//}" == @($(echo "${blacklist}")) ]]; then
        last=$EPOCHSECONDS

        if [[ $asleep -eq 1 ]]; then
          echo "VFD 6 W A K I N G  U P" > /tmp/serial.fifo
          sudo sed -i "/ASLEEP/ s/[=].*$/=0/" "$HOMEDIR/ADMIN/.sys/.states"
        elif [[ $ssaver -eq 1 ]]; then
          echo "VFD 2   WELCOME BACK!" > /tmp/serial.fifo
          sudo sed -i "/SSAVER/ s/[=].*$/=0/" "$HOMEDIR/ADMIN/.sys/.states"
        fi
        read -sr -t 1 void >/dev/null;
      else
        sleep 1
      fi

      if [[ "$(( $EPOCHSECONDS - $last ))" -gt 0 ]]; then
        if [[ $(sed -n '/vfd_saver=/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings") -eq 1 ]]; then
          [[ $asleep -eq 1 ]] && [[ "$(( ($EPOCHSECONDS - $last) % 60 ))" -eq 0 ]] && { sudo bash "$HOMEDIR/ADMIN/CMD/VFDSAVER/VFDSAVER.sh" "$((RANDOM % 8))" & sleep 1; }
        fi
        echo "$(( $EPOCHSECONDS - $last ))" > /tmp/elapsed.fifo; sleep 0.1
      fi
    fi
  done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#\|REL\|ABS' |& awk -W interactive '{$1=$1;print}')
}

# _______________________________________________________________________________________________________________


system_info() {
   echo -e "BOOT MODE: ${boot_mode}"

   data_model=$(cat /proc/cpuinfo | grep Model | cut -d':' -f2 | sed 's/ //')
   data_serno=$(cat /proc/cpuinfo | grep Serial | cut -d ' ' -f 2 | cut -c 9- | awk '{print "0x" $0}')
   data_os=$(cat /etc/os-release | sed -n '1p' | cut -d\" -f2)
   data_ip=$(hostname -I | cut -d' ' -f1)

   echo -e "\nMODEL:   $data_model\nSERIAL:  $data_serno\nOS:      $data_os\n\nIP ADDR: $data_ip\n"

   while [[ $(sudo systemd-analyze &>/dev/null; echo $?) -gt 0 ]]; do sleep 0.1; done; sleep 1
   sudo systemd-analyze | xargs | sed 's/(//g; s/)//g' | awk -F' ' '{print "BOOT TIMES:\n" $5 "\t\t" $4 "\n" $8 "\t" $7 "\n" $1 "\t\t" $10}'

   STATUS=$(vcgencmd get_throttled | sed -n 's|^throttled=\(.*\)|\1|p')

   if [[ ${STATUS} -ne 0 ]]; then
    echo -n "WARNING: "
     [ $((${STATUS} & 0x00001)) -ne 0 ] && echo "Power is currently Under Voltage" || { [ $((${STATUS} & 0x10000)) -ne 0 ] && echo "Power has previously been Under Voltage"; }
     [ $((${STATUS} & 0x00002)) -ne 0 ] && echo "ARM Frequency is currently Capped" || { [ $((${STATUS} & 0x20000)) -ne 0 ] && echo "ARM Frequency has previously been Capped"; }
     [ $((${STATUS} & 0x00004)) -ne 0 ] && echo "CPU is currently Throttled" || { [ $((${STATUS} & 0x40000)) -ne 0 ] && echo "CPU has previously been Throttled"; }
     [ $((${STATUS} & 0x00008)) -ne 0 ] && echo "Currently at Soft Temperature Limit" || { [ $((${STATUS} & 0x80000)) -ne 0 ] && echo "Previously at Soft Temperature Limit"; }
     echo ""
   fi

   echo -e "\nDISK USAGE:"
   sudo df -h | head -n 2


   echo -e "\n";
   index=$(awk '/usb/ {$1=$1;print $1}' /proc/asound/modules)

   #aplay -l
   #cat /proc/asound/cards
   cat /proc/asound/card$index/stream0
   cat /proc/asound/card$index/pcm0p/info

  #( sleep 30; sudo journalctl -r -b | sudo tee -a "$log_path" 2>&1 & )

}

#_______________________________________________________________________________________________________________

# FOR EMULATIONSTATION:

if [[ $boot_mode == es ]]; then
  declare -ga selected=(1 1)
  declare -ga pages=(0 0)
  declare -a KEYS=('ARKADE' 'LIGHTGUN' 'PINBALL' 'CAFCA' 'MAME' 'AMIGA' 'RETROPIE')
  declare -a LENGTHS=(65 51 8)
  declare -a INDEX=(1 1 1 1 1 1 1)

  startup_system=$(grep -wi StartupSystem "$HOMEDIR/.emulationstation/es_settings.cfg" | cut -d\" -f4)
  selection=1; page=0; printed=1
  startT=$(( $(date +%s%N) / 1000 ))

  function dump_menu() {
    pages[0]=$(grep -w -m1 'JOY_POS_X' "$HOMEDIR/ADMIN/.sys/.states" | cut -d= -f2)

    if [[ ${pages[0]} != ${pages[1]} ]]; then
      page=${pages[0]}
      [[ $page -lt 0 ]] && page=$(( 7 + $page ))
      [[ $page -lt ${#LENGTHS[@]} ]] && { sudo sed -i "/JOY_POS_Y/ s/JOY_POS_Y[=].*$/JOY_POS_Y=${INDEX[$page]}/" "$HOMEDIR/ADMIN/.sys/.states"; selected[1]='0'; }
    fi
    pages[1]="${pages[0]}"

    if [[ $page -lt ${#LENGTHS[@]} ]]; then
      selected[0]=$(grep -w -m1 'JOY_POS_Y' "$HOMEDIR/ADMIN/.sys/.states" | cut -d= -f2)

      if [[ ${selected[0]} -ne ${selected[1]} ]]; then
        if [[ ${selected[0]} -lt 1 ]]; then
          selected[0]="${LENGTHS[$page]}"; sudo sed -i "/JOY_POS_Y/ s/JOY_POS_Y[=].*$/JOY_POS_Y=${selected[0]}/" "$HOMEDIR/ADMIN/.sys/.states"
        elif [[ ${selected[0]} -gt ${LENGTHS[$page]} ]]; then
          selected[0]='1'; sudo sed -i "/JOY_POS_Y/ s/JOY_POS_Y[=].*$/JOY_POS_Y=${selected[0]}/" "$HOMEDIR/ADMIN/.sys/.states"
        fi
        INDEX[$page]="${selected[0]}"; selected[1]="${selected[0]}"
        echo -e "INDEX[$page] (${KEYS[$page]}) = ${INDEX[$page]}"
        startT=$(( $(date +%s%N) / 1000 )); printed=0
      else
        if [[ $printed -lt 1 ]]; then
          elapsed=$(( ( $(date +%s%N) / 1000 ) - startT ))
          if [[ $(( elapsed / 1000 )) -gt 2000 ]]; then
            file="$HOMEDIR/ADMIN/.sys/${KEYS[$page],,}.titles"
            title=$(awk -v ln="${selected[0]}" 'NR==ln' "$file")
            echo -e "VFD 1 $title" > /tmp/serial.fifo
            printed=1
          fi
        fi
      fi
    fi
    sleep 1
  }
fi

# ---------------------------------------------------------------------------------------------------------------

Main

exit


# ---------------------------------------------------------------------------------------------------------------

sleepBg() {
  local asleep=0
  local count=0
  local timeout=$(grep -w -m1 'timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)

  #while [[ $(pgrep -fc 'GAMES') -gt 0 ]]; do
  while true; do
    read -t 1 input
    if [[ $count -ge $timeout ]]; then
        [[ $(pgrep -c 'retroarch') -lt 1 ]] && \
        [[ $asleep -eq 0 ]] && { echo -e "ASLEEP 1" > /tmp/serial.fifo; }
        asleep=1; count=0
    elif [[ ${#input} -gt 0 ]]; then
      [[ $asleep -eq 1 ]] && { echo -e "ASLEEP 0" > /tmp/serial.fifo; }
      asleep=0; count=0;
    fi
    (( count++ ))
  done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#' |& awk -W interactive '{$1=$1;print $NF}' | grep --line-buffered -vw '/dev/input/event1')
}
