#!/bin/bash

ARGS=("$@")
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

req_file="$HOMEDIR/ADMIN/.sys/.REQ"
sys_states="$HOMEDIR/ADMIN/.sys/.states"
sys_settings="$HOMEDIR/ADMIN/.sys/.settings"
serial_port=$(sed -n '/serial_teensy/ {s/\(.*=\x27\)*//g;s/\x27$//;p;q}' $sys_settings)

req() {
  printf '' > "$req_file"
  [[ $1 == @(MILLIS|TEMP|CORE|HUMID) ]] && { echo -e "REQ $1" > /tmp/serial.fifo; sleep 0.5; }
  echo "$(cat $req_file | sed 's/\(.*:\)*//g')"
}

#for key in 'MILLIS' 'TEMP' 'CORE' 'HUMID'; do res=$(req "$key"); echo -e "$key:\t$res"; sleep 1; done

rpi_temp_cpu=$(echo -e "$(( $(cat /sys/class/thermal/thermal_zone0/temp)/100 ))" | sed 's/./&./2')
rpi_temp_gpu=$(printf '%02.1f\n' "$(vcgencmd measure_temp | sed 's/\(.*=\)//g;s/\(\x27\).*$//g')")
teensy_temp=$(printf '%02.1f\n' "$(req CORE)")
cab_temp=$(printf '%02.1f\n' "$(req TEMP)")
cab_humid=$(printf '%02.1f\n' "$(req HUMID)")

echo -e "RPI:\t$rpi_temp_cpu"
echo -e "GPU:\t$rpi_temp_gpu"
echo -e "MCU:\t$teensy_temp"
echo -e "CAB:\t$cab_temp"
#echo -e "HUM:\t$cab_humid"


#printf '%02.1f\n' $(echo -e "REQ TEMP" > /tmp/serial.fifo; sleep 0.5; echo "$(cat $req_file | sed 's/\(.*:\)*//g')")
