#!/bin/bash

arg="${1:-0}"
#arg=$(( arg % modes ))

echo -e "VFD CMD CLS" > /tmp/serial.fifo; sleep 0.5
echo -e "VFD CMD BGL 128" > /tmp/serial.fifo; sleep 0.5

case $arg in
  0)
    echo -e "VFD CMD BGL 64" > /tmp/serial.fifo; sleep 0.5
    echo -e "VFD ANI 7\$6,0,16,30,0,111" > /tmp/serial.fifo
    sleep 10
    ;;
  1)
    order=($(seq 0 15 | shuf));
    for num in ${order[@]}; do
      echo -e "VFD ANI 8\$0,$num,$(( (num+1)%16 )),140,0,240" > /tmp/serial.fifo
      sleep 2
    done
    ;;
  2)
    for i in {1..3}; do
      echo -e "VFD ANI 6\$7,0,16,100,2000,111" > /tmp/serial.fifo
      sleep 5
    done
    ;;
  3)
    echo -e "VFD ANI 5\$5,0,16,70,1000,111" > /tmp/serial.fifo
    sleep 10
    ;;
  4) # female eyes blink
    echo -e "VFD DRW HEX 0814142222 2241474f5f 5f59492622 2214140800 0008141422 222649595f 5f4f474122 2222141408" > /tmp/serial.fifo; sleep 2
    echo -e "VFD DRW HEX 0814142a2a 2a45454d5d 5d5d4d2a2a 2a14140800 0008141422 222649595f 5f4f474122 2222141408" > /tmp/serial.fifo; sleep 0.2
    echo -e "VFD DRW HEX 081c143232 3251515151 5151512a2a 2a14140800 0008141422 222649595f 5f4f474122 2222141408" > /tmp/serial.fifo; sleep 0.2
    echo -e "VFD DRW HEX 0814142a2a 2a45454d5d 5d5d4d2a2a 2a14140800 0008141422 222649595f 5f4f474122 2222141408" > /tmp/serial.fifo; sleep 0.2
    echo -e "VFD DRW HEX 0814142222 2241474f5f 5f59492622 2214140800 0008141422 222649595f 5f4f474122 2222141408" > /tmp/serial.fifo; sleep 2
    ;;
  5) # eyes animation
    echo -e "VFD DRW HEX 0814142222 2241474951 5153492622 2214140800 0008141422 2226495151 5349474122 2222141408" > /tmp/serial.fifo; sleep 2
    echo -e "VFD DRW HEX 0814142a2a 2a49594959 5949592a2a 2a14140800 000814142a 2a2a594959 594959492a 2a2a141408" > /tmp/serial.fifo; sleep 0.5
    echo -e "VFD DRW HEX 0814142222 2241474951 5153492622 2214140800 0008141422 2226495151 5349474122 2222141408" > /tmp/serial.fifo; sleep 1
    echo -e "VFD DRW HEX 0814142222 2241414749 5153512a26 2214140800 0008141422 2222474951 5351494722 2222141408" > /tmp/serial.fifo; sleep 2
    echo -e "VFD DRW HEX 0814142222 2241474951 5153492622 2214140800 0008141422 2226495151 5349474122 2222141408" > /tmp/serial.fifo; sleep 1
    echo -e "VFD DRW HEX 0814142a2a 2a49594959 5949592a2a 2a14140800 000814142a 2a2a594959 594959492a 2a2a141408" > /tmp/serial.fifo; sleep 0.5
    echo -e "VFD DRW HEX 0814142222 2241474951 5153492622 2214140800 0008141422 2226495151 5349474122 2222141408" > /tmp/serial.fifo; sleep 1
    echo -e "VFD DRW HEX 0814142222 2241714945 4555493222 2214140800 0008141422 2232494545 5549714122 2222141408" > /tmp/serial.fifo; sleep 1
    echo -e "VFD DRW HEX 0814142222 2241474951 5153492622 2214140800 0008141422 2226495151 5349474122 2222141408" > /tmp/serial.fifo; sleep 1
    echo -e "VFD DRW HEX 0814142a2a 2a49594959 5949592a2a 2a14140800 000814142a 2a2a594959 594959492a 2a2a141408" > /tmp/serial.fifo; sleep 0.5
    echo -e "VFD DRW HEX 0814142222 2241474951 5153492622 2214140800 0008141422 2226495151 5349474122 2222141408" > /tmp/serial.fifo; sleep 2
    ;;
  6)
    echo -e "VFD PUT HEX 0800000000 554922221c 4141414955 497f494949 2a41492222 4934251422 2002081108 0800002004" > /tmp/serial.fifo; sleep 0.5
    echo -e "VFD ANI 9\$7,0,16,80,0,240" > /tmp/serial.fifo
    sleep 5
    ;;
  7)
    echo -e "VFD CMD BGL 64" > /tmp/serial.fifo; sleep 0.5
    echo -e "VFD PUT HEX 0000000000 FF00000000 FF00FF0000 FF00FF00FF FFFFFFFFFF 6355695563 00007f3e1c 2a1c771c2a" > /tmp/serial.fifo; sleep 0.5
    graph=$(date +%r | awk -F':| ' '{
      h=$1+0;
      mins=int($2);
      m=(mins<15)?0:(mins>=15&&mins<30)?1:(mins>=30&&mins<45)?2:(mins>=45)?3:0;
      p=($4~/PM/) ? 6 : ($4~/AM/) ? 7 : 0;
      str="\x25\x255 ";
      for(i=0;i<h;i++) str=str"\x25\x254";
      if (m>0) str=str"\x25\x25"m; else str=str" ";
      for (;i<12;i++) str=str" ";
      if (p>0) print str"\x25\x25"p;
    }');
    echo -e "VFD 1 ${graph}\$1,100,8" > /tmp/serial.fifo
    sleep 20
    ;;
  *)
    ;;
esac

echo -e "VFD CMD RAM CLR" > /tmp/serial.fifo; sleep 1
echo -e "VFD CMD BGL 128" > /tmp/serial.fifo; sleep 0.5
