#!/bin/bash

PID=$$
SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

data_dir="$DIR/data"
states_path="$data_dir/.states"
log_path="$DIR/log/CAFCA.log"
ra_log="$DIR/log/retroarch/retroarch.log"

game_info=$(grep -i -m1 'ACTIVE_GAME' "$data_dir/.settings" | cut -d\' -f2)
cafca_action=$(grep -w -m1 'ACTION' "$data_dir/.settings" | cut -d\' -f2)
cafca_scanmode=$(grep -w -m1 'SCANMODE' "$data_dir/.settings" | cut -d\' -f2)
coin_key=$(grep -w -m1 '^COIN_KEY' "$data_dir/.settings" | cut -d\' -f2)
start_key=$(grep -w -m1 '^START_KEY' "$data_dir/.settings" | cut -d\' -f2)
match_limit=$(grep -w -m1 '^MATCH_LIMIT' "$data_dir/.settings" | cut -d= -f2)
skip_hasdata=$(grep -w -m1 '^SKIP_HASDATA' "$data_dir/.settings" | cut -d= -f2)
scan_debug=$(grep -w -m1 '^SCAN_DEBUG' "$data_dir/.settings" | cut -d= -f2)
debug_ports=$(grep -w -m1 '^DEBUG_PORTS' "$data_dir/.settings" | cut -d\' -f2)

teensy_id="/dev/input/by-id/$(ls -lah /dev/input/by-id | grep -m1 'Teensy' | awk '{print $(NF-2)}')"
serial_fifo='/tmp/serial.fifo'

exception_list=$(grep -w -m1 '^EXCEPTION_LIST' "$data_dir/.settings" | cut -d\' -f2)

declare -Ag data=(); declare -ag regs=(); declare -ag keys=()

# -----------------------------------------------------------------------------------

HAS_DATA=0
GAME_READY=0
IDENTIFIED=0

ADDR=''
VAL=0
LAST_VAL=

# -----------------------------------------------------------------------------------

echo -e "CAFCA $(date '+%F %T')\n"

sudo cp -r "$data_dir/.states.default" "$data_dir/.states"
[ ! -f "$data_dir/credits.log" ] && touch "$data_dir/credits.log"; sudo chown pi:root "$data_dir/credits.log"

T=$((10#$(date +%s)))

printf "C:0\nS:0\nX:0\nT:$T\n" > "$data_dir/credits.log"
printf "$T\n" > "$data_dir/tmp/start_time"

# -----------------------------------------------------------------------------------

Main() {
  echo "ACTION  $cafca_action"
  STATE GAME_LOADED 1
  getData
  waitForGame
  STATE GAME_READY 1

  echo "VFD 4   INSERT COINS\$4,120" > /tmp/serial.fifo

  [[ "${data[SYSTEM]}" == amiga ]] && amigaGame
  [[ ! "${data[SYSTEM]}" =~ .*mame.* ]] && return

  #[[ $cafca_action == SCAN ]] && \
  #[[ $skip_hasdata -eq 1 ]] && \
  #[[ $HAS_DATA -eq 1 ]] && { cafca_action='DUMP'; echo "HAS DATA - setting action to 'DUMP'"; }

  if [[ $cafca_action == SCAN ]]; then
    sleep 5
    scan_coin
    checkMatches
    sleep 1

    if [[ $IDENTIFIED -gt 0 ]]; then getData
      VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15 {print $2}')
      [[ "$VAL" =~ ^[0-9A-Fa-f]+$ ]] && echo "CREDITS $VAL"
      #echo "VFD 0 ${data[REGNAM]^^} $ADDR: $VAL" > "$serial_fifo"; sleep 0.5
      echo "VFD 6 OFFS:${data[OFFSET]} TYPE:${data[REGNAM]^^} ADDR:$ADDR VAL:$VAL" > "$serial_fifo"; sleep 0.5
      echo "LCD 0 ${data[OFFSET]} @${data[REGNAM]^^}:" > "$serial_fifo"; sleep 0.5
      echo "LCD 1 $ADDR: $VAL" > "$serial_fifo"
    fi
  else
    while [[ $(grep -wE -m1 '^X' "$data_dir/credits.log" | cut -d: -f2) -lt 1 ]]; do :; done

    echo -e "CREDITS 1" > "$serial_fifo"

    if [[ $HAS_DATA -gt 0 ]]; then
      [[ "${data[REGNAM]}" == misc ]] && { checkMiscReg; } || { ADDR=$(dump_addr); IDENTIFIED=1; }
      [[ "${data[GAME]}" == @(${exception_list}) ]] && checkException 1 $ADDR &
    fi
  fi

  # ----------------------------------------------------------------------------------------------------------------

  if [[ $(grep -wc "^${data[GAME]}" "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.shooters") -gt 0 ]]; then
    fire_mode=$(grep -w -m1 "${data[GAME]}" "$HOMEDIR/ADMIN/MENU/.assets/GAMES/.shooters" | awk '{print $2}')
    echo -e "0:1 ${fire_mode:-1}" > "$serial_fifo"
  fi

  while [[ $(pgrep -c retroarch) -gt 0 ]]; do

    if [[ $IDENTIFIED -gt 0 ]]; then
      VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15 {print $2}')
      [[ "$VAL" =~ ^[0-9A-Fa-f]+$ ]] && VAL=$VAL || VAL=$LAST_VAL
    else
      VAL=$(grep -wE -m1 '^X' "$data_dir/credits.log" | cut -d: -f2)
    fi

    if [[ $VAL != $LAST_VAL ]]; then
      CREDITS="$VAL"; LAST_VAL=$VAL
      echo "$( (( ${#ADDR} )) && echo $ADDR || echo COINS ) : $VAL ( $CREDITS )"
      echo -e "CREDITS $CREDITS" > "$serial_fifo"; sleep 0.5
      echo "LCD 1 $ADDR: $VAL" > "$serial_fifo";   sleep 0.5
      [[ $CREDITS -gt 0 ]] && [[ $CREDITS -lt 60 ]] && echo "VFD 0 COINS: $((10#$CREDITS))\$5,70" > "$serial_fifo"
    fi
    sleep 1
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

getData() {
  data[GAME]="${game_info#*'/'}"; data[SYSTEM]="${game_info%'/'*}"

  [[ ! "${data[SYSTEM]}" =~ .*mame.* ]] && return

  for file in table timers clearram; do
    if [[ $(grep -wc "^${data[GAME]}" "$data_dir/${data[SYSTEM]}/$file") -eq 0 ]]; then
      echo "${data[GAME]} $([[ $file == timers ]] && echo 1 || { [[ $file == clearram ]] && echo 0; })" | sudo tee -a "$data_dir/${data[SYSTEM]}/$file" &>/dev/null
      cat "$data_dir/${data[SYSTEM]}/$file" | sort -k 1,1 | column -t | sudo tee "$data_dir/${data[SYSTEM]}/$file" &>/dev/null
    fi
  done

  addr_data=$(grep -w -m1 "^${data[GAME]}" "$data_dir/${data[SYSTEM]}/table" | awk '{$1=$1="";print}')

  if [[ $( echo "${addr_data}" | wc -c ) -gt 1 ]]; then
    for i in OFFSET REGNUM REGNAM VARPOS DATYPE; do (( count++ ));
      val=$(echo "$addr_data" | awk -v pos="$count" '{print $pos}'); data["$i"]="$val";
    done
    HAS_DATA=1
    for n in GAME SYSTEM OFFSET REGNUM REGNAM VARPOS DATYPE; do printf "%s\t%s\n" "$n" "${data[$n]}"; done; echo ""
  else
    echo -e "GAME:   ${data[GAME]}\nSYSTEM: ${data[SYSTEM]}\n - NO DATA FOUND!"
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

dump_addr() {
  scan_args="option region_scan_level 3; reset; dregions !${data[REGNUM]}; lregions; exit"
  REG_OFFS=$(sudo scanmem -p `pidof retroarch` -c"$scan_args" 2>&1 |& grep --line-buffered -A1 "lregions" | awk 'NR==2' | awk '$1=$1 {print}' | cut -d] -f2 | awk -F" " '{print $1}' | cut -d, -f1);REG_OFFS="0x${REG_OFFS}"
  printf -v ADDR "0x%X\n" $(( REG_OFFS + ${data[OFFSET]} )) &>/dev/null; echo "${ADDR,,}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkMiscReg() {
  local COINS_LAST=

  regs+=("${data[REGNUM]}")
  for i in {1..10}; do regs+=("$(( ${data[REGNUM]} - i ))"); regs+=("$(( ${data[REGNUM]} + i ))"); done

  for reg in "${regs[@]}"; do
    data[REGNUM]="$reg"; ADDR=$(dump_addr)
    VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
    COINS=$(grep -E -m1 '^X' "$data_dir/credits.log" | cut -d: -f2)
    [[ "$VAL" =~ ^[0-9A-Fa-f]+$ ]] && [[ $(echo "$((16#$VAL))") -eq $COINS ]] && IDENTIFIED=1 || IDENTIFIED=0

    echo -e "REGNUM: ${data[REGNUM]}, ADDR: $ADDR, VAL: $VAL\n"
    [[ $IDENTIFIED -gt 0 ]] && break
  done

  [[ $IDENTIFIED -gt 0 ]] && { COINS_LAST=$COINS; echo "MATCH FOUND! Waiting for START press.."; } || echo "NO MATCH.."

  while [[ $(grep -E -m1 '^S' "$data_dir/credits.log" | cut -d: -f2) -lt 1 ]]; do
    COINS=$(grep -E -m1 '^C' "$data_dir/credits.log" | cut -d: -f2);
    [[ $COINS -ne $COINS_LAST ]] && { echo -e "CREDITS $COINS" > "$serial_fifo"; COINS_LAST=$COINS; }
  done

  VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
  COINS=$(grep -E -m1 '^X' "$data_dir/credits.log" | cut -d: -f2)
  [[ "$VAL" =~ ^[0-9A-Fa-f]+$ ]] && [[ $(echo "$((16#$VAL))") -eq $COINS ]] && IDENTIFIED=1 || IDENTIFIED=0

  echo -e "\nREGNUM: ${data[REGNUM]}, ADDR: $ADDR, VAL: $VAL "
  [[ $IDENTIFIED -gt 0 ]] && echo "- IDENTIFIED!" || echo "- NO MATCH.."
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

scan_coin() {
  printf '' > "$DIR/log/expect.log"

  /usr/bin/expect -c '
    log_user 1
    exp_internal 0

    set timeout -1
    set debug '"$scan_debug"'
    set ports '"$debug_ports"'
    set scanmode '"$cafca_scanmode"'
    set teensy_id '"$teensy_id"'
    set coin_key '"$coin_key"'
    set coin_file '"$DIR/data/credits.log"'
    set exp_log '"$DIR/log/expect.log"'
    set match_limit '"$match_limit"'
    set matches 999
    set matches_last 998
    set ready 0
    set credits 1
    set retries 0
    set retry_limit 6
    set last_credits 0

    set pid [exec pidof retroarch]

    # ------------------------------------------------------------

    log_file "$exp_log"

    spawn scanmem -p $pid

    proc wait { time } {
      send_user "waiting $time seconds..\n"
      set t_bak $::timeout
      set ::timeout $time
      expect -exact "<%SLEEPTIMER%>" { timeout abort }
      set ::timeout $t_bak
    }

    proc startscan {} {
      expect {
        "Please" {
          sleep 1
          send "option region_scan_level 3\rreset\r"
          sleep 1
          exp_continue
        }
        "*suitable*" {
          set ::ready 1
          sleep 1
        }
      }

      if {$::scanmode == "AUTO"} {
        insert_coin
        sleep 1

        while {$::matches > $::match_limit} {
          get_coin

          if {$::matches < $::retry_limit} {
            if {$::matches == $::matches_last} {
              set ::retries [expr {$::retries + 1}]
              if {$::retries > $::match_limit} {
                send "exit\r"
                break
              }
            } else {
              send "list\r"
            }
          }
          set ::matches_last $::matches
        }

        sleep 1

        expect "* 0*" {
          sleep 1
          send "exit\r"
        }
      } else {
        send_user "\nMANUAL MODE\n- insert coin now.\n"
        debug "MANUAL SCANMODE." "VFD:1" "LCD:0"

        while {$::matches > $::match_limit} {
          get_coin
        }

        #debug "$::matches matches!" "VFD:1" "LCD:0"
        debug "Listing matches!" "VFD:3" "LCD:0"
        send "list\r"; sleep 1

        expect "* 0*" {
          sleep 1
          #debug "CAFCA DONE...!" "VFD:6" "LCD:0"
          send "exit\r"
        }
      }
    }

    proc get_coin {} {
      set ::credits [exec grep -m1 '^X' "$::coin_file" | cut -d: -f2 ]

      sleep 1

      if {$::credits != $::last_credits} {
        set coins [exec grep -m1 '^C' "$::coin_file" | cut -d: -f2 ]
        set ::last_credits $::credits

        if {$coins == 1} {
          debug "Scanning regions" "VFD:3"
        }
        sleep 1
        send "$::credits\r"
        sleep 1

        expect {
          "*currently*" {
            set ::matches [lindex [split [lindex [split $expect_out(buffer) "\n"] end-1 ] " " ] end-1 ]

	    debug "$::matches matches." "VFD:1" "LCD:0"
            sleep 1

            if {$::matches == "0"} {
              set ::matches 999
              send "option region_scan_level 3\rreset\r$::credits\r"
            } elseif {$::matches == "other"} {
              set ::matches 1
            } else {
              if {$::scanmode == "AUTO"} {
                insert_coin
              }
            }
          }
        }
      }
    }

    proc insert_coin {} {
      exec evemu-event $::teensy_id --type EV_KEY --code $::coin_key --value 1 --sync
      exec evemu-event $::teensy_id --type EV_KEY --code $::coin_key --value 0 --sync
    }


    proc debug { args } {
      set msg [lindex $args 0]
      set msg_len [string length $msg]
      set args [lrange $args 1 end]
      set args_len [llength $args]

      if { $msg_len < 1 } { return; }
      if { $args_len < 1 } { set args { "LCD" } }

      for {set i 0} {$i < [llength $args]} {incr i}  {
        set str [lindex $args $i]

        if {[string match "*:*" $str]} {
          set parts [split $str ":"]
          set dev [lindex $parts 0]
          set mode [lindex $parts end]
        } else {
          set dev $str
          set mode 0
        }

        set cmd "$dev $mode $msg"
        if { $dev == "VFD" } { set cmd "$cmd\$$mode,100,5" }

        exec echo "$cmd" > /tmp/serial.fifo
        sleep 0.5
      }
    }

    startscan
    close
    expect eof
    wait
  '
  sudo sed -i 's/\r//g' "$DIR/log/expect.log"
  echo ""
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkMatches() {
  local LINE=
  local REGNAM=
  local DUMP=''
  local action_key=$coin_key
  local match_index=0
  local COINS=$(grep -wE -m1 '^X' "$DIR/data/credits.log" | cut -d: -f2)
  local STARTS=$(grep -wE -m1 '^S' "$DIR/data/credits.log" | cut -d: -f2)
  local match_data=$(tac "$DIR/log/expect.log" | grep -Pn -m1 '^\[.*?[[:digit:]]\]' | awk -F '\[|\]' '{gsub(/\ /, "", $2);print $1$2}')
  local LN=$(echo "$match_data" | cut -d: -f1)
  local VL=$(echo "$match_data" | cut -d: -f2)
  declare -a MATCHES=()

  [[ $STARTS -eq 0 ]] && action_key=$start_key
  for state in {1..0}; do evemu-event "$teensy_id" --type EV_KEY --code $action_key --value $state --sync; sleep 0.2; done; sleep 2

  COINS=$(grep -wE -m1 '^X' "$DIR/data/credits.log" | cut -d: -f2)

  echo -e "COINS:   $COINS"
  echo -e "$(grep ACTIVE_GAME $DIR/data/.settings | cut -d\' -f2):\n" > "$DIR/data/tmp/matches.log"

  for (( i=LN; i<=$(( LN + VL )); i++)); do
    LINE=$(tac "$DIR/log/expect.log" | awk -F '\[.*?[[:digit:]].*?|\]\ ' -v ln="$i" 'NR==ln {print $2}' | awk '{gsub(/\ \+/,",");gsub(/  +/," "); sub(/^ /,"");$1="0x"$1;$3="0x"$3" "$2;$2="";print}' | sed 's/ //; s/, / /g; s/ \]/\]/g' | sed -E ':a; s/(\[[^]\ ]*)[[:blank:]] */\1\,/; ta; s/\[([^]]*)\]/\1/g')
    ADDR=$(echo "$LINE" | awk '{print $1}')
    VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15 {print $2}'); sleep 0.5
    [[ $((16#$VAL)) -eq $COINS ]] && MATCHES+=("$LINE $VAL")
  done

  echo -e "MATCHES: ${#MATCHES[@]}"

  for (( i=${#MATCHES[@]}-1; i>=0; i-- )); do
    MATCH="${MATCHES[$i]}"
    ADDR=$(echo "$MATCH" | awk '{print $1}')
    REGNAM=$(echo "$MATCH" | awk '{print $4}')
    LAST_VAL=$(echo "$MATCH" | grep -o '[^ ]*$')
    IDENTIFIED=1

    DUMP=$(echo "$MATCH" | awk '{reg=substr($4,1,1); print $2,$3,toupper(reg)}')
    #echo -e "LCD 0 $DUMP:" > /tmp/serial.fifo; sleep 0.1

    echo -e "\nMATCH $match_index:"
    echo -e "  ADDR:       '$ADDR'"
    echo -e "  REGNAM:     '$REGNAM'"
    echo -e "  LAST_VAL:   '$LAST_VAL'"
    echo -n "  VAL(S):      "

    for i in {1..3}; do
      VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15 {print $2}'); sleep 0.5
      echo -n "$VAL.."
      #echo -e "LCD 1 $ADDR: $VAL" > /tmp/serial.fifo; sleep 0.1

      [[ $((16#$VAL)) -ne $((16#$LAST_VAL)) ]] && { IDENTIFIED=0; break; }
    done
    echo -e ""
    echo -e "  IDENTIFIED:  $IDENTIFIED"

    if [[ $IDENTIFIED -gt 0 ]]; then
       DUMP=$(echo "${MATCH}" | cut -d' ' -f2- | awk '{$NF=""; print $0}')
       echo "${DUMP}" >> "$DIR/data/tmp/matches.log"
       echo -e "  DUMP:       '${DUMP}'"
       break
       #echo -e "LCD 1 IDENTIFIED! ($VAL)" > /tmp/serial.fifo; sleep 0.1
       #echo -e "VFD 6 $(echo "$DUMP" | awk '{print "IDENTIFIED ADDR",$1,"AT OFFSET",$2,"IN REGION",$4,"(TYPE \x27"toupper($3)"\x27)"}')" > /tmp/serial.fifo; sleep 0.1
       #[[ $REGNAM == code ]] || [[ ${#MATCHES[@]} -eq 1 ]] && break
    fi
    echo -e "\n________________________________\n"

    (( match_index++ ))
  done

  if [[ $IDENTIFIED -gt 0 ]]; then
    echo -e "\nSUCCES!\n"

    [[ $(grep -w -m1 "^${data[GAME]}" "$data_dir/${data[SYSTEM]}/table" | awk '{print NF}') -gt 1 ]] && [[ $skip_hasdata -eq 1 ]] && return

    sudo cp "$data_dir/${data[SYSTEM]}/table" "$data_dir/${data[SYSTEM]}/table.bak$(date +%y%m%d%H%M%S)"
    sudo sed -i "/${data[GAME]}\(\s\|$\).*$/ s/\(\s\|$\).*$/ ${DUMP}/" "$data_dir/${data[SYSTEM]}/table"
    cat "$data_dir/${data[SYSTEM]}/table" | column -t | sudo tee "$data_dir/${data[SYSTEM]}/table.tmp" &>/dev/null
    sudo mv -f "$data_dir/${data[SYSTEM]}/table.tmp" "$data_dir/${data[SYSTEM]}/table"
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

pressKey() {
  [[ ${#keys[@]} -lt 1 ]] && keys=($(sudo timeout 1 evtest "$teensy_id" |& awk '{$1=$1;print}' | grep '^Event' | awk -F'\(|\)' '{print $2}' | grep '^KEY'))

  if [[ $# -gt 0 ]]; then
    local KEY="$@"
    [[ "${KEYS[@]}" =~ "$KEY" ]] && for state in {1..0}; do evemu-event "$teensy_id" --type EV_KEY --code "$KEY" --value "$state" --sync; sleep 0.2; done
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

waitForGame() {
  local words=('hiscore.dat' 'SET_GEOMETRY')
  while [[ $GAME_READY -lt 1 ]]; do GAME_READY=$(cat "$ra_log" | grep -Ec "$(for w in $(echo ${words[@]} | tr ' ' ' | '); do echo *$w*; done)"); done

  [[ "${data[SYSTEM]}" == amiga ]] && sleep 5
  [[ ! "${data[SYSTEM]}" =~ .*mame.* ]] && return

  local T_LOAD=$(grep -w -m1 "^${data[GAME]}" "$data_dir/${data[SYSTEM]}/timers" | grep -o '[^ ]*$')
  while [[ $((10#$(date +%s)-T)) -lt $T_LOAD ]]; do :; done

  echo -e "\nGAME_READY!\n"
  checkException 0
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

STATE() {
  [ $# -lt 2 ] && return
  local KEY="${1^^}"; local VAL="${2}"; local SER=${3:-1}
  [[ $(printf "${VAL}" | grep -Ec "[[:alpha:]]") -gt 0 ]] && VAL="'${VAL}'"

  if [[ $(grep -ic "$KEY" "$data_dir/.states") -gt 0 ]]; then
    sudo sed -i "s/^$KEY.*/$KEY=$VAL/g" "$data_dir/.states"
    [[ $SER -gt 0 ]] && echo -e "$KEY $VAL" > "$serial_fifo"
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkException() {
  local param1="${1}"
  local param2="${2}"

  case "${data[GAME]}" in
    'blktiger')
      local coin_state=1
      local acc_addr=$(printf "0x%x\n" $(( ADDR - 0xe40 )))
      local acc_val=

      while [[ $(pgrep -c retroarch) -gt 0 ]]; do
        acc_val=$(sudo scanmem -p `pidof retroarch` -c"dump $acc_addr 1;exit" 2>&1 | awk 'NR==15' | awk '{print $2}')
        [[ $acc_val == 00 ]] && [[ $coin_state -eq 0 ]] && { echo "COIN_POWER 1"; echo -e "COIN_POWER 1" > /tmp/serial.fifo; coin_state=1; } || { \
        [[ $acc_val == 20 ]] && [[ $coin_state -eq 1 ]] && { echo "COIN_POWER 0"; echo -e "COIN_POWER 0" > /tmp/serial.fifo; coin_state=0; }; }
      done
      ;;
    *)
      ;;
  esac
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

amigaGame() {
  local TIMER=$((10#$(date +%s)))
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
  while [[ $(grep -wE -m1 '^C' "$data_dir/credits.log" | cut -d: -f2) -lt 1 ]]; do [[ $((10#$(date +%s)-TIMER)) -ge 30 ]] && { echo -e "VFD 1  INSERT COIN NOW\$1,100,10" > "$serial_fifo"; TIMER=$((10#$(date +%s))); }; done
  echo -e "VFD 6   GAME READY!" > "$serial_fifo"
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
  while [[ $(pgrep -c retroarch) -gt 0 ]]; do :; done
}


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  echo -e "GAME_STOPPED 1" >> "$serial_fifo"
  STATE 'GAME_READY' '0'; STATE 'GAME_LOADED' '0'

  if [[ "${data[SYSTEM]}" == mame-libretro ]]; then
    local clearRam=$(grep -m1 "^${data[GAME]}" "$data_dir/${data[SYSTEM]}/clearram" | awk '{print $2}')
    local nvRamPath="$HOMEDIR/RetroPie/roms/${data[SYSTEM]}/mame2003/nvram/${data[GAME]}.nv"

    if [ -f "$nvRamPath" ]; then
      [[ $clearRam -gt 0 ]] && sudo chattr +i "$nvRamPath" || sudo chattr -i "$nvRamPath"
    fi
  fi

  JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" > /dev/null 2>&1
  exit
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

trap 'exitFunc' EXIT SIGINT INT

[[ ${#game_info} -gt 0 ]] && Main


exit 0











# ___________________________________________________________________________________
#
# ˅ IGNORE ˅
